/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;
import org.onosproject.net.resource.ContinuousResourceId;
import org.onosproject.net.resource.ResourceId;
import org.onosproject.net.resource.Resources;

@Beta
public final class DiscreteResourceId
extends ResourceId {
    private final ImmutableList<Object> components;

    DiscreteResourceId(ImmutableList<Object> components) {
        this.components = components;
    }

    DiscreteResourceId() {
        this.components = ImmutableList.of();
    }

    @Override
    ImmutableList<Object> components() {
        return this.components;
    }

    @Override
    String simpleTypeName() {
        if (this.isRoot()) {
            return "Root";
        }
        return this.lastComponent().getClass().getSimpleName();
    }

    @Override
    boolean isTypeOf(Class<?> type) {
        if (this.isRoot()) {
            return false;
        }
        return type.isAssignableFrom(this.lastComponent().getClass());
    }

    @Override
    boolean isSubTypeOf(Class<?> ancestor) {
        return this.components.stream().filter(x -> ancestor.isAssignableFrom(x.getClass())).findAny().isPresent();
    }

    @Override
    public DiscreteResourceId child(Object child) {
        Preconditions.checkArgument((!(child instanceof Class) ? 1 : 0) != 0);
        return Resources.discrete(this, child).id();
    }

    @Override
    public ContinuousResourceId child(Class<?> child) {
        Preconditions.checkNotNull(child);
        return Resources.continuous(this, child).id();
    }

    @Override
    public Optional<DiscreteResourceId> parent() {
        if (this.isRoot()) {
            return Optional.empty();
        }
        if (this.components.size() == 1) {
            return Optional.of(ROOT);
        }
        return Optional.of(new DiscreteResourceId((ImmutableList<Object>)this.components.subList(0, this.components.size() - 1)));
    }

    <T> Optional<T> lastComponentAs(Class<T> type) {
        if (!this.isTypeOf(type)) {
            return Optional.empty();
        }
        Object value = this.lastComponent();
        return Optional.of(value);
    }

    private boolean isRoot() {
        return this.components.isEmpty();
    }

    private Object lastComponent() {
        return this.components.get(this.components.size() - 1);
    }

    public int hashCode() {
        return this.components.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DiscreteResourceId other = (DiscreteResourceId)obj;
        return Objects.equals(this.components, other.components);
    }

    public String toString() {
        return this.components.toString();
    }
}

