/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceConsumerId;

@Beta
public class ResourceAllocation {
    private final Resource resource;
    private final ResourceConsumerId consumerId;

    public ResourceAllocation(Resource resource, ResourceConsumerId consumerId) {
        this.resource = (Resource)Preconditions.checkNotNull((Object)resource);
        this.consumerId = (ResourceConsumerId)Preconditions.checkNotNull((Object)consumerId);
    }

    public ResourceAllocation(Resource resource, ResourceConsumer consumer) {
        this(resource, ((ResourceConsumer)Preconditions.checkNotNull((Object)consumer)).consumerId());
    }

    private ResourceAllocation() {
        this.resource = null;
        this.consumerId = null;
    }

    public Resource resource() {
        return this.resource;
    }

    public ResourceConsumerId consumerId() {
        return this.consumerId;
    }

    public int hashCode() {
        return Objects.hash(this.resource, this.consumerId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceAllocation)) {
            return false;
        }
        ResourceAllocation that = (ResourceAllocation)obj;
        return Objects.equals(this.resource, that.resource) && Objects.equals(this.consumerId, that.consumerId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("resource", (Object)this.resource).add("consumerId", (Object)this.consumerId).toString();
    }
}

