/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.onlab.rest.BaseResource;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.JsonCodec;

public class AbstractWebResource
extends BaseResource
implements CodecContext {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public ObjectMapper mapper() {
        return this.mapper;
    }

    @Override
    public <T> JsonCodec<T> codec(Class<T> entityClass) {
        return ((CodecService)this.get(CodecService.class)).getCodec(entityClass);
    }

    protected <T> ObjectNode encodeArray(Class<T> codecClass, String field, Iterable<T> items) {
        ObjectNode result = this.mapper().createObjectNode();
        result.set(field, (JsonNode)this.codec(codecClass).encode(items, (CodecContext)this));
        return result;
    }

    @Override
    public <T> T getService(Class<T> serviceClass) {
        return (T)this.get(serviceClass);
    }

    public ObjectNode newObject(ObjectNode parent, String key) {
        ObjectNode node = this.mapper.createObjectNode();
        parent.set(key, (JsonNode)node);
        return node;
    }

    public ArrayNode newArray(ObjectNode parent, String key) {
        ArrayNode node = this.mapper.createArrayNode();
        parent.set(key, (JsonNode)node);
        return node;
    }
}

