/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import com.google.common.base.Throwables;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.onosproject.store.service.AsyncAtomicCounterMap;
import org.onosproject.store.service.AtomicCounterMap;
import org.onosproject.store.service.ConsistentMapException;
import org.onosproject.store.service.Synchronous;

public class DefaultAtomicCounterMap<K>
extends Synchronous<AsyncAtomicCounterMap<K>>
implements AtomicCounterMap<K> {
    private final AsyncAtomicCounterMap<K> asyncCounterMap;
    private final long operationTimeoutMillis;

    public DefaultAtomicCounterMap(AsyncAtomicCounterMap<K> asyncCounterMap, long operationTimeoutMillis) {
        super(asyncCounterMap);
        this.asyncCounterMap = asyncCounterMap;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public long incrementAndGet(K key) {
        return this.complete(this.asyncCounterMap.incrementAndGet(key));
    }

    @Override
    public long decrementAndGet(K key) {
        return this.complete(this.asyncCounterMap.decrementAndGet(key));
    }

    @Override
    public long getAndIncrement(K key) {
        return this.complete(this.asyncCounterMap.getAndIncrement(key));
    }

    @Override
    public long getAndDecrement(K key) {
        return this.complete(this.asyncCounterMap.getAndDecrement(key));
    }

    @Override
    public long addAndGet(K key, long delta) {
        return this.complete(this.asyncCounterMap.addAndGet(key, delta));
    }

    @Override
    public long getAndAdd(K key, long delta) {
        return this.complete(this.asyncCounterMap.getAndAdd(key, delta));
    }

    @Override
    public long get(K key) {
        return this.complete(this.asyncCounterMap.get(key));
    }

    @Override
    public long put(K key, long newValue) {
        return this.complete(this.asyncCounterMap.put(key, newValue));
    }

    @Override
    public long putIfAbsent(K key, long newValue) {
        return this.complete(this.asyncCounterMap.putIfAbsent(key, newValue));
    }

    @Override
    public boolean replace(K key, long expectedOldValue, long newValue) {
        return this.complete(this.asyncCounterMap.replace(key, expectedOldValue, newValue));
    }

    @Override
    public long remove(K key) {
        return this.complete(this.asyncCounterMap.remove(key));
    }

    @Override
    public boolean remove(K key, long value) {
        return this.complete(this.asyncCounterMap.remove(key, value));
    }

    @Override
    public int size() {
        return this.complete(this.asyncCounterMap.size());
    }

    @Override
    public boolean isEmpty() {
        return this.complete(this.asyncCounterMap.isEmpty());
    }

    @Override
    public void clear() {
        this.complete(this.asyncCounterMap.clear());
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ConsistentMapException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new ConsistentMapException.Timeout(this.name());
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new ConsistentMapException(e.getCause());
        }
    }
}

