/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public class MultimapEvent<K, V> {
    private final String name;
    private final Type type;
    private final K key;
    private final V newValue;
    private final V oldValue;

    public MultimapEvent(String name, K key, V newValue, V oldValue) {
        this.name = name;
        this.key = key;
        this.newValue = newValue;
        this.oldValue = oldValue;
        this.type = newValue != null ? Type.INSERT : Type.REMOVE;
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public K key() {
        return this.key;
    }

    public V newValue() {
        return this.newValue;
    }

    public V oldValue() {
        return this.oldValue;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MultimapEvent)) {
            return false;
        }
        MultimapEvent that = (MultimapEvent)o;
        return Objects.equals(this.name, that.name) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.key, that.key) && Objects.equals(this.newValue, that.newValue) && Objects.equals(this.oldValue, that.oldValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.key, this.newValue, this.oldValue});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("name", (Object)this.name).add("type", (Object)this.type).add("key", this.key).add("newValue", this.newValue).add("oldValue", this.oldValue).toString();
    }

    public static enum Type {
        INSERT,
        REMOVE;

    }
}

