/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flowapi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.onosproject.flowapi.ExtDscpValue;
import org.onosproject.flowapi.ExtFlowTypes;
import org.onosproject.flowapi.ExtOperatorValue;

public class DefaultExtDscpValue
implements ExtDscpValue {
    private List<ExtOperatorValue> dscpValue;
    private ExtFlowTypes.ExtType type;

    DefaultExtDscpValue(List<ExtOperatorValue> dscpValue, ExtFlowTypes.ExtType type) {
        this.dscpValue = dscpValue;
        this.type = type;
    }

    @Override
    public ExtFlowTypes.ExtType type() {
        return this.type;
    }

    @Override
    public List<ExtOperatorValue> dscpValue() {
        return this.dscpValue;
    }

    @Override
    public boolean exactMatch(ExtDscpValue value) {
        return this.equals(value) && Objects.equals(this.dscpValue, value.dscpValue()) && Objects.equals((Object)this.type, (Object)value.type());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dscpValue, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultExtDscpValue) {
            DefaultExtDscpValue that = (DefaultExtDscpValue)obj;
            return Objects.equals(this.dscpValue, that.dscpValue()) && Objects.equals((Object)this.type, (Object)that.type());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dscpValue", (Object)this.dscpValue.toString()).add("type", (Object)this.type.toString()).toString();
    }

    public static class Builder
    implements ExtDscpValue.Builder {
        private List<ExtOperatorValue> dscpValue;
        private ExtFlowTypes.ExtType type;

        @Override
        public Builder setDscpValue(List<ExtOperatorValue> dscpValue) {
            this.dscpValue = dscpValue;
            return this;
        }

        @Override
        public Builder setType(ExtFlowTypes.ExtType type) {
            this.type = type;
            return this;
        }

        @Override
        public ExtDscpValue build() {
            Preconditions.checkNotNull(this.dscpValue, (Object)"dscpValue cannot be null");
            return new DefaultExtDscpValue(this.dscpValue, this.type);
        }
    }
}

