/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flowapi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.onosproject.flowapi.ExtFlowTypes;
import org.onosproject.flowapi.ExtIcmpCode;
import org.onosproject.flowapi.ExtOperatorValue;

public class DefaultExtIcmpCode
implements ExtIcmpCode {
    private List<ExtOperatorValue> icmpCode;
    private ExtFlowTypes.ExtType type;

    DefaultExtIcmpCode(List<ExtOperatorValue> icmpCode, ExtFlowTypes.ExtType type) {
        this.icmpCode = icmpCode;
        this.type = type;
    }

    @Override
    public ExtFlowTypes.ExtType type() {
        return this.type;
    }

    @Override
    public List<ExtOperatorValue> icmpCode() {
        return this.icmpCode;
    }

    @Override
    public boolean exactMatch(ExtIcmpCode icmpCode) {
        return this.equals(icmpCode) && Objects.equals(this.icmpCode, icmpCode.icmpCode()) && Objects.equals((Object)this.type, (Object)icmpCode.type());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.icmpCode, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultExtIcmpCode) {
            DefaultExtIcmpCode that = (DefaultExtIcmpCode)obj;
            return Objects.equals(this.icmpCode, that.icmpCode()) && Objects.equals((Object)this.type, (Object)that.type());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("icmpCode", (Object)this.icmpCode.toString()).add("type", (Object)this.type.toString()).toString();
    }

    public static class Builder
    implements ExtIcmpCode.Builder {
        private List<ExtOperatorValue> icmpCode;
        private ExtFlowTypes.ExtType type;

        @Override
        public Builder setIcmpCode(List<ExtOperatorValue> icmpCode) {
            this.icmpCode = icmpCode;
            return this;
        }

        @Override
        public Builder setType(ExtFlowTypes.ExtType type) {
            this.type = type;
            return this;
        }

        @Override
        public ExtIcmpCode build() {
            Preconditions.checkNotNull(this.icmpCode, (Object)"icmpCode cannot be null");
            return new DefaultExtIcmpCode(this.icmpCode, this.type);
        }
    }
}

