/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flowapi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.onosproject.flowapi.ExtFlowTypes;
import org.onosproject.flowapi.ExtIpProtocol;
import org.onosproject.flowapi.ExtOperatorValue;

public final class DefaultExtIpProtocol
implements ExtIpProtocol {
    private List<ExtOperatorValue> ipProtocol;
    private ExtFlowTypes.ExtType type;

    DefaultExtIpProtocol(List<ExtOperatorValue> ipProtocol, ExtFlowTypes.ExtType type) {
        this.ipProtocol = ipProtocol;
        this.type = type;
    }

    @Override
    public ExtFlowTypes.ExtType type() {
        return this.type;
    }

    @Override
    public List<ExtOperatorValue> ipProtocol() {
        return this.ipProtocol;
    }

    @Override
    public boolean exactMatch(ExtIpProtocol ipProto) {
        return this.equals(ipProto) && Objects.equals(this.ipProtocol, ipProto.ipProtocol()) && Objects.equals((Object)this.type, (Object)ipProto.type());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ipProtocol, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultExtIpProtocol) {
            DefaultExtIpProtocol that = (DefaultExtIpProtocol)obj;
            return Objects.equals(this.ipProtocol, that.ipProtocol()) && Objects.equals((Object)this.type, (Object)that.type);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ipProtocol", (Object)this.ipProtocol.toString()).add("type", (Object)this.type.toString()).toString();
    }

    public static class Builder
    implements ExtIpProtocol.Builder {
        private List<ExtOperatorValue> ipProtocol;
        private ExtFlowTypes.ExtType type;

        @Override
        public Builder setIpProtocol(List<ExtOperatorValue> ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        @Override
        public Builder setType(ExtFlowTypes.ExtType type) {
            this.type = type;
            return this;
        }

        @Override
        public ExtIpProtocol build() {
            Preconditions.checkNotNull(this.ipProtocol, (Object)"Ip protocol cannot be null");
            return new DefaultExtIpProtocol(this.ipProtocol, this.type);
        }
    }
}

