/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flowapi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.flowapi.ExtFlowTypes;
import org.onosproject.flowapi.ExtKeyName;

public class DefaultExtKeyName
implements ExtKeyName {
    private String keyName;
    private ExtFlowTypes.ExtType type;

    DefaultExtKeyName(String keyName, ExtFlowTypes.ExtType type) {
        this.keyName = keyName;
        this.type = type;
    }

    @Override
    public ExtFlowTypes.ExtType type() {
        return this.type;
    }

    @Override
    public String keyName() {
        return this.keyName;
    }

    @Override
    public boolean exactMatch(ExtKeyName value) {
        return this.equals(value) && Objects.equals(this.keyName, value.keyName()) && Objects.equals((Object)this.type, (Object)value.type());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.keyName, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultExtKeyName) {
            DefaultExtKeyName that = (DefaultExtKeyName)obj;
            return Objects.equals(this.keyName, that.keyName()) && Objects.equals((Object)this.type, (Object)that.type());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("keyName", (Object)this.keyName.toString()).add("type", (Object)this.type.toString()).toString();
    }

    public static class Builder
    implements ExtKeyName.Builder {
        private String keyName;
        private ExtFlowTypes.ExtType type;

        @Override
        public Builder setKeyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        @Override
        public Builder setType(ExtFlowTypes.ExtType type) {
            this.type = type;
            return this;
        }

        @Override
        public ExtKeyName build() {
            Preconditions.checkNotNull((Object)this.keyName, (Object)"keyName cannot be null");
            return new DefaultExtKeyName(this.keyName, this.type);
        }
    }
}

