/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flowapi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.onosproject.flowapi.ExtFlowTypes;
import org.onosproject.flowapi.ExtOperatorValue;
import org.onosproject.flowapi.ExtPacketLength;

public class DefaultExtPacketLength
implements ExtPacketLength {
    private List<ExtOperatorValue> packetLength;
    private ExtFlowTypes.ExtType type;

    DefaultExtPacketLength(List<ExtOperatorValue> packetLength, ExtFlowTypes.ExtType type) {
        this.packetLength = packetLength;
        this.type = type;
    }

    @Override
    public ExtFlowTypes.ExtType type() {
        return this.type;
    }

    @Override
    public List<ExtOperatorValue> packetLength() {
        return this.packetLength;
    }

    @Override
    public boolean exactMatch(ExtPacketLength length) {
        return this.equals(this.packetLength) && Objects.equals(this.packetLength, length.packetLength()) && Objects.equals((Object)this.type, (Object)length.type());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.packetLength, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultExtPacketLength) {
            DefaultExtPacketLength that = (DefaultExtPacketLength)obj;
            return Objects.equals(this.packetLength, that.packetLength()) && Objects.equals((Object)this.type, (Object)that.type());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("packetLength", (Object)this.packetLength.toString()).add("type", (Object)this.type.toString()).toString();
    }

    public static class Builder
    implements ExtPacketLength.Builder {
        private List<ExtOperatorValue> packetLength;
        private ExtFlowTypes.ExtType type;

        @Override
        public Builder setPacketLength(List<ExtOperatorValue> packetLength) {
            this.packetLength = packetLength;
            return this;
        }

        @Override
        public Builder setType(ExtFlowTypes.ExtType type) {
            this.type = type;
            return this;
        }

        @Override
        public ExtPacketLength build() {
            Preconditions.checkNotNull(this.packetLength, (Object)"packetLength cannot be null");
            return new DefaultExtPacketLength(this.packetLength, this.type);
        }
    }
}

