/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flowapi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.onosproject.flowapi.ExtFlowTypes;
import org.onosproject.flowapi.ExtOperatorValue;
import org.onosproject.flowapi.ExtPort;

public class DefaultExtPort
implements ExtPort {
    private List<ExtOperatorValue> port;
    private ExtFlowTypes.ExtType type;

    DefaultExtPort(List<ExtOperatorValue> port, ExtFlowTypes.ExtType type) {
        this.port = port;
        this.type = type;
    }

    @Override
    public ExtFlowTypes.ExtType type() {
        return this.type;
    }

    @Override
    public List<ExtOperatorValue> port() {
        return this.port;
    }

    @Override
    public boolean exactMatch(ExtPort port) {
        return this.equals(port) && Objects.equals(this.port, port.port()) && Objects.equals((Object)this.type, (Object)port.type());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.port, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultExtPort) {
            DefaultExtPort that = (DefaultExtPort)obj;
            return Objects.equals(this.port, that.port()) && Objects.equals((Object)this.type, (Object)that.type());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("port", (Object)this.port.toString()).add("type", (Object)this.type.toString()).toString();
    }

    public static class Builder
    implements ExtPort.Builder {
        private List<ExtOperatorValue> port;
        private ExtFlowTypes.ExtType type;

        @Override
        public Builder setPort(List<ExtOperatorValue> port) {
            this.port = port;
            return this;
        }

        @Override
        public Builder setType(ExtFlowTypes.ExtType type) {
            this.type = type;
            return this;
        }

        @Override
        public ExtPort build() {
            Preconditions.checkNotNull(this.port, (Object)"port cannot be null");
            return new DefaultExtPort(this.port, this.type);
        }
    }
}

