/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flowapi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.onlab.packet.IpPrefix;
import org.onosproject.flowapi.ExtFlowTypes;
import org.onosproject.flowapi.ExtPrefix;

public final class DefaultExtPrefix
implements ExtPrefix {
    private List<IpPrefix> prefix;
    private ExtFlowTypes.ExtType type;

    DefaultExtPrefix(List<IpPrefix> prefix, ExtFlowTypes.ExtType type) {
        this.prefix = prefix;
        this.type = type;
    }

    @Override
    public ExtFlowTypes.ExtType type() {
        return this.type;
    }

    @Override
    public List<IpPrefix> prefix() {
        return this.prefix;
    }

    @Override
    public boolean exactMatch(ExtPrefix prefix) {
        return this.equals(prefix) && Objects.equals(this.prefix, prefix.prefix()) && Objects.equals((Object)this.type, (Object)prefix.type());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.prefix, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultExtPrefix) {
            DefaultExtPrefix that = (DefaultExtPrefix)obj;
            return Objects.equals(this.prefix, that.prefix()) && Objects.equals((Object)this.type, (Object)that.type);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("prefix", (Object)this.prefix.toString()).add("type", (Object)this.type.toString()).toString();
    }

    public static class Builder
    implements ExtPrefix.Builder {
        private List<IpPrefix> prefix = new ArrayList<IpPrefix>();
        private ExtFlowTypes.ExtType type;

        @Override
        public Builder setPrefix(IpPrefix ip) {
            this.prefix.add(ip);
            return this;
        }

        @Override
        public Builder setType(ExtFlowTypes.ExtType type) {
            this.type = type;
            return this;
        }

        @Override
        public ExtPrefix build() {
            Preconditions.checkNotNull(this.prefix, (Object)"Ip prefix cannot be null");
            return new DefaultExtPrefix(this.prefix, this.type);
        }
    }
}

