/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flowapi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.flowapi.ExtFlowTypes;
import org.onosproject.flowapi.ExtPrefix;
import org.onosproject.flowapi.ExtTarget;

public final class DefaultExtTarget
implements ExtTarget {
    private ExtPrefix localSpeaker;
    private ExtPrefix remoteSpeaker;
    private ExtFlowTypes.ExtType type;

    DefaultExtTarget(ExtPrefix localSpeaker, ExtPrefix remoteSpeaker, ExtFlowTypes.ExtType type) {
        this.localSpeaker = localSpeaker;
        this.remoteSpeaker = remoteSpeaker;
        this.type = type;
    }

    @Override
    public ExtFlowTypes.ExtType type() {
        return this.type;
    }

    @Override
    public ExtPrefix localSpeaker() {
        return this.localSpeaker;
    }

    @Override
    public ExtPrefix remoteSpeaker() {
        return this.remoteSpeaker;
    }

    @Override
    public boolean exactMatch(ExtTarget target) {
        return this.equals(target) && Objects.equals(this.localSpeaker, target.localSpeaker()) && Objects.equals(this.remoteSpeaker, target.remoteSpeaker()) && Objects.equals((Object)this.type, (Object)target.type());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.localSpeaker, this.remoteSpeaker, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultExtTarget) {
            DefaultExtTarget that = (DefaultExtTarget)obj;
            return Objects.equals(this.localSpeaker, that.localSpeaker()) && Objects.equals(this.remoteSpeaker, that.remoteSpeaker()) && Objects.equals((Object)this.type, (Object)that.type);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("localSpeaker", (Object)this.localSpeaker).add("remoteSpeaker", (Object)this.remoteSpeaker).add("type", (Object)this.type).toString();
    }

    public static class Builder
    implements ExtTarget.Builder {
        private ExtPrefix localSpeaker;
        private ExtPrefix remoteSpeaker;
        private ExtFlowTypes.ExtType type;

        @Override
        public Builder setLocalSpeaker(ExtPrefix localSpeaker) {
            this.localSpeaker = localSpeaker;
            return this;
        }

        @Override
        public Builder setRemoteSpeaker(ExtPrefix remoteSpeaker) {
            this.remoteSpeaker = remoteSpeaker;
            return this;
        }

        @Override
        public Builder setType(ExtFlowTypes.ExtType type) {
            this.type = type;
            return this;
        }

        @Override
        public ExtTarget build() {
            Preconditions.checkNotNull((Object)this.localSpeaker, (Object)"localSpeaker cannot be null");
            Preconditions.checkNotNull((Object)this.remoteSpeaker, (Object)"remoteSpeaker cannot be null");
            return new DefaultExtTarget(this.localSpeaker, this.remoteSpeaker, this.type);
        }
    }
}

