/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flowapi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.onosproject.flowapi.ExtFlowTypes;
import org.onosproject.flowapi.ExtOperatorValue;
import org.onosproject.flowapi.ExtTcpFlag;

public class DefaultExtTcpFlag
implements ExtTcpFlag {
    private List<ExtOperatorValue> tcpFlag;
    private ExtFlowTypes.ExtType type;

    DefaultExtTcpFlag(List<ExtOperatorValue> tcpFlag, ExtFlowTypes.ExtType type) {
        this.tcpFlag = tcpFlag;
        this.type = type;
    }

    @Override
    public ExtFlowTypes.ExtType type() {
        return this.type;
    }

    @Override
    public List<ExtOperatorValue> tcpFlag() {
        return this.tcpFlag;
    }

    @Override
    public boolean exactMatch(ExtTcpFlag flag) {
        return this.equals(this.tcpFlag) && Objects.equals(this.tcpFlag, flag.tcpFlag()) && Objects.equals((Object)this.type, (Object)flag.type());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tcpFlag, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultExtTcpFlag) {
            DefaultExtTcpFlag that = (DefaultExtTcpFlag)obj;
            return Objects.equals(this.tcpFlag, that.tcpFlag()) && Objects.equals((Object)this.type, (Object)that.type());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tcpFlag", (Object)this.tcpFlag.toString()).add("type", (Object)this.type.toString()).toString();
    }

    public static class Builder
    implements ExtTcpFlag.Builder {
        private List<ExtOperatorValue> tcpFlag;
        private ExtFlowTypes.ExtType type;

        @Override
        public Builder setTcpFlag(List<ExtOperatorValue> tcpFlag) {
            this.tcpFlag = tcpFlag;
            return this;
        }

        @Override
        public Builder setType(ExtFlowTypes.ExtType type) {
            this.type = type;
            return this;
        }

        @Override
        public ExtTcpFlag build() {
            Preconditions.checkNotNull(this.tcpFlag, (Object)"tcpFlag cannot be null");
            return new DefaultExtTcpFlag(this.tcpFlag, this.type);
        }
    }
}

