/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flowapi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.flowapi.ExtFlowTypes;
import org.onosproject.flowapi.ExtTrafficAction;

public class DefaultExtTrafficAction
implements ExtTrafficAction {
    private boolean terminal;
    private boolean sample;
    private boolean rpd;
    private ExtFlowTypes.ExtType type;

    DefaultExtTrafficAction(boolean terminal, boolean sample, boolean rpd, ExtFlowTypes.ExtType type) {
        this.terminal = terminal;
        this.sample = sample;
        this.rpd = rpd;
        this.type = type;
    }

    @Override
    public ExtFlowTypes.ExtType type() {
        return this.type;
    }

    @Override
    public boolean terminal() {
        return this.terminal;
    }

    @Override
    public boolean sample() {
        return this.sample;
    }

    @Override
    public boolean rpd() {
        return this.rpd;
    }

    @Override
    public boolean exactMatch(ExtTrafficAction value) {
        return this.equals(value) && Objects.equals(this.terminal, value.terminal()) && Objects.equals(this.sample, value.sample()) && Objects.equals(this.rpd, value.rpd()) && Objects.equals((Object)this.type, (Object)value.type());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.terminal, this.sample, this.rpd, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultExtTrafficAction) {
            DefaultExtTrafficAction that = (DefaultExtTrafficAction)obj;
            return Objects.equals(this.terminal, that.terminal()) && Objects.equals(this.sample, that.sample()) && Objects.equals(this.rpd, that.rpd()) && Objects.equals((Object)this.type, (Object)that.type());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("terminal", (Object)Boolean.valueOf(this.terminal).toString()).add("sample", (Object)Boolean.valueOf(this.sample).toString()).add("rpd", (Object)Boolean.valueOf(this.rpd).toString()).add("type", (Object)this.type.toString()).toString();
    }

    public static class Builder
    implements ExtTrafficAction.Builder {
        private boolean terminal;
        private boolean sample;
        private boolean rpd;
        private ExtFlowTypes.ExtType type;

        @Override
        public Builder setTerminal(boolean terminal) {
            this.terminal = terminal;
            return this;
        }

        @Override
        public Builder setSample(boolean sample) {
            this.sample = sample;
            return this;
        }

        @Override
        public Builder setRpd(boolean rpd) {
            this.rpd = rpd;
            return this;
        }

        @Override
        public Builder setType(ExtFlowTypes.ExtType type) {
            this.type = type;
            return this;
        }

        @Override
        public ExtTrafficAction build() {
            Preconditions.checkNotNull((Object)this.terminal, (Object)"terminal cannot be null");
            Preconditions.checkNotNull((Object)this.sample, (Object)"sample cannot be null");
            Preconditions.checkNotNull((Object)this.rpd, (Object)"rpd cannot be null");
            return new DefaultExtTrafficAction(this.terminal, this.sample, this.rpd, this.type);
        }
    }
}

