/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flowapi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.flowapi.ExtFlowTypes;
import org.onosproject.flowapi.ExtTrafficMarking;

public class DefaultExtTrafficMarking
implements ExtTrafficMarking {
    private byte marking;
    private ExtFlowTypes.ExtType type;

    DefaultExtTrafficMarking(byte marking, ExtFlowTypes.ExtType type) {
        this.marking = marking;
        this.type = type;
    }

    @Override
    public ExtFlowTypes.ExtType type() {
        return this.type;
    }

    @Override
    public byte marking() {
        return this.marking;
    }

    @Override
    public boolean exactMatch(ExtTrafficMarking value) {
        return this.equals(value) && Objects.equals(this.marking, value.marking()) && Objects.equals((Object)this.type, (Object)value.type());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.marking, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultExtTrafficMarking) {
            DefaultExtTrafficMarking that = (DefaultExtTrafficMarking)obj;
            return Objects.equals(this.marking, that.marking()) && Objects.equals((Object)this.type, (Object)that.type());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("marking", (int)this.marking).add("type", (Object)this.type.toString()).toString();
    }

    public static class Builder
    implements ExtTrafficMarking.Builder {
        private byte marking;
        private ExtFlowTypes.ExtType type;

        @Override
        public Builder setMarking(byte marking) {
            this.marking = marking;
            return this;
        }

        @Override
        public Builder setType(ExtFlowTypes.ExtType type) {
            this.type = type;
            return this;
        }

        @Override
        public ExtTrafficMarking build() {
            Preconditions.checkNotNull((Object)this.marking, (Object)"marking cannot be null");
            return new DefaultExtTrafficMarking(this.marking, this.type);
        }
    }
}

