/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flowapi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.flowapi.ExtFlowTypes;
import org.onosproject.flowapi.ExtTrafficRate;

public class DefaultExtTrafficRate
implements ExtTrafficRate {
    private Short asn;
    private Float rate;
    private ExtFlowTypes.ExtType type;

    DefaultExtTrafficRate(short asn, float rate, ExtFlowTypes.ExtType type) {
        this.asn = asn;
        this.rate = Float.valueOf(rate);
        this.type = type;
    }

    @Override
    public ExtFlowTypes.ExtType type() {
        return this.type;
    }

    @Override
    public Short asn() {
        return this.asn;
    }

    @Override
    public Float rate() {
        return this.rate;
    }

    @Override
    public boolean exactMatch(ExtTrafficRate value) {
        return this.equals(value) && Objects.equals(this.asn, value.asn()) && Objects.equals(this.rate, value.rate()) && Objects.equals((Object)this.type, (Object)value.type());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.asn, this.rate, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultExtTrafficRate) {
            DefaultExtTrafficRate that = (DefaultExtTrafficRate)obj;
            return Objects.equals(this.asn, that.asn()) && Objects.equals(this.rate, that.rate()) && Objects.equals((Object)this.type, (Object)that.type());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("asn", (Object)this.asn.toString()).add("rate", (Object)this.rate.toString()).add("type", (Object)this.type.toString()).toString();
    }

    public static class Builder
    implements ExtTrafficRate.Builder {
        private Short asn;
        private Float rate;
        private ExtFlowTypes.ExtType type;

        @Override
        public Builder setAsn(short asn) {
            this.asn = asn;
            return this;
        }

        @Override
        public Builder setRate(float rate) {
            this.rate = Float.valueOf(rate);
            return this;
        }

        @Override
        public Builder setType(ExtFlowTypes.ExtType type) {
            this.type = type;
            return this;
        }

        @Override
        public ExtTrafficRate build() {
            Preconditions.checkNotNull((Object)this.asn, (Object)"asn cannot be null");
            Preconditions.checkNotNull((Object)this.rate, (Object)"rate cannot be null");
            return new DefaultExtTrafficRate(this.asn, this.rate.floatValue(), this.type);
        }
    }
}

