/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flowapi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.flowapi.ExtFlowTypes;
import org.onosproject.flowapi.ExtTrafficRedirect;

public class DefaultExtTrafficRedirect
implements ExtTrafficRedirect {
    private String redirect;
    private ExtFlowTypes.ExtType type;

    DefaultExtTrafficRedirect(String redirect, ExtFlowTypes.ExtType type) {
        this.redirect = redirect;
        this.type = type;
    }

    @Override
    public ExtFlowTypes.ExtType type() {
        return this.type;
    }

    @Override
    public String redirect() {
        return this.redirect;
    }

    @Override
    public boolean exactMatch(ExtTrafficRedirect value) {
        return this.equals(value) && Objects.equals(this.redirect, value.redirect()) && Objects.equals((Object)this.type, (Object)value.type());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.redirect, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultExtTrafficRedirect) {
            DefaultExtTrafficRedirect that = (DefaultExtTrafficRedirect)obj;
            return Objects.equals(this.redirect, that.redirect()) && Objects.equals((Object)this.type, (Object)that.type());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("redirect", (Object)this.redirect.toString()).add("type", (Object)this.type.toString()).toString();
    }

    public static class Builder
    implements ExtTrafficRedirect.Builder {
        private String redirect;
        private ExtFlowTypes.ExtType type;

        @Override
        public Builder setRedirect(String redirect) {
            this.redirect = redirect;
            return this;
        }

        @Override
        public Builder setType(ExtFlowTypes.ExtType type) {
            this.type = type;
            return this;
        }

        @Override
        public ExtTrafficRedirect build() {
            Preconditions.checkNotNull((Object)this.redirect, (Object)"redirect cannot be null");
            return new DefaultExtTrafficRedirect(this.redirect, this.type);
        }
    }
}

