/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.flowapi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.onosproject.flowapi.ExtFlowTypes;
import org.onosproject.flowapi.ExtWideCommunityInt;

public class DefaultExtWideCommunityInt
implements ExtWideCommunityInt {
    private List<Integer> wCommInt;
    private ExtFlowTypes.ExtType type;

    DefaultExtWideCommunityInt(List<Integer> wCommInt, ExtFlowTypes.ExtType type) {
        this.wCommInt = wCommInt;
        this.type = type;
    }

    @Override
    public ExtFlowTypes.ExtType type() {
        return this.type;
    }

    @Override
    public List<Integer> communityInt() {
        return this.wCommInt;
    }

    @Override
    public boolean exactMatch(ExtWideCommunityInt value) {
        return this.equals(value) && Objects.equals(this.wCommInt, value.communityInt()) && Objects.equals((Object)this.type, (Object)value.type());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.wCommInt, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultExtWideCommunityInt) {
            DefaultExtWideCommunityInt that = (DefaultExtWideCommunityInt)obj;
            return Objects.equals(this.wCommInt, that.communityInt()) && Objects.equals((Object)this.type, (Object)that.type());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.wCommInt.toString()).add("type", (Object)this.type.toString()).toString();
    }

    public static class Builder
    implements ExtWideCommunityInt.Builder {
        private List<Integer> wCommInt = new ArrayList<Integer>();
        private ExtFlowTypes.ExtType type;

        @Override
        public Builder setwCommInt(Integer wCommInt) {
            this.wCommInt.add(wCommInt);
            return this;
        }

        @Override
        public Builder setType(ExtFlowTypes.ExtType type) {
            this.type = type;
            return this;
        }

        @Override
        public ExtWideCommunityInt build() {
            Preconditions.checkNotNull(this.wCommInt, (Object)"value cannot be null");
            return new DefaultExtWideCommunityInt(this.wCommInt, this.type);
        }
    }
}

