/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.ListIterator;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLsNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.NodeDescriptors;
import org.onosproject.bgpio.types.AutonomousSystemTlv;
import org.onosproject.bgpio.types.BgpLSIdentifierTlv;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.IsIsNonPseudonode;
import org.onosproject.bgpio.types.IsIsPseudonode;
import org.onosproject.bgpio.types.OspfNonPseudonode;
import org.onosproject.bgpio.types.OspfPseudonode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BgpDpid {
    private static final Logger log = LoggerFactory.getLogger(BgpDpid.class);
    private static final String SCHEME = "l3";
    private static final long UNKNOWN = 0L;
    private StringBuilder stringBuilder = new StringBuilder("");
    public static final int NODE_DESCRIPTOR_LOCAL = 1;
    public static final int NODE_DESCRIPTOR_REMOTE = 2;

    public BgpDpid(BgpLinkLsNlriVer4 linkNlri, int nodeDescriptorType) {
        if (linkNlri.getRouteDistinguisher() != null) {
            this.stringBuilder.append("RD=").append(linkNlri.getRouteDistinguisher().getRouteDistinguisher()).append(":");
        }
        this.stringBuilder.append(":ROUTINGUNIVERSE=").append(linkNlri.getIdentifier());
        if (nodeDescriptorType == 1) {
            log.debug("Local node descriptor added");
            this.add(linkNlri.localNodeDescriptors());
        } else if (nodeDescriptorType == 2) {
            log.debug("Remote node descriptor added");
            this.add(linkNlri.remoteNodeDescriptors());
        }
    }

    public String isoNodeIdString(byte[] isoNodeId) {
        if (isoNodeId != null) {
            return String.format("%02x%02x.%02x%02x.%02x%02x", isoNodeId[0], isoNodeId[1], isoNodeId[2], isoNodeId[3], isoNodeId[4], isoNodeId[5]);
        }
        return null;
    }

    public BgpDpid(BgpNodeLSNlriVer4 nlri) {
        if (nlri.getRouteDistinguisher() != null) {
            this.stringBuilder.append("RD=").append(nlri.getRouteDistinguisher().getRouteDistinguisher()).append(":");
        }
        this.stringBuilder.append(":ROUTINGUNIVERSE=").append(nlri.getIdentifier());
        this.add(nlri.getLocalNodeDescriptors().getNodedescriptors());
        log.debug("BgpDpid :: add");
    }

    public BgpDpid add(NodeDescriptors value) {
        log.debug("BgpDpid :: add function");
        if (value != null) {
            List subTlvs = value.getSubTlvs();
            ListIterator listIterator = subTlvs.listIterator();
            while (listIterator.hasNext()) {
                BgpValueType tlv = (BgpValueType)listIterator.next();
                if (tlv.getType() == 512) {
                    this.stringBuilder.append(":ASN=").append(((AutonomousSystemTlv)tlv).getAsNum());
                    continue;
                }
                if (tlv.getType() == 513) {
                    this.stringBuilder.append(":DOMAINID=").append(((BgpLSIdentifierTlv)tlv).getBgpLsIdentifier());
                    continue;
                }
                if (tlv.getType() != 515) continue;
                if (tlv instanceof IsIsNonPseudonode) {
                    this.stringBuilder.append(":ISOID=").append(this.isoNodeIdString(((IsIsNonPseudonode)tlv).getIsoNodeId()));
                    continue;
                }
                if (tlv instanceof IsIsPseudonode) {
                    IsIsPseudonode isisPseudonode = (IsIsPseudonode)tlv;
                    this.stringBuilder.append(":ISOID=").append(this.isoNodeIdString(((IsIsPseudonode)tlv).getIsoNodeId()));
                    this.stringBuilder.append(":PSN=").append(isisPseudonode.getPsnIdentifier());
                    continue;
                }
                if (tlv instanceof OspfNonPseudonode) {
                    this.stringBuilder.append(":RID=").append(((OspfNonPseudonode)tlv).getrouterID());
                    continue;
                }
                if (!(tlv instanceof OspfPseudonode)) continue;
                this.stringBuilder.append(":RID=").append(((OspfPseudonode)tlv).getrouterID());
            }
        }
        return this;
    }

    public String toString() {
        return this.stringBuilder.toString();
    }

    public static URI uri(String value) {
        try {
            return new URI(SCHEME, value, null);
        }
        catch (URISyntaxException e) {
            log.debug("Exception BgpId URI: " + e.toString());
            return null;
        }
    }

    public static BgpDpid bgpDpid(URI uri) {
        Preconditions.checkArgument((boolean)uri.getScheme().equals(SCHEME), (Object)"Unsupported URI scheme");
        return null;
    }
}

