/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.annotations;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import java.lang.reflect.Field;
import org.jsonschema2pojo.AbstractAnnotator;
import org.openmetadata.annotations.PasswordField;

public class PasswordAnnotator
extends AbstractAnnotator {
    public void propertyField(JFieldVar field, JDefinedClass clazz, String propertyName, JsonNode propertyNode) {
        super.propertyField(field, clazz, propertyName, propertyNode);
        if (propertyNode.get("format") != null && "password".equals(propertyNode.get("format").asText())) {
            field.annotate(PasswordField.class);
        }
    }

    public void propertyGetter(JMethod getter, JDefinedClass clazz, String propertyName) {
        super.propertyGetter(getter, clazz, propertyName);
        this.addMaskedFieldAnnotationIfApplies(getter, propertyName);
    }

    public void propertySetter(JMethod setter, JDefinedClass clazz, String propertyName) {
        super.propertySetter(setter, clazz, propertyName);
        this.addMaskedFieldAnnotationIfApplies(setter, propertyName);
    }

    private void addMaskedFieldAnnotationIfApplies(JMethod jMethod, String propertyName) {
        try {
            Field outerClassField = JMethod.class.getDeclaredField("outer");
            outerClassField.setAccessible(true);
            JDefinedClass outerClass = (JDefinedClass)outerClassField.get(jMethod);
            if (outerClass.fields().containsKey(propertyName) && ((JFieldVar)outerClass.fields().get(propertyName)).annotations().stream().anyMatch(annotation -> PasswordField.class.getName().equals(this.getAnnotationClassName((JAnnotationUse)annotation)))) {
                jMethod.annotate(PasswordField.class);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private String getAnnotationClassName(JAnnotationUse annotation) {
        try {
            Field clazzField = JAnnotationUse.class.getDeclaredField("clazz");
            clazzField.setAccessible(true);
            return ((JClass)clazzField.get(annotation)).fullName();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

