/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.common.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CommonUtil.class);
    public static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";

    private CommonUtil() {
    }

    public static List<String> getResources(Pattern pattern) throws IOException {
        String[] classPathElements;
        ArrayList<String> resources = new ArrayList<String>();
        String classPath = System.getProperty("java.class.path", ".");
        for (String element : classPathElements = classPath.split(File.pathSeparator)) {
            File file = new File(element);
            resources.addAll(file.isDirectory() ? CommonUtil.getResourcesFromDirectory(file, pattern) : CommonUtil.getResourcesFromJarFile(file, pattern));
        }
        return resources;
    }

    private static Collection<String> getResourcesFromJarFile(File file, Pattern pattern) {
        ArrayList<String> retval = new ArrayList<String>();
        try (ZipFile zf = new ZipFile(file);){
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                String fileName = e.nextElement().getName();
                if (!pattern.matcher(fileName).matches()) continue;
                retval.add(fileName);
                LOG.info("Adding file from jar {}", (Object)fileName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public static Collection<String> getResourcesFromDirectory(File file, Pattern pattern) throws IOException {
        Path root = Path.of(file.getPath(), new String[0]);
        try (Stream<Path> paths = Files.walk(Paths.get(file.getPath(), new String[0]), new FileVisitOption[0]);){
            Collection collection = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> pattern.matcher(path.toString()).matches()).map(path -> {
                String relativePath = root.relativize((Path)path).toString();
                LOG.info("Adding directory file {}", (Object)relativePath);
                return relativePath;
            }).collect(Collectors.toSet());
            return collection;
        }
    }

    public static Date getDateByOffset(Date date, int days) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static Date getDateByOffset(DateFormat dateFormat, String strDate, int days) {
        Date date;
        try {
            date = dateFormat.parse(strDate);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse date " + strDate, e);
        }
        return CommonUtil.getDateByOffset(date, days);
    }

    public static String getDateStringByOffset(DateFormat dateFormat, String strDate, int days) {
        return dateFormat.format(CommonUtil.getDateByOffset(dateFormat, strDate, days));
    }

    public static boolean dateInRange(DateFormat dateFormat, String date, int futureDays, int pastDays) {
        Date givenDate;
        Date today = new Date();
        Date startDate = CommonUtil.getDateByOffset(today, -pastDays);
        Date endDate = CommonUtil.getDateByOffset(today, futureDays);
        try {
            givenDate = dateFormat.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse date " + date, e);
        }
        return givenDate.after(startDate) && givenDate.before(endDate);
    }

    public static String calculateHMAC(String secretKey, String message) {
        try {
            Mac mac = Mac.getInstance(HMAC_SHA256_ALGORITHM);
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getBytes(StandardCharsets.UTF_8), HMAC_SHA256_ALGORITHM);
            mac.init(secretKeySpec);
            byte[] hmacSha256 = mac.doFinal(message.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(hmacSha256);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate HmacSHA256", e);
        }
    }

    public static <T> List<T> listOrEmpty(List<T> list) {
        return Optional.ofNullable(list).orElse(Collections.emptyList());
    }

    public static boolean nullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean nullOrEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static boolean nullOrEmpty(Object object) {
        return object == null || CommonUtil.nullOrEmpty(object.toString());
    }

    public static String getResourceAsStream(ClassLoader loader, String file) throws IOException {
        return IOUtils.toString((InputStream)Objects.requireNonNull(loader.getResourceAsStream(file)), (Charset)StandardCharsets.UTF_8);
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... entries) {
        if (entries == null) {
            return Collections.emptyList();
        }
        return new ArrayList<T>(Arrays.asList(entries));
    }
}

