/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.decorators;

import java.io.IOException;
import java.util.LinkedList;
import org.bitbucket.cowwoc.diffmatchpatch.DiffMatchPatch;
import org.openmetadata.schema.type.ChangeEvent;

public interface MessageDecorator<T> {
    public String getBold();

    public String getLineBreak();

    public String getAddMarker();

    public String getAddMarkerClose();

    public String getRemoveMarker();

    public String getRemoveMarkerClose();

    public String getEntityUrl(String var1, String var2);

    default public String httpAddMarker() {
        return "<!add>";
    }

    default public String httpRemoveMarker() {
        return "<!remove>";
    }

    public T buildMessage(ChangeEvent var1) throws IOException;

    default public String getPlaintextDiff(String oldValue, String newValue) {
        oldValue = oldValue == null ? "" : oldValue;
        String addMarker = this.httpAddMarker();
        String removeMarker = this.httpRemoveMarker();
        DiffMatchPatch dmp = new DiffMatchPatch();
        LinkedList diffs = dmp.diffMain(oldValue, newValue);
        dmp.diffCleanupSemantic(diffs);
        StringBuilder outputStr = new StringBuilder();
        for (DiffMatchPatch.Diff d : diffs) {
            if (DiffMatchPatch.Operation.EQUAL.equals((Object)d.operation)) {
                outputStr.append(d.text.trim()).append(" ");
                continue;
            }
            if (DiffMatchPatch.Operation.INSERT.equals((Object)d.operation)) {
                outputStr.append(addMarker).append(d.text.trim()).append(addMarker).append(" ");
                continue;
            }
            outputStr.append(removeMarker).append(d.text.trim()).append(removeMarker).append(" ");
        }
        String diff = outputStr.toString().trim();
        diff = this.replaceMarkers(diff, addMarker, this.getAddMarker(), this.getAddMarkerClose());
        diff = this.replaceMarkers(diff, removeMarker, this.getRemoveMarker(), this.getRemoveMarkerClose());
        return diff;
    }

    default public String replaceMarkers(String diff, String marker, String openTag, String closeTag) {
        int index = 0;
        while (diff.contains(marker)) {
            String replacement = index % 2 == 0 ? openTag : closeTag;
            diff = diff.replaceFirst(marker, replacement);
            ++index;
        }
        return diff;
    }
}

