/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.List;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;

public class DatabaseRepository
extends EntityRepository<Database> {
    public DatabaseRepository(CollectionDAO dao) {
        super("v1/databases/", "database", Database.class, dao.databaseDAO(), dao, "", "");
    }

    @Override
    public void setFullyQualifiedName(Database database) {
        database.setFullyQualifiedName(FullyQualifiedName.build(database.getService().getName(), database.getName()));
    }

    @Override
    public void prepare(Database database) {
        this.populateService(database);
    }

    @Override
    public void storeEntity(Database database, boolean update) {
        EntityReference service = database.getService();
        database.withService(null);
        this.store(database, update);
        database.withService(service);
    }

    @Override
    public void storeRelationships(Database database) {
        EntityReference service = database.getService();
        this.addRelationship(service.getId(), database.getId(), service.getType(), "database", Relationship.CONTAINS);
    }

    private List<EntityReference> getSchemas(Database database) {
        return database == null ? null : this.findTo(database.getId(), "database", Relationship.CONTAINS, "databaseSchema");
    }

    @Override
    public Database setFields(Database database, EntityUtil.Fields fields) {
        database.setService(this.getContainer(database.getId()));
        database.setDatabaseSchemas(fields.contains("databaseSchemas") ? this.getSchemas(database) : database.getDatabaseSchemas());
        if (database.getUsageSummary() == null) {
            database.setUsageSummary(fields.contains("usageSummary") ? EntityUtil.getLatestUsage(this.daoCollection.usageDAO(), database.getId()) : null);
        }
        return database;
    }

    @Override
    public Database clearFields(Database database, EntityUtil.Fields fields) {
        database.setDatabaseSchemas(fields.contains("databaseSchemas") ? database.getDatabaseSchemas() : null);
        return database.withUsageSummary(fields.contains("usageSummary") ? database.getUsageSummary() : null);
    }

    @Override
    public void restorePatchAttributes(Database original, Database updated) {
        updated.withFullyQualifiedName(original.getFullyQualifiedName()).withName(original.getName()).withService(original.getService()).withId(original.getId());
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Database original, Database updated, EntityRepository.Operation operation) {
        return new DatabaseUpdater(original, updated, operation);
    }

    private void populateService(Database database) {
        DatabaseService service = (DatabaseService)Entity.getEntity(database.getService(), "", Include.NON_DELETED);
        database.setService(service.getEntityReference());
        database.setServiceType(service.getServiceType());
    }

    public class DatabaseUpdater
    extends EntityRepository.EntityUpdater {
        public DatabaseUpdater(Database original, Database updated, EntityRepository.Operation operation) {
            super((EntityRepository)DatabaseRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() {
            this.recordChange("retentionPeriod", ((Database)this.original).getRetentionPeriod(), ((Database)this.updated).getRetentionPeriod());
            this.recordChange("sourceUrl", ((Database)this.original).getSourceUrl(), ((Database)this.updated).getSourceUrl());
        }
    }
}

