/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.search;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.suggest.Suggest;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.api.CreateEventPublisherJob;
import org.openmetadata.schema.system.EventPublisherJob;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.search.IndexUtil;
import org.openmetadata.service.search.SearchClient;
import org.openmetadata.service.search.SearchIndexDefinition;
import org.openmetadata.service.search.SearchRequest;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ReIndexingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/search")
@Tag(name="Search", description="APIs related to search and suggest.")
@Produces(value={"application/json"})
@Collection(name="search")
public class SearchResource {
    private static final Logger LOG = LoggerFactory.getLogger(SearchResource.class);
    private final CollectionDAO dao;
    private final Authorizer authorizer;
    private SearchClient searchClient;

    public SearchResource(CollectionDAO dao, Authorizer authorizer) {
        this.dao = dao;
        this.authorizer = authorizer;
    }

    public void initialize(OpenMetadataApplicationConfig config) {
        if (config.getElasticSearchConfiguration() != null) {
            this.searchClient = IndexUtil.getSearchClient(config.getElasticSearchConfiguration(), this.dao);
            ReIndexingHandler.initialize(this.searchClient, this.dao);
        }
    }

    @GET
    @Path(value="/query")
    @Operation(operationId="searchEntitiesWithQuery", summary="Search entities", description="Search entities using query test. Use query params `from` and `size` for pagination. Use `sort_field` to sort the results in `sort_order`.", responses={@ApiResponse(responseCode="200", description="search response", content={@Content(mediaType="application/json", schema=@Schema(implementation=SearchResponse.class))})})
    public Response search(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Search Query Text, Pass *text* for substring match; Pass without wildcards for exact match. <br/> 1. For listing all tables or topics pass q=* <br/>2. For search tables or topics pass q=*search_term* <br/>3. For searching field names such as search by column_name pass q=column_names:address <br/>4. For searching by tag names pass q=tags:user.email <br/>5. When user selects a filter pass q=query_text AND tags:user.email AND platform:MYSQL <br/>6. Search with multiple values of same filter q=tags:user.email AND tags:user.address <br/> logic operators such as AND and OR must be in uppercase ", required=true) @DefaultValue(value="*") @QueryParam(value="q") String query, @Parameter(description="ElasticSearch Index name, defaults to table_search_index") @DefaultValue(value="table_search_index") @QueryParam(value="index") String index, @Parameter(description="Filter documents by deleted param. By default deleted is false") @DefaultValue(value="false") @QueryParam(value="deleted") @Deprecated(forRemoval=true) boolean deleted, @Parameter(description="From field to paginate the results, defaults to 0") @DefaultValue(value="0") @QueryParam(value="from") int from, @Parameter(description="Size field to limit the no.of results returned, defaults to 10") @DefaultValue(value="10") @QueryParam(value="size") int size, @Parameter(description="Sort the search results by field, available fields to sort weekly_stats , daily_stats, monthly_stats, last_updated_timestamp") @DefaultValue(value="_score") @QueryParam(value="sort_field") String sortFieldParam, @Parameter(description="Sort order asc for ascending or desc for descending, defaults to desc") @DefaultValue(value="desc") @QueryParam(value="sort_order") String sortOrder, @Parameter(description="Track Total Hits") @DefaultValue(value="false") @QueryParam(value="track_total_hits") boolean trackTotalHits, @Parameter(description="Elasticsearch query that will be combined with the query_string query generator from the `query` argument") @QueryParam(value="query_filter") String queryFilter, @Parameter(description="Elasticsearch query that will be used as a post_filter") @QueryParam(value="post_filter") String postFilter, @Parameter(description="Get document body for each hit") @DefaultValue(value="true") @QueryParam(value="fetch_source") boolean fetchSource, @Parameter(description="Get only selected fields of the document body for each hit. Empty value will return all fields") @QueryParam(value="include_source_fields") List<String> includeSourceFields) throws IOException {
        if (CommonUtil.nullOrEmpty((String)query)) {
            query = "*";
        }
        SearchRequest request = new SearchRequest.ElasticSearchRequestBuilder(query, size, index).from(from).queryFilter(queryFilter).postFilter(postFilter).fetchSource(fetchSource).trackTotalHits(trackTotalHits).sortFieldParam(sortFieldParam).deleted(deleted).sortOrder(sortOrder).includeSourceFields(includeSourceFields).build();
        return this.searchClient.search(request);
    }

    @GET
    @Path(value="/sourceUrl")
    @Operation(operationId="searchEntitiesWithSourceUrl", summary="Search entities", responses={@ApiResponse(responseCode="200", description="search response", content={@Content(mediaType="application/json", schema=@Schema(implementation=SearchResponse.class))})})
    public Response searchBySourceUrl(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="source url") @QueryParam(value="sourceUrl") String sourceUrl) throws IOException {
        return this.searchClient.searchBySourceUrl(sourceUrl);
    }

    @GET
    @Path(value="/suggest")
    @Operation(operationId="getSuggestedEntities", summary="Suggest entities", description="Get suggested entities used for auto-completion.", responses={@ApiResponse(responseCode="200", description="Table Suggestion API", content={@Content(mediaType="application/json", schema=@Schema(implementation=Suggest.class))})})
    public Response suggest(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Suggest API can be used to auto-fill the entities name while use is typing search text <br/> 1. To get suggest results pass q=us or q=user etc.. <br/> 2. Do not add any wild-cards such as * like in search api <br/> 3. suggest api is a prefix suggestion <br/>", required=true) @QueryParam(value="q") String query, @DefaultValue(value="table_search_index") @QueryParam(value="index") String index, @Parameter(description="Field in object containing valid suggestions. Defaults to 'suggest`. All indices has a `suggest` field, only some indices have other `suggest_*` fields.") @DefaultValue(value="suggest") @QueryParam(value="field") String fieldName, @Parameter(description="Size field to limit the no.of results returned, defaults to 10") @DefaultValue(value="10") @QueryParam(value="size") int size, @Parameter(description="Get document body for each hit") @DefaultValue(value="true") @QueryParam(value="fetch_source") boolean fetchSource, @Parameter(description="Get only selected fields of the document body for each hit. Empty value will return all fields") @QueryParam(value="include_source_fields") List<String> includeSourceFields, @DefaultValue(value="false") @QueryParam(value="deleted") boolean deleted) throws IOException {
        if (CommonUtil.nullOrEmpty((String)query)) {
            query = "*";
        }
        SearchRequest request = new SearchRequest.ElasticSearchRequestBuilder(query, size, index).fieldName(fieldName).deleted(deleted).fetchSource(fetchSource).includeSourceFields(includeSourceFields).build();
        return this.searchClient.suggest(request);
    }

    @GET
    @Path(value="/aggregate")
    @Operation(operationId="getAggregateFields", summary="Get aggregated fields", description="Get aggregated fields from entities.", responses={@ApiResponse(responseCode="200", description="Table Aggregate API", content={@Content(mediaType="application/json", schema=@Schema(implementation=Suggest.class))})})
    public Response aggregate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @DefaultValue(value="table_search_index") @QueryParam(value="index") String index, @Parameter(description="Field in an entity.") @QueryParam(value="field") String fieldName, @Parameter(description="value for searching in aggregation") @DefaultValue(value="") @QueryParam(value="value") String value, @Parameter(description="Search Query Text, Pass *text* for substring match; Pass without wildcards for exact match. <br/> 1. For listing all tables or topics pass q=* <br/>2. For search tables or topics pass q=*search_term* <br/>3. For searching field names such as search by column_name pass q=column_names:address <br/>4. For searching by tag names pass q=tags:user.email <br/>5. When user selects a filter pass q=query_text AND tags:user.email AND platform:MYSQL <br/>6. Search with multiple values of same filter q=tags:user.email AND tags:user.address <br/> logic operators such as AND and OR must be in uppercase ", required=true) @DefaultValue(value="*") @QueryParam(value="q") String query, @Parameter(description="Size field to limit the no.of results returned, defaults to 10") @DefaultValue(value="10") @QueryParam(value="size") int size, @DefaultValue(value="false") @QueryParam(value="deleted") String deleted) throws IOException {
        return this.searchClient.aggregate(index, fieldName, value, query);
    }

    @GET
    @Path(value="/reindex/latest")
    @Operation(operationId="getLatestReindexBatchJob", summary="Get Latest Reindexing Batch Job", description="Fetches the Latest Reindexing Job", responses={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="404", description="No Job Found")})
    public Response reindexLatestJob(@Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        this.authorizer.authorizeAdmin(securityContext);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ReIndexingHandler.getInstance().getLatestJob()).build();
    }

    @GET
    @Path(value="/reindex/stream/status")
    @Operation(operationId="getStreamJobStatus", summary="Get Stream Job Latest Status", description="Stream Job Status", responses={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="404", description="Status not found")})
    public Response reindexAllJobLastStatus(@Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        this.authorizer.authorizeAdmin(securityContext);
        String jobRecord = this.dao.entityExtensionTimeSeriesDao().getLatestExtension("eventPublisher:ElasticSearch:STREAM", "service.eventPublisher");
        if (jobRecord != null) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)JsonUtils.readValue(jobRecord, EventPublisherJob.class)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No Last Run.").build();
    }

    @GET
    @Path(value="/reindex/{jobId}")
    @Operation(operationId="getBatchReindexBatchJobWithId", summary="Get Batch Reindexing Job with Id", description="Get reindex job with Id", responses={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="404", description="Not found")})
    public Response reindexJobWithId(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="jobId Id", schema=@Schema(type="UUID")) @PathParam(value="jobId") UUID id) {
        this.authorizer.authorizeAdminOrBot(securityContext);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ReIndexingHandler.getInstance().getJob(id)).build();
    }

    @GET
    @Path(value="/mappings")
    @Operation(operationId="getSearchMappingSchema", summary="Get Search Mapping Schema", description="Get Search Mapping Schema", responses={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="404", description="Not found")})
    public Response getElasticSearchMappingSchema(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="List of Entities to get schema for") @QueryParam(value="entityType") String entityType) {
        HashSet<String> entities;
        this.authorizer.authorizeAdminOrBot(securityContext);
        if (entityType == null) {
            entities = new HashSet<String>();
            entities.add("*");
        } else {
            entities = new HashSet<String>(Arrays.asList(entityType.replace(" ", "").split(",")));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(SearchIndexDefinition.getIndexMappingSchema(entities)).build();
    }

    @GET
    @Path(value="/reindex")
    @Operation(operationId="getAllReindexBatchJobs", summary="Get all reindex batch jobs", description="Get all reindex batch jobs", responses={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="404", description="Not found")})
    public Response reindexAllJobs(@Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        this.authorizer.authorizeAdmin(securityContext);
        return Response.status((Response.Status)Response.Status.OK).entity(ReIndexingHandler.getInstance().getAllJobs()).build();
    }

    @POST
    @Path(value="/reindex")
    @Operation(operationId="runBatchReindexing", summary="Run Batch Reindexing", description="Reindex Elastic Search Reindexing Entities", responses={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="404", description="Bot for instance {id} is not found")})
    public Response reindexEntities(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateEventPublisherJob createRequest) {
        this.authorizer.authorizeAdminOrBot(securityContext);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)ReIndexingHandler.getInstance().createReindexingJob(securityContext.getUserPrincipal().getName(), createRequest)).build();
    }

    @PUT
    @Path(value="/reindex/stop/{jobId}")
    @Operation(operationId="stopAJobWithId", summary="Stop Reindex Job", description="Stop a Reindex Job", responses={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="404", description="Bot for instance {id} is not found")})
    public Response stopReindexJob(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="jobId Id", schema=@Schema(type="UUID")) @PathParam(value="jobId") UUID id) {
        this.authorizer.authorizeAdmin(securityContext);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ReIndexingHandler.getInstance().stopRunningJob(id)).build();
    }
}

