/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.elasticSearch;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.index.query.functionscore.FieldValueFactorFunctionBuilder;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilders;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.SumAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.suggest.SuggestBuilders;
import org.elasticsearch.search.suggest.SuggestionBuilder;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionBuilder;
import org.elasticsearch.search.suggest.completion.context.CategoryQueryContext;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.DataInsightInterface;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.entity.classification.Classification;
import org.openmetadata.schema.entity.classification.Tag;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.schema.entity.data.DatabaseSchema;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.schema.entity.services.MessagingService;
import org.openmetadata.schema.entity.services.MlModelService;
import org.openmetadata.schema.entity.services.PipelineService;
import org.openmetadata.schema.entity.services.StorageService;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.service.configuration.elasticsearch.ElasticSearchConfiguration;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.DataInsightChartRepository;
import org.openmetadata.service.search.EntityBuilderConstant;
import org.openmetadata.service.search.IndexUtil;
import org.openmetadata.service.search.SearchClient;
import org.openmetadata.service.search.SearchIndexDefinition;
import org.openmetadata.service.search.SearchIndexFactory;
import org.openmetadata.service.search.SearchRequest;
import org.openmetadata.service.search.elasticSearch.EsDailyActiveUsersAggregator;
import org.openmetadata.service.search.elasticSearch.EsEntitiesDescriptionAggregator;
import org.openmetadata.service.search.elasticSearch.EsEntitiesOwnerAggregator;
import org.openmetadata.service.search.elasticSearch.EsMostActiveUsersAggregator;
import org.openmetadata.service.search.elasticSearch.EsMostViewedEntitiesAggregator;
import org.openmetadata.service.search.elasticSearch.EsPageViewsByEntitiesAggregator;
import org.openmetadata.service.search.elasticSearch.EsServicesDescriptionAggregator;
import org.openmetadata.service.search.elasticSearch.EsServicesOwnerAggregator;
import org.openmetadata.service.search.elasticSearch.EsTotalEntitiesAggregator;
import org.openmetadata.service.search.elasticSearch.EsTotalEntitiesByTierAggregator;
import org.openmetadata.service.search.indexes.ElasticSearchIndex;
import org.openmetadata.service.search.indexes.GlossaryTermIndex;
import org.openmetadata.service.search.indexes.TagIndex;
import org.openmetadata.service.search.indexes.TeamIndex;
import org.openmetadata.service.search.indexes.TestCaseIndex;
import org.openmetadata.service.search.indexes.UserIndex;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchClientImpl
implements SearchClient {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchClientImpl.class);
    private final RestHighLevelClient client;
    private final CollectionDAO dao;
    private static final EnumMap<SearchIndexDefinition.ElasticSearchIndexType, IndexUtil.ElasticSearchIndexStatus> elasticSearchIndexes = new EnumMap(SearchIndexDefinition.ElasticSearchIndexType.class);
    private static final NamedXContentRegistry xContentRegistry;

    public ElasticSearchClientImpl(ElasticSearchConfiguration esConfig, CollectionDAO dao) {
        this.client = ElasticSearchClientImpl.createElasticSearchClient(esConfig);
        this.dao = dao;
    }

    @Override
    public CollectionDAO getDao() {
        return this.dao;
    }

    @Override
    public boolean createIndex(SearchIndexDefinition.ElasticSearchIndexType elasticSearchIndexType, String lang) {
        try {
            GetIndexRequest gRequest = new GetIndexRequest(new String[]{elasticSearchIndexType.indexName});
            gRequest.local(false);
            boolean exists = this.client.indices().exists(gRequest, RequestOptions.DEFAULT);
            String elasticSearchIndexMapping = this.getIndexMapping(elasticSearchIndexType, lang);
            SearchIndexDefinition.ENTITY_TO_MAPPING_SCHEMA_MAP.put(elasticSearchIndexType.entityType, JsonUtils.getMap(JsonUtils.readJson(elasticSearchIndexMapping)));
            if (!exists) {
                CreateIndexRequest request = new CreateIndexRequest(elasticSearchIndexType.indexName);
                request.source(elasticSearchIndexMapping, XContentType.JSON);
                CreateIndexResponse createIndexResponse = this.client.indices().create(request, RequestOptions.DEFAULT);
                LOG.info("{} Created {}", (Object)elasticSearchIndexType.indexName, (Object)createIndexResponse.isAcknowledged());
                IndicesAliasesRequest aliasesRequest = new IndicesAliasesRequest();
                IndicesAliasesRequest.AliasActions aliasAction = IndicesAliasesRequest.AliasActions.add().index(elasticSearchIndexType.indexName).alias("sourceUrlSearchAlias");
                aliasesRequest.addAliasAction(aliasAction);
                this.client.indices().updateAliases(aliasesRequest, RequestOptions.DEFAULT);
            }
            elasticSearchIndexes.put(elasticSearchIndexType, IndexUtil.ElasticSearchIndexStatus.CREATED);
        }
        catch (Exception e) {
            elasticSearchIndexes.put(elasticSearchIndexType, IndexUtil.ElasticSearchIndexStatus.CREATED);
            this.updateElasticSearchFailureStatus(IndexUtil.getContext("Creating Index", elasticSearchIndexType.indexName), String.format("Reason: [%s] , Trace : [%s]", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)));
            LOG.error("Failed to create Elastic Search indexes due to", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void updateIndex(SearchIndexDefinition.ElasticSearchIndexType elasticSearchIndexType, String lang) {
        try {
            GetIndexRequest gRequest = new GetIndexRequest(new String[]{elasticSearchIndexType.indexName});
            gRequest.local(false);
            boolean exists = this.client.indices().exists(gRequest, RequestOptions.DEFAULT);
            String elasticSearchIndexMapping = this.getIndexMapping(elasticSearchIndexType, lang);
            SearchIndexDefinition.ENTITY_TO_MAPPING_SCHEMA_MAP.put(elasticSearchIndexType.entityType, JsonUtils.getMap(JsonUtils.readJson(elasticSearchIndexMapping)));
            IndicesAliasesRequest aliasesRequest = new IndicesAliasesRequest();
            IndicesAliasesRequest.AliasActions aliasAction = IndicesAliasesRequest.AliasActions.add().index(elasticSearchIndexType.indexName).alias("sourceUrlSearchAlias");
            aliasesRequest.addAliasAction(aliasAction);
            this.client.indices().updateAliases(aliasesRequest, RequestOptions.DEFAULT);
            if (exists) {
                PutMappingRequest request = new PutMappingRequest(new String[]{elasticSearchIndexType.indexName});
                request.source(elasticSearchIndexMapping, XContentType.JSON);
                AcknowledgedResponse putMappingResponse = this.client.indices().putMapping(request, RequestOptions.DEFAULT);
                LOG.info("{} Updated {}", (Object)elasticSearchIndexType.indexName, (Object)putMappingResponse.isAcknowledged());
            } else {
                CreateIndexRequest request = new CreateIndexRequest(elasticSearchIndexType.indexName);
                request.source(elasticSearchIndexMapping, XContentType.JSON);
                CreateIndexResponse createIndexResponse = this.client.indices().create(request, RequestOptions.DEFAULT);
                LOG.info("{} Created {}", (Object)elasticSearchIndexType.indexName, (Object)createIndexResponse.isAcknowledged());
            }
            elasticSearchIndexes.put(elasticSearchIndexType, IndexUtil.ElasticSearchIndexStatus.CREATED);
        }
        catch (Exception e) {
            elasticSearchIndexes.put(elasticSearchIndexType, IndexUtil.ElasticSearchIndexStatus.FAILED);
            this.updateElasticSearchFailureStatus(IndexUtil.getContext("Updating Index", elasticSearchIndexType.indexName), String.format("Reason: [%s] , Trace : [%s]", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)));
            LOG.error("Failed to update Elastic Search indexes due to", (Throwable)e);
        }
    }

    @Override
    public void deleteIndex(SearchIndexDefinition.ElasticSearchIndexType elasticSearchIndexType) {
        try {
            GetIndexRequest gRequest = new GetIndexRequest(new String[]{elasticSearchIndexType.indexName});
            gRequest.local(false);
            boolean exists = this.client.indices().exists(gRequest, RequestOptions.DEFAULT);
            if (exists) {
                GetAliasesRequest getAliasesRequest = new GetAliasesRequest(new String[]{"sourceUrlSearchAlias"});
                GetAliasesResponse getAliasesResponse = this.client.indices().getAlias(getAliasesRequest, RequestOptions.DEFAULT);
                boolean aliasExists = getAliasesResponse.getAliases().containsKey(elasticSearchIndexType.indexName);
                if (aliasExists) {
                    IndicesAliasesRequest aliasesRequest = new IndicesAliasesRequest();
                    IndicesAliasesRequest.AliasActions aliasAction = IndicesAliasesRequest.AliasActions.remove().index(elasticSearchIndexType.indexName).alias("sourceUrlSearchAlias");
                    aliasesRequest.addAliasAction(aliasAction);
                    this.client.indices().updateAliases(aliasesRequest, RequestOptions.DEFAULT);
                }
                DeleteIndexRequest request = new DeleteIndexRequest(elasticSearchIndexType.indexName);
                AcknowledgedResponse deleteIndexResponse = this.client.indices().delete(request, RequestOptions.DEFAULT);
                LOG.info("{} Deleted {}", (Object)elasticSearchIndexType.indexName, (Object)deleteIndexResponse.isAcknowledged());
            }
        }
        catch (IOException e) {
            this.updateElasticSearchFailureStatus(IndexUtil.getContext("Deleting Index", elasticSearchIndexType.indexName), String.format("Reason: [%s] , Trace : [%s]", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)));
            LOG.error("Failed to delete Elastic Search indexes due to", (Throwable)e);
        }
    }

    @Override
    public Response search(SearchRequest request) throws IOException {
        XContentParser filterParser;
        SearchSourceBuilder searchSourceBuilder;
        switch (request.getIndex()) {
            case "topic_search_index": {
                searchSourceBuilder = ElasticSearchClientImpl.buildTopicSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "dashboard_search_index": {
                searchSourceBuilder = ElasticSearchClientImpl.buildDashboardSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "pipeline_search_index": {
                searchSourceBuilder = ElasticSearchClientImpl.buildPipelineSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "mlmodel_search_index": {
                searchSourceBuilder = ElasticSearchClientImpl.buildMlModelSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "table_search_index": {
                searchSourceBuilder = ElasticSearchClientImpl.buildTableSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "user_search_index": 
            case "team_search_index": {
                searchSourceBuilder = ElasticSearchClientImpl.buildUserOrTeamSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "glossary_search_index": {
                searchSourceBuilder = ElasticSearchClientImpl.buildGlossaryTermSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "tag_search_index": {
                searchSourceBuilder = ElasticSearchClientImpl.buildTagSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "container_search_index": {
                searchSourceBuilder = ElasticSearchClientImpl.buildContainerSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "query_search_index": {
                searchSourceBuilder = ElasticSearchClientImpl.buildQuerySearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            case "test_case_search_index": {
                searchSourceBuilder = ElasticSearchClientImpl.buildTestCaseSearch(request.getQuery(), request.getFrom(), request.getSize());
                break;
            }
            default: {
                searchSourceBuilder = ElasticSearchClientImpl.buildAggregateSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
            }
        }
        if (!CommonUtil.nullOrEmpty((String)request.getQueryFilter()) && !request.getQueryFilter().equals("{}")) {
            try {
                filterParser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, request.getQueryFilter());
                QueryBuilder filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
                BoolQueryBuilder newQuery = QueryBuilders.boolQuery().must(searchSourceBuilder.query()).filter(filter);
                searchSourceBuilder.query((QueryBuilder)newQuery);
            }
            catch (Exception ex) {
                LOG.warn("Error parsing query_filter from query parameters, ignoring filter", (Throwable)ex);
            }
        }
        if (!CommonUtil.nullOrEmpty((String)request.getPostFilter())) {
            try {
                filterParser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, request.getPostFilter());
                QueryBuilder filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
                searchSourceBuilder.postFilter(filter);
            }
            catch (Exception ex) {
                LOG.warn("Error parsing post_filter from query parameters, ignoring filter", (Throwable)ex);
            }
        }
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()).must((QueryBuilder)QueryBuilders.termQuery((String)"deleted", (boolean)request.deleted())));
        if (!CommonUtil.nullOrEmpty((String)request.getSortFieldParam())) {
            searchSourceBuilder.sort(request.getSortFieldParam(), SortOrder.fromString((String)request.getSortOrder()));
        }
        searchSourceBuilder.fetchSource(new FetchSourceContext(request.fetchSource(), (String[])request.getIncludeSourceFields().toArray(String[]::new), new String[0]));
        if (request.trackTotalHits()) {
            searchSourceBuilder.trackTotalHits(true);
        } else {
            searchSourceBuilder.trackTotalHitsUpTo(EntityBuilderConstant.MAX_RESULT_HITS.intValue());
        }
        searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        String response = this.client.search(new org.elasticsearch.action.search.SearchRequest(new String[]{request.getIndex()}).source(searchSourceBuilder), RequestOptions.DEFAULT).toString();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    @Override
    public Response searchBySourceUrl(String sourceUrl) throws IOException {
        QueryStringQueryBuilder wildcardQuery = QueryBuilders.queryStringQuery((String)sourceUrl).field("sourceUrl").escape(true);
        org.elasticsearch.action.search.SearchRequest searchRequest = new org.elasticsearch.action.search.SearchRequest(new String[]{"sourceUrlSearchAlias"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)wildcardQuery);
        searchRequest.source(searchSourceBuilder);
        String response = this.client.search(searchRequest, RequestOptions.DEFAULT).toString();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    @Override
    public Response aggregate(String index, String fieldName, String value, String query) throws IOException {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        XContentParser filterParser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, query);
        QueryBuilder filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must(filter);
        searchSourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)fieldName).field(fieldName)).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue()).includeExclude(new IncludeExclude(value, null)).order(BucketOrder.key((boolean)true))).query((QueryBuilder)boolQueryBuilder).size(0);
        searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        String response = this.client.search(new org.elasticsearch.action.search.SearchRequest(new String[]{index}).source(searchSourceBuilder), RequestOptions.DEFAULT).toString();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    @Override
    public Response suggest(SearchRequest request) throws IOException {
        String fieldName = request.getFieldName();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        CompletionSuggestionBuilder suggestionBuilder = ((CompletionSuggestionBuilder)SuggestBuilders.completionSuggestion((String)fieldName).prefix(request.getQuery(), Fuzziness.AUTO).size(request.getSize())).skipDuplicates(true);
        if (fieldName.equalsIgnoreCase("suggest")) {
            suggestionBuilder.contexts(Collections.singletonMap("deleted", Collections.singletonList(CategoryQueryContext.builder().setCategory(String.valueOf(request.deleted())).build())));
        }
        SuggestBuilder suggestBuilder = new SuggestBuilder();
        suggestBuilder.addSuggestion("metadata-suggest", (SuggestionBuilder)suggestionBuilder);
        searchSourceBuilder.suggest(suggestBuilder).timeout(new TimeValue(30L, TimeUnit.SECONDS)).fetchSource(new FetchSourceContext(request.fetchSource(), (String[])request.getIncludeSourceFields().toArray(String[]::new), new String[0]));
        org.elasticsearch.action.search.SearchRequest searchRequest = new org.elasticsearch.action.search.SearchRequest(new String[]{request.getIndex()}).source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        Suggest suggest = searchResponse.getSuggest();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)suggest.toString()).build();
    }

    private static SearchSourceBuilder buildPipelineSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field("displayName", 15.0f).field("displayName.ngram").field("name", 15.0f).field("description.ngram", 1.0f).field("displayName.keyword", 25.0f).field("name.keyword", 25.0f).field("description", 1.0f).field("tasks.name", 2.0f).field("tasks.description", 1.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightPipelineName = new HighlightBuilder.Field("displayName");
        highlightPipelineName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder.Field highlightTasks = new HighlightBuilder.Field("tasks.name");
        highlightTasks.highlighterType("unified");
        HighlightBuilder.Field highlightTaskDescriptions = new HighlightBuilder.Field("tasks.description");
        highlightTaskDescriptions.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightPipelineName);
        hb.field(highlightTasks);
        hb.field(highlightTaskDescriptions);
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClientImpl.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"tasks.displayName.keyword").field("tasks.displayName.keyword"));
        return ElasticSearchClientImpl.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildMlModelSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field("displayName", 15.0f).field("displayName.ngram").field("name", 15.0f).field("description.ngram", 1.0f).field("displayName.keyword", 25.0f).field("name.keyword", 25.0f).field("description", 1.0f).field("mlFeatures.name", 2.0f).field("mlFeatures.description", 1.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightPipelineName = new HighlightBuilder.Field("displayName");
        highlightPipelineName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder.Field highlightTasks = new HighlightBuilder.Field("mlFeatures.name");
        highlightTasks.highlighterType("unified");
        HighlightBuilder.Field highlightTaskDescriptions = new HighlightBuilder.Field("mlFeatures.description");
        highlightTaskDescriptions.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightPipelineName);
        hb.field(highlightTasks);
        hb.field(highlightTaskDescriptions);
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClientImpl.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        return ElasticSearchClientImpl.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildTopicSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field("displayName", 15.0f).field("displayName.ngram").field("name", 15.0f).field("name.ngram").field("description.ngram", 1.0f).field("displayName.keyword", 25.0f).field("name.keyword", 25.0f).field("description", 1.0f).field("messageSchema.schemaFields.name", 2.0f).field("messageSchema.schemaFields.description", 1.0f).field("messageSchema.schemaFields.children.name", 2.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightTopicName = new HighlightBuilder.Field("displayName");
        highlightTopicName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightTopicName);
        hb.field((HighlightBuilder.Field)new HighlightBuilder.Field("messageSchema.schemaFields.description").highlighterType("unified"));
        hb.field((HighlightBuilder.Field)new HighlightBuilder.Field("messageSchema.schemaFields.children.name").highlighterType("unified"));
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClientImpl.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"messageSchema.schemaFields.name").field("messageSchema.schemaFields.name"));
        return ElasticSearchClientImpl.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildDashboardSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field("displayName", 15.0f).field("displayName.ngram").field("name", 15.0f).field("name.ngram").field("description.ngram", 1.0f).field("displayName.keyword", 25.0f).field("name.keyword", 25.0f).field("description", 1.0f).field("charts.name", 2.0f).field("charts.description", 1.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightDashboardName = new HighlightBuilder.Field("displayName");
        highlightDashboardName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder.Field highlightCharts = new HighlightBuilder.Field("charts.name");
        highlightCharts.highlighterType("unified");
        HighlightBuilder.Field highlightChartDescriptions = new HighlightBuilder.Field("charts.description");
        highlightChartDescriptions.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightDashboardName);
        hb.field(highlightCharts);
        hb.field(highlightChartDescriptions);
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClientImpl.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"dataModels.displayName.keyword").field("dataModels.displayName.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"charts.displayName.keyword").field("charts.displayName.keyword"));
        return ElasticSearchClientImpl.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildTableSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = QueryBuilders.queryStringQuery((String)query).field("displayName", 15.0f).field("displayName.ngram").field("name", 15.0f).field("name.ngram").field("displayName.keyword", 25.0f).field("name.keyword", 25.0f).field("description", 1.0f).field("description.ngram", 1.0f).field("columns.name.keyword", 10.0f).field("columns.name", 2.0f).field("columns.name.ngram").field("columns.displayName", 2.0f).field("columns.displayName.ngram").field("columns.description", 1.0f).field("columns.children.name", 2.0f).type(MultiMatchQueryBuilder.Type.BEST_FIELDS).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        FieldValueFactorFunctionBuilder boostScoreBuilder = ScoreFunctionBuilders.fieldValueFactorFunction((String)"usageSummary.weeklyStats.count").missing(0.0).factor(0.2f);
        FunctionScoreQueryBuilder.FilterFunctionBuilder[] functions = new FunctionScoreQueryBuilder.FilterFunctionBuilder[]{new FunctionScoreQueryBuilder.FilterFunctionBuilder((ScoreFunctionBuilder)boostScoreBuilder)};
        FunctionScoreQueryBuilder queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryStringBuilder, (FunctionScoreQueryBuilder.FilterFunctionBuilder[])functions);
        queryBuilder.boostMode(CombineFunction.SUM);
        HighlightBuilder.Field highlightTableName = new HighlightBuilder.Field("displayName");
        highlightTableName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        HighlightBuilder.Field highlightColumns = new HighlightBuilder.Field("columns.name");
        highlightColumns.highlighterType("unified");
        HighlightBuilder.Field highlightColumnDescriptions = new HighlightBuilder.Field("columns.description");
        highlightColumnDescriptions.highlighterType("unified");
        HighlightBuilder.Field highlightColumnChildren = new HighlightBuilder.Field("columns.children.name");
        highlightColumnDescriptions.highlighterType("unified");
        hb.field(highlightDescription);
        hb.field(highlightTableName);
        hb.field(highlightColumns);
        hb.field(highlightColumnDescriptions);
        hb.field(highlightColumnChildren);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"database.name.keyword").field("database.name.keyword"));
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"databaseSchema.name.keyword").field("databaseSchema.name.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"columns.name.keyword").field("columns.name.keyword"));
        return ElasticSearchClientImpl.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildUserOrTeamSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field("displayName", 3.0f).field("displayName.keyword", 5.0f).field("displayName.ngram").field("name", 2.0f).field("name.keyword", 3.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        return ElasticSearchClientImpl.searchBuilder((QueryBuilder)queryBuilder, null, from, size);
    }

    private static SearchSourceBuilder buildGlossaryTermSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field("displayName", 10.0f).field("displayName.ngram", 1.0f).field("name", 10.0f).field("name.keyword", 10.0f).field("displayName.keyword", 10.0f).field("displayName", 10.0f).field("displayName.ngram").field("synonyms", 5.0f).field("synonyms.ngram").field("description", 3.0f).field("glossary.name", 5.0f).field("glossary.displayName", 5.0f).field("glossary.displayName.ngram").defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightGlossaryName = new HighlightBuilder.Field("name");
        highlightGlossaryName.highlighterType("unified");
        HighlightBuilder.Field highlightGlossaryDisplayName = new HighlightBuilder.Field("displayName");
        highlightGlossaryDisplayName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder.Field highlightSynonym = new HighlightBuilder.Field("synonyms");
        highlightDescription.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightGlossaryName);
        hb.field(highlightGlossaryDisplayName);
        hb.field(highlightSynonym);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"tags.tagFQN").field("tags.tagFQN")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"glossary.name.keyword").field("glossary.name.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"owner.displayName.keyword").field("owner.displayName.keyword"));
        return searchSourceBuilder;
    }

    private static SearchSourceBuilder buildTagSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field("name", 10.0f).field("displayName", 10.0f).field("name.ngram", 1.0f).field("classification.name", 1.0f).field("description", 3.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightTagName = new HighlightBuilder.Field("name");
        highlightTagName.highlighterType("unified");
        HighlightBuilder.Field highlightTagDisplayName = new HighlightBuilder.Field("displayName");
        highlightTagDisplayName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightTagDisplayName);
        hb.field(highlightDescription);
        hb.field(highlightTagName);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        return ElasticSearchClientImpl.searchBuilder((QueryBuilder)queryBuilder, hb, from, size).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"classification.name.keyword").field("classification.name.keyword"));
    }

    private static SearchSourceBuilder buildContainerSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field("displayName", 15.0f).field("displayName.ngram").field("name", 15.0f).field("description", 1.0f).field("description.ngram", 1.0f).field("displayName.keyword", 25.0f).field("name.keyword", 25.0f).field("dataModel.columns.name", 2.0f).field("dataModel.columns.name.keyword", 10.0f).field("dataModel.columns.name.ngram").field("dataModel.columns.displayName", 2.0f).field("dataModel.columns.displayName.ngram").field("dataModel.columns.description", 1.0f).field("dataModel.columns.children.name", 2.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightContainerName = new HighlightBuilder.Field("displayName");
        highlightContainerName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        HighlightBuilder.Field highlightColumns = new HighlightBuilder.Field("dataModel.columns.name");
        highlightColumns.highlighterType("unified");
        HighlightBuilder.Field highlightColumnDescriptions = new HighlightBuilder.Field("dataModel.columns.description");
        highlightColumnDescriptions.highlighterType("unified");
        HighlightBuilder.Field highlightColumnChildren = new HighlightBuilder.Field("dataModel.columns.children.name");
        highlightColumnDescriptions.highlighterType("unified");
        hb.field(highlightDescription);
        hb.field(highlightContainerName);
        hb.field(highlightColumns);
        hb.field(highlightColumnDescriptions);
        hb.field(highlightColumnChildren);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"dataModel.columns.name.keyword").field("dataModel.columns.name.keyword"));
        return ElasticSearchClientImpl.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildQuerySearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field("displayName", 10.0f).field("displayName.ngram").field("query", 10.0f).field("query.ngram").field("description", 1.0f).field("description.ngram", 1.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightGlossaryName = new HighlightBuilder.Field("displayName");
        highlightGlossaryName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder.Field highlightQuery = new HighlightBuilder.Field("query");
        highlightGlossaryName.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightGlossaryName);
        hb.field(highlightQuery);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        return ElasticSearchClientImpl.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
    }

    private static SearchSourceBuilder buildTestCaseSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).field("name", 10.0f).field("description", 3.0f).field("testSuite.fullyQualifiedName", 10.0f).field("testSuite.name", 10.0f).field("testSuite.description", 3.0f).field("entityLink", 3.0f).field("entityFQN", 10.0f).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightTestCaseDescription = new HighlightBuilder.Field("description");
        highlightTestCaseDescription.highlighterType("unified");
        HighlightBuilder.Field highlightTestCaseName = new HighlightBuilder.Field("name");
        highlightTestCaseName.highlighterType("unified");
        HighlightBuilder.Field highlightTestSuiteName = new HighlightBuilder.Field("testSuite.name");
        highlightTestSuiteName.highlighterType("unified");
        HighlightBuilder.Field highlightTestSuiteDescription = new HighlightBuilder.Field("testSuite.description");
        highlightTestSuiteDescription.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightTestCaseDescription);
        hb.field(highlightTestCaseName);
        hb.field(highlightTestSuiteName);
        hb.field(highlightTestSuiteDescription);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        return ElasticSearchClientImpl.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
    }

    private static SearchSourceBuilder buildAggregateSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).lenient(Boolean.valueOf(true));
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClientImpl.searchBuilder((QueryBuilder)queryBuilder, null, from, size);
        return ElasticSearchClientImpl.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder addAggregation(SearchSourceBuilder builder) {
        builder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"serviceType").field("serviceType")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"service.name.keyword").field("service.name.keyword")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType.keyword").field("entityType.keyword")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"tier.tagFQN").field("tier.tagFQN")).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"owner.displayName.keyword").field("owner.displayName.keyword")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"tags.tagFQN").field("tags.tagFQN"));
        return builder;
    }

    private static SearchSourceBuilder searchBuilder(QueryBuilder queryBuilder, HighlightBuilder hb, int from, int size) {
        SearchSourceBuilder builder = new SearchSourceBuilder().query(queryBuilder).from(from).size(size);
        if (hb != null) {
            hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
            hb.postTags(new String[]{"</span>"});
            builder.highlighter(hb);
        }
        return builder;
    }

    @Override
    public ElasticSearchConfiguration.SearchType getSearchType() {
        return ElasticSearchConfiguration.SearchType.ELASTICSEARCH;
    }

    @Override
    public void updateEntity(ChangeEvent event) throws IOException {
        String entityType = event.getEntityType();
        SearchIndexDefinition.ElasticSearchIndexType indexType = IndexUtil.getIndexMappingByEntityType(entityType);
        UpdateRequest updateRequest = new UpdateRequest(indexType.indexName, event.getEntityId().toString());
        switch (event.getEventType()) {
            case ENTITY_CREATED: {
                this.updateSearchForEntityCreated(indexType, entityType, event);
                break;
            }
            case ENTITY_UPDATED: {
                this.updateSearchForEntityUpdated(indexType, entityType, event);
                break;
            }
            case ENTITY_SOFT_DELETED: {
                this.softDeleteOrRestoreEntity(updateRequest, true);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_RESTORED: {
                this.softDeleteOrRestoreEntity(updateRequest, false);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_DELETED: {
                DeleteRequest deleteRequest = new DeleteRequest(indexType.indexName, event.getEntityId().toString());
                this.deleteEntityFromElasticSearch(deleteRequest);
            }
        }
    }

    @Override
    public void updateSearchForEntityCreated(SearchIndexDefinition.ElasticSearchIndexType indexType, String entityType, ChangeEvent event) throws IOException {
        UpdateRequest updateRequest = new UpdateRequest(indexType.indexName, event.getEntityId().toString());
        ElasticSearchIndex index = SearchIndexFactory.buildIndex(entityType, event.getEntity());
        updateRequest.doc(JsonUtils.pojoToJson(index.buildESDoc()), XContentType.JSON);
        updateRequest.docAsUpsert(true);
        updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.updateElasticSearch(updateRequest);
    }

    @Override
    public void updateSearchForEntityUpdated(SearchIndexDefinition.ElasticSearchIndexType indexType, String entityType, ChangeEvent event) throws IOException {
        UpdateRequest updateRequest = new UpdateRequest(indexType.indexName, event.getEntityId().toString());
        if (Objects.equals(event.getCurrentVersion(), event.getPreviousVersion())) {
            updateRequest = this.applyESChangeEvent(event);
        } else {
            ElasticSearchIndex elasticSearchIndex = SearchIndexFactory.buildIndex(entityType, event.getEntity());
            this.scriptedUpsert(elasticSearchIndex.buildESDoc(), updateRequest);
        }
        this.updateElasticSearch(updateRequest);
    }

    @Override
    public void updateUser(ChangeEvent event) throws IOException {
        UpdateRequest updateRequest = new UpdateRequest(SearchIndexDefinition.ElasticSearchIndexType.USER_SEARCH_INDEX.indexName, event.getEntityId().toString());
        switch (event.getEventType()) {
            case ENTITY_CREATED: {
                this.updateSearchForEntityCreated(SearchIndexDefinition.ElasticSearchIndexType.USER_SEARCH_INDEX, "user", event);
                break;
            }
            case ENTITY_UPDATED: {
                UserIndex userIndex = new UserIndex((User)event.getEntity());
                this.scriptedUserUpsert(userIndex.buildESDoc(), updateRequest);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_SOFT_DELETED: {
                this.softDeleteOrRestoreEntity(updateRequest, true);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_RESTORED: {
                this.softDeleteOrRestoreEntity(updateRequest, false);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_DELETED: {
                DeleteRequest deleteRequest = new DeleteRequest(SearchIndexDefinition.ElasticSearchIndexType.USER_SEARCH_INDEX.indexName, event.getEntityId().toString());
                this.deleteEntityFromElasticSearch(deleteRequest);
            }
        }
    }

    @Override
    public void updateTeam(ChangeEvent event) throws IOException {
        UpdateRequest updateRequest = new UpdateRequest(SearchIndexDefinition.ElasticSearchIndexType.TEAM_SEARCH_INDEX.indexName, event.getEntityId().toString());
        switch (event.getEventType()) {
            case ENTITY_CREATED: {
                TeamIndex teamIndex = new TeamIndex((Team)event.getEntity());
                updateRequest.doc(JsonUtils.pojoToJson(teamIndex.buildESDoc()), XContentType.JSON);
                updateRequest.docAsUpsert(true);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_UPDATED: {
                TeamIndex teamIndex = new TeamIndex((Team)event.getEntity());
                this.scriptedTeamUpsert(teamIndex.buildESDoc(), updateRequest);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_SOFT_DELETED: {
                this.softDeleteOrRestoreEntity(updateRequest, true);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_RESTORED: {
                this.softDeleteOrRestoreEntity(updateRequest, false);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_DELETED: {
                DeleteRequest deleteRequest = new DeleteRequest(SearchIndexDefinition.ElasticSearchIndexType.TEAM_SEARCH_INDEX.indexName, event.getEntityId().toString());
                this.deleteEntityFromElasticSearch(deleteRequest);
            }
        }
    }

    @Override
    public void updateGlossaryTerm(ChangeEvent event) throws IOException {
        UpdateRequest updateRequest = new UpdateRequest(SearchIndexDefinition.ElasticSearchIndexType.GLOSSARY_SEARCH_INDEX.indexName, event.getEntityId().toString());
        switch (event.getEventType()) {
            case ENTITY_CREATED: {
                GlossaryTermIndex glossaryTermIndex = new GlossaryTermIndex((GlossaryTerm)event.getEntity());
                updateRequest.doc(JsonUtils.pojoToJson(glossaryTermIndex.buildESDoc()), XContentType.JSON);
                updateRequest.docAsUpsert(true);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_UPDATED: {
                GlossaryTermIndex glossaryTermIndex = new GlossaryTermIndex((GlossaryTerm)event.getEntity());
                this.scriptedUpsert(glossaryTermIndex.buildESDoc(), updateRequest);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_SOFT_DELETED: {
                this.softDeleteOrRestoreEntity(updateRequest, true);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_RESTORED: {
                this.softDeleteOrRestoreEntity(updateRequest, false);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_DELETED: {
                DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{SearchIndexDefinition.ElasticSearchIndexType.GLOSSARY_SEARCH_INDEX.indexName});
                new DeleteRequest(SearchIndexDefinition.ElasticSearchIndexType.GLOSSARY_SEARCH_INDEX.indexName, event.getEntityId().toString());
                GlossaryTerm glossaryTerm = (GlossaryTerm)event.getEntity();
                request.setQuery((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"id", (Object)glossaryTerm.getId().toString())).should((QueryBuilder)QueryBuilders.matchQuery((String)"parent.id", (Object)glossaryTerm.getId().toString())));
                this.deleteEntityFromElasticSearchByQuery(request);
            }
        }
    }

    @Override
    public void updateGlossary(ChangeEvent event) throws IOException {
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            Glossary glossary = (Glossary)event.getEntity();
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{SearchIndexDefinition.ElasticSearchIndexType.GLOSSARY_SEARCH_INDEX.indexName});
            request.setQuery((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"glossary.id", (Object)glossary.getId().toString())));
            this.deleteEntityFromElasticSearchByQuery(request);
        }
    }

    @Override
    public void updateTag(ChangeEvent event) throws IOException {
        UpdateRequest updateRequest = new UpdateRequest(SearchIndexDefinition.ElasticSearchIndexType.TAG_SEARCH_INDEX.indexName, event.getEntityId().toString());
        switch (event.getEventType()) {
            case ENTITY_CREATED: {
                TagIndex tagIndex = new TagIndex((Tag)event.getEntity());
                updateRequest.doc(JsonUtils.pojoToJson(tagIndex.buildESDoc()), XContentType.JSON);
                updateRequest.docAsUpsert(true);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_UPDATED: {
                if (Objects.equals(event.getCurrentVersion(), event.getPreviousVersion())) {
                    updateRequest = this.applyESChangeEvent(event);
                } else {
                    TagIndex tagIndex = new TagIndex((Tag)event.getEntity());
                    this.scriptedUpsert(tagIndex.buildESDoc(), updateRequest);
                }
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_SOFT_DELETED: {
                this.softDeleteOrRestoreEntity(updateRequest, true);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_RESTORED: {
                this.softDeleteOrRestoreEntity(updateRequest, false);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_DELETED: {
                int totalHits;
                SearchResponse response;
                DeleteRequest deleteRequest = new DeleteRequest(SearchIndexDefinition.ElasticSearchIndexType.TAG_SEARCH_INDEX.indexName, event.getEntityId().toString());
                this.deleteEntityFromElasticSearch(deleteRequest);
                String[] indexes = new String[]{SearchIndexDefinition.ElasticSearchIndexType.TABLE_SEARCH_INDEX.indexName, SearchIndexDefinition.ElasticSearchIndexType.TOPIC_SEARCH_INDEX.indexName, SearchIndexDefinition.ElasticSearchIndexType.DASHBOARD_SEARCH_INDEX.indexName, SearchIndexDefinition.ElasticSearchIndexType.PIPELINE_SEARCH_INDEX.indexName, SearchIndexDefinition.ElasticSearchIndexType.GLOSSARY_SEARCH_INDEX.indexName, SearchIndexDefinition.ElasticSearchIndexType.MLMODEL_SEARCH_INDEX.indexName};
                BulkRequest request = new BulkRequest();
                int batchSize = 50;
                int currentHits = 0;
                do {
                    org.elasticsearch.action.search.SearchRequest searchRequest = this.searchRequest(indexes, "tags.tagFQN", event.getEntityFullyQualifiedName(), batchSize, currentHits);
                    response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                    totalHits = (int)response.getHits().getTotalHits().value;
                    for (SearchHit hit : response.getHits()) {
                        Map sourceAsMap = hit.getSourceAsMap();
                        List listTags = (List)sourceAsMap.get("tags");
                        Script script = this.generateTagScript(listTags);
                        if (script.toString().isEmpty()) continue;
                        request.add(this.updateRequests(sourceAsMap.get("entityType").toString(), sourceAsMap.get("id").toString(), script));
                    }
                } while ((currentHits += response.getHits().getHits().length) < totalHits);
                if (request.numberOfActions() <= 0) break;
                this.client.bulk(request, RequestOptions.DEFAULT);
            }
        }
    }

    @Override
    public void updateDatabase(ChangeEvent event) throws IOException {
        Database database = (Database)event.getEntity();
        SearchIndexDefinition.ElasticSearchIndexType indexType = IndexUtil.getIndexMappingByEntityType("table");
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{indexType.indexName});
            BoolQueryBuilder queryBuilder = new BoolQueryBuilder();
            queryBuilder.must((QueryBuilder)new TermQueryBuilder("database.id", database.getId().toString()));
            request.setQuery((QueryBuilder)queryBuilder);
            this.deleteEntityFromElasticSearchByQuery(request);
        } else if (event.getEventType() == EventType.ENTITY_SOFT_DELETED) {
            this.softDeleteOrRestoreChildren(indexType.indexName, "database.id", database.getId().toString(), true);
        } else if (event.getEventType() == EventType.ENTITY_RESTORED) {
            this.softDeleteOrRestoreChildren(indexType.indexName, "database.id", database.getId().toString(), false);
        }
    }

    @Override
    public void updateDatabaseSchema(ChangeEvent event) throws IOException {
        SearchIndexDefinition.ElasticSearchIndexType indexType = IndexUtil.getIndexMappingByEntityType("table");
        DatabaseSchema databaseSchema = (DatabaseSchema)event.getEntity();
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{indexType.indexName});
            BoolQueryBuilder queryBuilder = new BoolQueryBuilder();
            queryBuilder.must((QueryBuilder)new TermQueryBuilder("databaseSchema.id", databaseSchema.getId().toString()));
            request.setQuery((QueryBuilder)queryBuilder);
            this.deleteEntityFromElasticSearchByQuery(request);
        } else if (event.getEventType() == EventType.ENTITY_SOFT_DELETED) {
            this.softDeleteOrRestoreChildren(indexType.indexName, "databaseSchema.id", databaseSchema.getId().toString(), true);
        } else if (event.getEventType() == EventType.ENTITY_RESTORED) {
            this.softDeleteOrRestoreChildren(indexType.indexName, "databaseSchema.id", databaseSchema.getId().toString(), false);
        }
    }

    @Override
    public void updateDatabaseService(ChangeEvent event) throws IOException {
        SearchIndexDefinition.ElasticSearchIndexType indexType = IndexUtil.getIndexMappingByEntityType("table");
        DatabaseService databaseService = (DatabaseService)event.getEntity();
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{indexType.indexName});
            request.setQuery((QueryBuilder)new TermQueryBuilder("service.id", databaseService.getId().toString()));
            this.deleteEntityFromElasticSearchByQuery(request);
        } else if (event.getEventType() == EventType.ENTITY_SOFT_DELETED) {
            this.softDeleteOrRestoreChildren(indexType.indexName, "service.id", databaseService.getId().toString(), true);
        } else if (event.getEventType() == EventType.ENTITY_RESTORED) {
            this.softDeleteOrRestoreChildren(indexType.indexName, "service.id", databaseService.getId().toString(), false);
        }
    }

    @Override
    public void updatePipelineService(ChangeEvent event) throws IOException {
        SearchIndexDefinition.ElasticSearchIndexType indexType = IndexUtil.getIndexMappingByEntityType("pipeline");
        PipelineService pipelineService = (PipelineService)event.getEntity();
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{indexType.indexName});
            request.setQuery((QueryBuilder)new TermQueryBuilder("service.id", pipelineService.getId().toString()));
            this.deleteEntityFromElasticSearchByQuery(request);
        } else if (event.getEventType() == EventType.ENTITY_SOFT_DELETED) {
            this.softDeleteOrRestoreChildren(indexType.indexName, "service.id", pipelineService.getId().toString(), true);
        } else if (event.getEventType() == EventType.ENTITY_RESTORED) {
            this.softDeleteOrRestoreChildren(indexType.indexName, "service.id", pipelineService.getId().toString(), false);
        }
    }

    @Override
    public void updateElasticSearch(UpdateRequest updateRequest) throws IOException {
        if (updateRequest != null) {
            LOG.debug("Sending request to ElasticSearch {}", (Object)updateRequest);
            this.client.update(updateRequest, RequestOptions.DEFAULT);
        }
    }

    @Override
    public void updateMlModelService(ChangeEvent event) throws IOException {
        SearchIndexDefinition.ElasticSearchIndexType indexType = IndexUtil.getIndexMappingByEntityType("mlmodel");
        MlModelService mlModelService = (MlModelService)event.getEntity();
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{indexType.indexName});
            request.setQuery((QueryBuilder)new TermQueryBuilder("service.id", mlModelService.getId().toString()));
            this.deleteEntityFromElasticSearchByQuery(request);
        } else if (event.getEventType() == EventType.ENTITY_SOFT_DELETED) {
            this.softDeleteOrRestoreChildren(indexType.indexName, "service.id", mlModelService.getId().toString(), true);
        } else if (event.getEventType() == EventType.ENTITY_RESTORED) {
            this.softDeleteOrRestoreChildren(indexType.indexName, "service.id", mlModelService.getId().toString(), false);
        }
    }

    @Override
    public void updateStorageService(ChangeEvent event) throws IOException {
        SearchIndexDefinition.ElasticSearchIndexType indexType = IndexUtil.getIndexMappingByEntityType("container");
        StorageService storageService = (StorageService)event.getEntity();
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{indexType.indexName});
            request.setQuery((QueryBuilder)new TermQueryBuilder("service.id", storageService.getId().toString()));
            this.deleteEntityFromElasticSearchByQuery(request);
        } else if (event.getEventType() == EventType.ENTITY_SOFT_DELETED) {
            this.softDeleteOrRestoreChildren(indexType.indexName, "service.id", storageService.getId().toString(), true);
        } else if (event.getEventType() == EventType.ENTITY_RESTORED) {
            this.softDeleteOrRestoreChildren(indexType.indexName, "service.id", storageService.getId().toString(), false);
        }
    }

    @Override
    public void updateMessagingService(ChangeEvent event) throws IOException {
        SearchIndexDefinition.ElasticSearchIndexType indexType = IndexUtil.getIndexMappingByEntityType("topic");
        MessagingService messagingService = (MessagingService)event.getEntity();
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{indexType.indexName});
            request.setQuery((QueryBuilder)new TermQueryBuilder("service.id", messagingService.getId().toString()));
            this.deleteEntityFromElasticSearchByQuery(request);
        } else if (event.getEventType() == EventType.ENTITY_SOFT_DELETED) {
            this.softDeleteOrRestoreChildren(indexType.indexName, "service.id", messagingService.getId().toString(), true);
        } else if (event.getEventType() == EventType.ENTITY_RESTORED) {
            this.softDeleteOrRestoreChildren(indexType.indexName, "service.id", messagingService.getId().toString(), false);
        }
    }

    @Override
    public void updateDashboardService(ChangeEvent event) throws IOException {
        SearchIndexDefinition.ElasticSearchIndexType indexType = IndexUtil.getIndexMappingByEntityType("dashboard");
        DashboardService dashboardService = (DashboardService)event.getEntity();
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{indexType.indexName});
            request.setQuery((QueryBuilder)new TermQueryBuilder("service.id", dashboardService.getId().toString()));
            this.deleteEntityFromElasticSearchByQuery(request);
        } else if (event.getEventType() == EventType.ENTITY_SOFT_DELETED) {
            this.softDeleteOrRestoreChildren(indexType.indexName, "service.id", dashboardService.getId().toString(), true);
        } else if (event.getEventType() == EventType.ENTITY_RESTORED) {
            this.softDeleteOrRestoreChildren(indexType.indexName, "service.id", dashboardService.getId().toString(), true);
        }
    }

    @Override
    public void updateClassification(ChangeEvent event) throws IOException {
        Classification classification = (Classification)event.getEntity();
        String indexName = SearchIndexDefinition.ElasticSearchIndexType.TAG_SEARCH_INDEX.indexName;
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{indexName});
            String fqnMatch = classification.getName() + ".*";
            request.setQuery((QueryBuilder)new WildcardQueryBuilder("fullyQualifiedName", fqnMatch));
            this.deleteEntityFromElasticSearchByQuery(request);
        } else if (event.getEventType() == EventType.ENTITY_UPDATED) {
            UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(new String[]{indexName});
            updateByQueryRequest.setQuery((QueryBuilder)new MatchQueryBuilder("tag.classification.id", (Object)classification.getId().toString()));
            String scriptTxt = "ctx._source.disabled=true";
            Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, new HashMap());
            updateByQueryRequest.setScript(script);
            this.updateElasticSearchByQuery(updateByQueryRequest);
        }
    }

    @Override
    public void updateTestSuite(ChangeEvent event) throws IOException {
        SearchIndexDefinition.ElasticSearchIndexType indexType = IndexUtil.getIndexMappingByEntityType("testCase");
        TestSuite testSuite = (TestSuite)event.getEntity();
        UUID testSuiteId = testSuite.getId();
        if (event.getEventType() == EventType.ENTITY_DELETED) {
            if (Boolean.TRUE.equals(testSuite.getExecutable())) {
                DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{indexType.indexName});
                deleteByQueryRequest.setQuery((QueryBuilder)new MatchQueryBuilder("testSuites.id", (Object)testSuiteId.toString()));
                this.deleteEntityFromElasticSearchByQuery(deleteByQueryRequest);
            } else {
                UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(new String[]{indexType.indexName});
                updateByQueryRequest.setQuery((QueryBuilder)new MatchQueryBuilder("testSuites.id", (Object)testSuiteId.toString()));
                String scriptTxt = "for (int i = 0; i < ctx._source.testSuites.length; i++) { if (ctx._source.testSuites[i].id == '%s') { ctx._source.testSuites.remove(i) }}";
                Script script = new Script(ScriptType.INLINE, "painless", String.format(scriptTxt, testSuiteId), new HashMap());
                updateByQueryRequest.setScript(script);
                this.updateElasticSearchByQuery(updateByQueryRequest);
            }
        }
    }

    private void updateElasticSearchByQuery(UpdateByQueryRequest updateByQueryRequest) throws IOException {
        if (updateByQueryRequest != null) {
            LOG.debug("Sending request to ElasticSearch {}", (Object)updateByQueryRequest);
            this.client.updateByQuery(updateByQueryRequest, RequestOptions.DEFAULT);
        }
    }

    @Override
    public void addTestCaseFromLogicalTestSuite(TestSuite testSuite, ChangeEvent event, SearchIndexDefinition.ElasticSearchIndexType indexType) throws IOException {
        List testCaseReferences = testSuite.getTests();
        TestSuite testSuiteReference = new TestSuite().withId(testSuite.getId()).withName(testSuite.getName()).withDisplayName(testSuite.getDisplayName()).withDescription(testSuite.getDescription()).withFullyQualifiedName(testSuite.getFullyQualifiedName()).withDeleted(testSuite.getDeleted()).withHref(testSuite.getHref()).withExecutable(testSuite.getExecutable());
        Map<String, Object> testSuiteDoc = JsonUtils.getMap(testSuiteReference);
        if (event.getEventType() == EventType.ENTITY_UPDATED) {
            for (EntityReference testcaseReference : testCaseReferences) {
                UpdateRequest updateRequest = new UpdateRequest(indexType.indexName, testcaseReference.getId().toString());
                String scripText = "ctx._source.testSuites.add(params)";
                Script script = new Script(ScriptType.INLINE, "painless", scripText, testSuiteDoc);
                updateRequest.script(script);
                this.updateElasticSearch(updateRequest);
            }
        }
    }

    @Override
    public void processTestCase(TestCase testCase, ChangeEvent event, SearchIndexDefinition.ElasticSearchIndexType indexType) throws IOException {
        UpdateRequest updateRequest = new UpdateRequest(indexType.indexName, testCase.getId().toString());
        switch (event.getEventType()) {
            case ENTITY_CREATED: {
                TestCaseIndex testCaseIndex = new TestCaseIndex((TestCase)event.getEntity());
                updateRequest.doc(JsonUtils.pojoToJson(testCaseIndex.buildESDocForCreate()), XContentType.JSON);
                updateRequest.docAsUpsert(true);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_UPDATED: {
                TestCaseIndex testCaseIndex = new TestCaseIndex((TestCase)event.getEntity());
                this.scriptedUpsert(testCaseIndex.buildESDoc(), updateRequest);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_SOFT_DELETED: {
                this.softDeleteOrRestoreEntity(updateRequest, true);
                this.updateElasticSearch(updateRequest);
                break;
            }
            case ENTITY_DELETED: {
                EntityReference testSuiteReference = ((TestCase)event.getEntity()).getTestSuite();
                TestSuite testSuite = (TestSuite)Entity.getEntity("testSuite", testSuiteReference.getId(), "", Include.ALL);
                if (Boolean.TRUE.equals(testSuite.getExecutable())) {
                    DeleteRequest deleteRequest = new DeleteRequest(indexType.indexName, event.getEntityId().toString());
                    this.deleteEntityFromElasticSearch(deleteRequest);
                    break;
                }
                this.scriptedDeleteTestCase(updateRequest, testSuite.getId());
                this.updateElasticSearch(updateRequest);
            }
        }
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (Exception e) {
            LOG.error("Failed to close elastic search", (Throwable)e);
        }
    }

    private void scriptedUpsert(Object doc, UpdateRequest updateRequest) {
        String scriptTxt = "for (k in params.keySet()) { ctx._source.put(k, params.get(k)) }";
        Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, JsonUtils.getMap(doc));
        updateRequest.script(script);
        updateRequest.scriptedUpsert(true);
        updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
    }

    private void scriptedUserUpsert(Object index, UpdateRequest updateRequest) {
        String scriptTxt = "for (k in params.keySet()) {ctx._source.put(k, params.get(k)) }";
        Map<String, Object> doc = JsonUtils.getMap(index);
        Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, doc);
        updateRequest.script(script);
        updateRequest.scriptedUpsert(true);
    }

    private void scriptedTeamUpsert(Object index, UpdateRequest updateRequest) {
        String scriptTxt = "for (k in params.keySet()) { ctx._source.put(k, params.get(k)) }";
        Map<String, Object> doc = JsonUtils.getMap(index);
        Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, doc);
        updateRequest.script(script);
        updateRequest.scriptedUpsert(true);
    }

    private void softDeleteOrRestoreEntity(UpdateRequest updateRequest, boolean delete) {
        String scriptTxt = "ctx._source.deleted=" + delete;
        Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, new HashMap());
        updateRequest.script(script);
    }

    private void softDeleteOrRestoreChildren(String indexName, String parentField, String parentValue, boolean delete) throws IOException {
        UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(new String[]{indexName});
        updateByQueryRequest.setQuery((QueryBuilder)new MatchQueryBuilder(parentField, (Object)parentValue));
        String scriptTxt = "ctx._source.deleted=" + delete;
        Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, new HashMap());
        updateByQueryRequest.setScript(script);
        this.updateElasticSearchByQuery(updateByQueryRequest);
    }

    private void scriptedDeleteTestCase(UpdateRequest updateRequest, UUID testSuiteId) {
        String scriptTxt = "for (int i = 0; i < ctx._source.testSuite.length; i++) { if (ctx._source.testSuite[i].id == '%s') { ctx._source.testSuite.remove(i) }}";
        scriptTxt = String.format(scriptTxt, testSuiteId);
        Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, new HashMap());
        updateRequest.script(script);
    }

    private void deleteEntityFromElasticSearch(DeleteRequest deleteRequest) throws IOException {
        if (deleteRequest != null) {
            LOG.debug("Sending request to ElasticSearch {}", (Object)deleteRequest);
            deleteRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
            this.client.delete(deleteRequest, RequestOptions.DEFAULT);
        }
    }

    private void deleteEntityFromElasticSearchByQuery(DeleteByQueryRequest deleteRequest) throws IOException {
        if (deleteRequest != null) {
            LOG.debug("Sending request to ElasticSearch {}", (Object)deleteRequest);
            deleteRequest.setRefresh(true);
            this.client.deleteByQuery(deleteRequest, RequestOptions.DEFAULT);
        }
    }

    @Override
    public UpdateRequest applyESChangeEvent(ChangeEvent event) {
        String entityType = event.getEntityType();
        SearchIndexDefinition.ElasticSearchIndexType esIndexType = IndexUtil.getIndexMappingByEntityType(entityType);
        UUID entityId = event.getEntityId();
        String scriptTxt = "";
        HashMap<String, Object> fieldParams = new HashMap<String, Object>();
        this.getScriptWithParams(event, scriptTxt, fieldParams);
        if (!CommonUtil.nullOrEmpty((String)scriptTxt)) {
            Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, fieldParams);
            UpdateRequest updateRequest = new UpdateRequest(esIndexType.indexName, entityId.toString());
            updateRequest.script(script);
            return updateRequest;
        }
        return null;
    }

    private org.elasticsearch.action.search.SearchRequest searchRequest(String[] indexes, String field, String value, int batchSize, int from) {
        org.elasticsearch.action.search.SearchRequest searchRequest = new org.elasticsearch.action.search.SearchRequest(indexes);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchQuery((String)field, (Object)value));
        searchSourceBuilder.from(from);
        searchSourceBuilder.size(batchSize);
        searchSourceBuilder.timeout(new TimeValue(60L, TimeUnit.SECONDS));
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    private Script generateTagScript(List<TagLabel> listTags) {
        StringBuilder scriptTxt = new StringBuilder();
        HashMap<String, List<TagLabel>> fieldRemoveParams = new HashMap<String, List<TagLabel>>();
        fieldRemoveParams.put("tags", listTags);
        scriptTxt.append("ctx._source.tags=params.tags;");
        scriptTxt.append("ctx._source.tags.removeAll(params.tags);");
        fieldRemoveParams.put("tags", listTags);
        return new Script(ScriptType.INLINE, "painless", scriptTxt.toString(), fieldRemoveParams);
    }

    private UpdateRequest updateRequests(String entityType, String entityId, Script script) {
        return new UpdateRequest(IndexUtil.ENTITY_TYPE_TO_INDEX_MAP.get(entityType), entityId).script(script);
    }

    @Override
    public BulkResponse bulk(BulkRequest data, RequestOptions options) throws IOException {
        return this.client.bulk(data, RequestOptions.DEFAULT);
    }

    @Override
    public int getSuccessFromBulkResponse(BulkResponse response) {
        int success = 0;
        for (BulkItemResponse bulkItemResponse : response) {
            if (bulkItemResponse.isFailed()) continue;
            ++success;
        }
        return success;
    }

    @Override
    public TreeMap<Long, List<Object>> getSortedDate(String team, Long scheduleTime, Long currentTime, DataInsightChartResult.DataInsightChartType chartType, String indexName) throws IOException, ParseException {
        org.elasticsearch.action.search.SearchRequest searchRequestTotalAssets = ElasticSearchClientImpl.buildSearchRequest(scheduleTime, currentTime, null, team, chartType, indexName);
        SearchResponse searchResponseTotalAssets = this.client.search(searchRequestTotalAssets, RequestOptions.DEFAULT);
        DataInsightChartResult processedDataTotalAssets = ElasticSearchClientImpl.processDataInsightChartResult(searchResponseTotalAssets, chartType);
        TreeMap<Long, List<Object>> dateWithDataMap = new TreeMap<Long, List<Object>>();
        for (Object data : processedDataTotalAssets.getData()) {
            DataInsightInterface convertedData = (DataInsightInterface)data;
            Long timestamp = convertedData.getTimestamp();
            List<Object> totalEntitiesByTypeList = new ArrayList<DataInsightInterface>();
            if (dateWithDataMap.containsKey(timestamp)) {
                totalEntitiesByTypeList = dateWithDataMap.get(timestamp);
            }
            totalEntitiesByTypeList.add(convertedData);
            dateWithDataMap.put(timestamp, totalEntitiesByTypeList);
        }
        return dateWithDataMap;
    }

    @Override
    public Response listDataInsightChartResult(Long startTs, Long endTs, String tier, String team, DataInsightChartResult.DataInsightChartType dataInsightChartName, String dataReportIndex) throws IOException, ParseException {
        org.elasticsearch.action.search.SearchRequest searchRequest = ElasticSearchClientImpl.buildSearchRequest(startTs, endTs, tier, team, dataInsightChartName, dataReportIndex);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ElasticSearchClientImpl.processDataInsightChartResult(searchResponse, dataInsightChartName)).build();
    }

    private static DataInsightChartResult processDataInsightChartResult(SearchResponse searchResponse, DataInsightChartResult.DataInsightChartType dataInsightChartName) throws ParseException {
        DataInsightAggregatorInterface processor = ElasticSearchClientImpl.createDataAggregator(searchResponse.getAggregations(), dataInsightChartName);
        return processor.process();
    }

    private static DataInsightAggregatorInterface createDataAggregator(Aggregations aggregations, DataInsightChartResult.DataInsightChartType dataInsightChartType) throws IllegalArgumentException {
        switch (dataInsightChartType) {
            case PERCENTAGE_OF_ENTITIES_WITH_DESCRIPTION_BY_TYPE: {
                return new EsEntitiesDescriptionAggregator(aggregations, dataInsightChartType);
            }
            case PERCENTAGE_OF_SERVICES_WITH_DESCRIPTION: {
                return new EsServicesDescriptionAggregator(aggregations, dataInsightChartType);
            }
            case PERCENTAGE_OF_ENTITIES_WITH_OWNER_BY_TYPE: {
                return new EsEntitiesOwnerAggregator(aggregations, dataInsightChartType);
            }
            case PERCENTAGE_OF_SERVICES_WITH_OWNER: {
                return new EsServicesOwnerAggregator(aggregations, dataInsightChartType);
            }
            case TOTAL_ENTITIES_BY_TYPE: {
                return new EsTotalEntitiesAggregator(aggregations, dataInsightChartType);
            }
            case TOTAL_ENTITIES_BY_TIER: {
                return new EsTotalEntitiesByTierAggregator(aggregations, dataInsightChartType);
            }
            case DAILY_ACTIVE_USERS: {
                return new EsDailyActiveUsersAggregator(aggregations, dataInsightChartType);
            }
            case PAGE_VIEWS_BY_ENTITIES: {
                return new EsPageViewsByEntitiesAggregator(aggregations, dataInsightChartType);
            }
            case MOST_ACTIVE_USERS: {
                return new EsMostActiveUsersAggregator(aggregations, dataInsightChartType);
            }
            case MOST_VIEWED_ENTITIES: {
                return new EsMostViewedEntitiesAggregator(aggregations, dataInsightChartType);
            }
        }
        throw new IllegalArgumentException(String.format("No processor found for chart Type %s ", dataInsightChartType));
    }

    private static org.elasticsearch.action.search.SearchRequest buildSearchRequest(Long startTs, Long endTs, String tier, String team, DataInsightChartResult.DataInsightChartType dataInsightChartName, String dataReportIndex) {
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClientImpl.buildQueryFilter(startTs, endTs, tier, team, dataInsightChartName.value());
        AggregationBuilder aggregationBuilder = ElasticSearchClientImpl.buildQueryAggregation(dataInsightChartName);
        searchSourceBuilder.aggregation(aggregationBuilder);
        searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        org.elasticsearch.action.search.SearchRequest searchRequest = new org.elasticsearch.action.search.SearchRequest(new String[]{dataReportIndex});
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    private static SearchSourceBuilder buildQueryFilter(Long startTs, Long endTs, String tier, String team, String dataInsightChartName) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder searchQueryFiler = new BoolQueryBuilder();
        if (team != null && DataInsightChartRepository.SUPPORTS_TEAM_FILTER.contains(dataInsightChartName)) {
            List<String> teamArray = Arrays.asList(team.split("\\s*,\\s*"));
            BoolQueryBuilder teamQueryFilter = QueryBuilders.boolQuery();
            teamQueryFilter.should((QueryBuilder)QueryBuilders.termsQuery((String)"data.team", teamArray));
            searchQueryFiler.must((QueryBuilder)teamQueryFilter);
        }
        if (tier != null && DataInsightChartRepository.SUPPORTS_TIER_FILTER.contains(dataInsightChartName)) {
            List<String> tierArray = Arrays.asList(tier.split("\\s*,\\s*"));
            BoolQueryBuilder tierQueryFilter = QueryBuilders.boolQuery();
            tierQueryFilter.should((QueryBuilder)QueryBuilders.termsQuery((String)"data.entityTier", tierArray));
            searchQueryFiler.must((QueryBuilder)tierQueryFilter);
        }
        RangeQueryBuilder dateQueryFilter = QueryBuilders.rangeQuery((String)"timestamp").gte((Object)startTs).lte((Object)endTs);
        searchQueryFiler.must((QueryBuilder)dateQueryFilter);
        return searchSourceBuilder.query((QueryBuilder)searchQueryFiler).fetchSource(false);
    }

    private static AggregationBuilder buildQueryAggregation(DataInsightChartResult.DataInsightChartType dataInsightChartName) throws IllegalArgumentException {
        DateHistogramAggregationBuilder dateHistogramAggregationBuilder = ((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"timestamp").field("timestamp")).calendarInterval(DateHistogramInterval.minutes((int)1));
        SumAggregationBuilder sumEntityCountAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"entityCount").field("data.entityCount");
        switch (dataInsightChartName) {
            case PERCENTAGE_OF_ENTITIES_WITH_DESCRIPTION_BY_TYPE: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType")).size(1000);
                SumAggregationBuilder sumAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"completedDescriptionFraction").field("data.completedDescriptions");
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumAggregationBuilder)).subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case PERCENTAGE_OF_SERVICES_WITH_DESCRIPTION: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"serviceName").field("data.serviceName")).size(1000);
                SumAggregationBuilder sumAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"completedDescriptionFraction").field("data.completedDescriptions");
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumAggregationBuilder)).subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case PERCENTAGE_OF_ENTITIES_WITH_OWNER_BY_TYPE: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType")).size(1000);
                SumAggregationBuilder sumAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"hasOwnerFraction").field("data.hasOwner");
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumAggregationBuilder)).subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case PERCENTAGE_OF_SERVICES_WITH_OWNER: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"serviceName").field("data.serviceName")).size(1000);
                SumAggregationBuilder sumAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"hasOwnerFraction").field("data.hasOwner");
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumAggregationBuilder)).subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case TOTAL_ENTITIES_BY_TIER: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityTier").field("data.entityTier")).missing((Object)"NoTier")).size(1000);
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case TOTAL_ENTITIES_BY_TYPE: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType")).size(1000);
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case DAILY_ACTIVE_USERS: {
                return dateHistogramAggregationBuilder;
            }
            case PAGE_VIEWS_BY_ENTITIES: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType")).size(1000);
                SumAggregationBuilder sumPageViewsByEntityTypes = (SumAggregationBuilder)AggregationBuilders.sum((String)"pageViews").field("data.views");
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumPageViewsByEntityTypes));
            }
            case MOST_VIEWED_ENTITIES: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityFqn").field("data.entityFqn")).size(10).order(BucketOrder.aggregation((String)"pageViews", (boolean)false));
                TermsAggregationBuilder ownerTermsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"owner").field("data.owner");
                TermsAggregationBuilder entityTypeTermsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType");
                TermsAggregationBuilder entityHrefAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"entityHref").field("data.entityHref");
                SumAggregationBuilder sumEntityPageViewsAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"pageViews").field("data.views");
                return ((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumEntityPageViewsAggregationBuilder)).subAggregation((AggregationBuilder)ownerTermsAggregationBuilder)).subAggregation((AggregationBuilder)entityTypeTermsAggregationBuilder)).subAggregation((AggregationBuilder)entityHrefAggregationBuilder);
            }
            case MOST_ACTIVE_USERS: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"userName").field("data.userName")).size(10).order(BucketOrder.aggregation((String)"sessions", (boolean)false));
                TermsAggregationBuilder teamTermsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"team").field("data.team");
                SumAggregationBuilder sumSessionAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"sessions").field("data.totalSessions");
                SumAggregationBuilder sumUserPageViewsAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"pageViews").field("data.totalPageView");
                MaxAggregationBuilder lastSessionAggregationBuilder = (MaxAggregationBuilder)AggregationBuilders.max((String)"lastSession").field("data.lastSession");
                SumAggregationBuilder sumSessionDurationAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"sessionDuration").field("data.totalSessionDuration");
                return ((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumSessionAggregationBuilder)).subAggregation((AggregationBuilder)sumUserPageViewsAggregationBuilder)).subAggregation((AggregationBuilder)lastSessionAggregationBuilder)).subAggregation((AggregationBuilder)sumSessionDurationAggregationBuilder)).subAggregation((AggregationBuilder)teamTermsAggregationBuilder);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid dataInsightChartType name %s", dataInsightChartName));
    }

    public static RestHighLevelClient createElasticSearchClient(ElasticSearchConfiguration esConfig) {
        try {
            RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(esConfig.getHost(), esConfig.getPort().intValue(), esConfig.getScheme())});
            if (StringUtils.isNotEmpty((CharSequence)esConfig.getUsername()) && StringUtils.isNotEmpty((CharSequence)esConfig.getPassword())) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(esConfig.getUsername(), esConfig.getPassword()));
                SSLContext sslContext = IndexUtil.createElasticSearchSSLContext(esConfig);
                restClientBuilder.setHttpClientConfigCallback(arg_0 -> ElasticSearchClientImpl.lambda$createElasticSearchClient$3((CredentialsProvider)credentialsProvider, sslContext, esConfig, arg_0));
            }
            restClientBuilder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(esConfig.getConnectionTimeoutSecs() * 1000).setSocketTimeout(esConfig.getSocketTimeoutSecs() * 1000));
            return new RestHighLevelClient(restClientBuilder);
        }
        catch (Exception e) {
            throw new ElasticsearchException("Failed to create elastic search client ", (Throwable)e, new Object[0]);
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createElasticSearchClient$3(CredentialsProvider credentialsProvider, SSLContext sslContext, ElasticSearchConfiguration esConfig, HttpAsyncClientBuilder httpAsyncClientBuilder) {
        httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        if (sslContext != null) {
            httpAsyncClientBuilder.setSSLContext(sslContext);
        }
        if (esConfig.getKeepAliveTimeoutSecs() != null && esConfig.getKeepAliveTimeoutSecs() > 0) {
            httpAsyncClientBuilder.setKeepAliveStrategy((response, context) -> esConfig.getKeepAliveTimeoutSecs() * 1000);
        }
        return httpAsyncClientBuilder;
    }

    static {
        SearchModule searchModule = new SearchModule(Settings.EMPTY, false, List.of());
        xContentRegistry = new NamedXContentRegistry(searchModule.getNamedXContents());
    }
}

