/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.elasticSearch;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.dataInsight.type.TotalEntitiesByTier;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public class EsTotalEntitiesByTierAggregator
extends DataInsightAggregatorInterface {
    public EsTotalEntitiesByTierAggregator(Aggregations aggregations, DataInsightChartResult.DataInsightChartType dataInsightChartType) {
        super(aggregations, dataInsightChartType);
    }

    @Override
    public DataInsightChartResult process() throws ParseException {
        List<Object> data = this.aggregate();
        return new DataInsightChartResult().withData(data).withChartType(this.dataInsightChartType);
    }

    @Override
    public List<Object> aggregate() throws ParseException {
        Histogram timestampBuckets = (Histogram)this.aggregationsEs.get("timestamp");
        ArrayList<Object> data = new ArrayList<Object>();
        for (Histogram.Bucket timestampBucket : timestampBuckets.getBuckets()) {
            ArrayList<TotalEntitiesByTier> timestampData = new ArrayList<TotalEntitiesByTier>();
            double totalEntityCount = 0.0;
            String dateTimeString = timestampBucket.getKeyAsString();
            Long timestamp = this.convertDatTimeStringToTimestamp(dateTimeString);
            MultiBucketsAggregation entityTypeBuckets = (MultiBucketsAggregation)timestampBucket.getAggregations().get("entityTier");
            for (MultiBucketsAggregation.Bucket entityTierBucket : entityTypeBuckets.getBuckets()) {
                String entityTier = entityTierBucket.getKeyAsString();
                Sum sumEntityCount = (Sum)entityTierBucket.getAggregations().get("entityCount");
                timestampData.add(new TotalEntitiesByTier().withTimestamp(timestamp).withEntityTier(entityTier).withEntityCount(Double.valueOf(sumEntityCount.getValue())));
                totalEntityCount += sumEntityCount.getValue();
            }
            for (TotalEntitiesByTier el : timestampData) {
                if (totalEntityCount != 0.0) {
                    el.withEntityCountFraction(Double.valueOf(el.getEntityCount() / totalEntityCount));
                } else {
                    el.withEntityCountFraction(Double.valueOf(Double.NaN));
                }
                data.add(el);
            }
        }
        return data;
    }
}

