/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.openSearch;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.dataInsight.type.TotalEntitiesByType;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.search.aggregations.bucket.histogram.Histogram;
import org.opensearch.search.aggregations.metrics.Sum;

public class OsTotalEntitiesAggregator
extends DataInsightAggregatorInterface {
    public OsTotalEntitiesAggregator(Aggregations aggregations, DataInsightChartResult.DataInsightChartType dataInsightChartType) {
        super(aggregations, dataInsightChartType);
    }

    @Override
    public DataInsightChartResult process() throws ParseException {
        List<Object> data = this.aggregate();
        return new DataInsightChartResult().withData(data).withChartType(this.dataInsightChartType);
    }

    @Override
    public List<Object> aggregate() throws ParseException {
        Histogram timestampBuckets = (Histogram)this.aggregationsOs.get("timestamp");
        ArrayList<Object> data = new ArrayList<Object>();
        ArrayList<Double> entityCount = new ArrayList<Double>();
        for (Histogram.Bucket timestampBucket : timestampBuckets.getBuckets()) {
            String dateTimeString = timestampBucket.getKeyAsString();
            Long l = this.convertDatTimeStringToTimestamp(dateTimeString);
            MultiBucketsAggregation entityTypeBuckets = (MultiBucketsAggregation)timestampBucket.getAggregations().get("entityType");
            for (MultiBucketsAggregation.Bucket entityTypeBucket : entityTypeBuckets.getBuckets()) {
                String entityType = entityTypeBucket.getKeyAsString();
                Sum sumEntityCount = (Sum)entityTypeBucket.getAggregations().get("entityCount");
                data.add(new TotalEntitiesByType().withTimestamp(l).withEntityType(entityType).withEntityCount(Double.valueOf(sumEntityCount.getValue())));
                entityCount.add(sumEntityCount.getValue());
            }
        }
        double totalEntities = entityCount.stream().mapToDouble(v -> v).sum();
        for (Object e : data) {
            TotalEntitiesByType el = (TotalEntitiesByType)e;
            el.withEntityCountFraction(Double.valueOf(el.getEntityCount() / totalEntities));
        }
        return data;
    }
}

