/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.decorators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.ChangeEventConfig;
import org.openmetadata.service.events.subscription.AlertsRuleEvaluator;
import org.openmetadata.service.events.subscription.email.EmailMessage;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.util.FormatterUtil;
import org.openmetadata.service.resources.feeds.MessageParser;

public class EmailMessageDecorator
implements MessageDecorator<EmailMessage> {
    @Override
    public String getBold() {
        return "<b>%s</b>";
    }

    @Override
    public String getLineBreak() {
        return " <br/> ";
    }

    @Override
    public String getAddMarker() {
        return "<b>";
    }

    @Override
    public String getAddMarkerClose() {
        return "</b>";
    }

    @Override
    public String getRemoveMarker() {
        return "<s>";
    }

    @Override
    public String getRemoveMarkerClose() {
        return "</s>";
    }

    @Override
    public String getEntityUrl(String entityType, String fqn) {
        return String.format("<a href = '%s/%s/%s'>%s</a>", ChangeEventConfig.getInstance().getOmUri(), entityType, fqn.trim(), fqn.trim());
    }

    @Override
    public EmailMessage buildMessage(ChangeEvent event) throws IOException {
        EmailMessage emailMessage = new EmailMessage();
        emailMessage.setUserName(event.getUserName());
        if (event.getEntity() != null) {
            emailMessage.setUpdatedBy(event.getUserName());
            if (event.getEntityType().equals("query")) {
                emailMessage.setEntityUrl("query");
            } else {
                emailMessage.setEntityUrl(this.getEntityUrl(event.getEntityType(), event.getEntityFullyQualifiedName()));
            }
        }
        Map<MessageParser.EntityLink, String> messages = FormatterUtil.getFormattedMessages(this, event.getChangeDescription(), AlertsRuleEvaluator.getEntity(event));
        ArrayList<String> changeMessage = new ArrayList<String>();
        for (Map.Entry<MessageParser.EntityLink, String> entry : messages.entrySet()) {
            changeMessage.add(entry.getValue());
        }
        emailMessage.setChangeMessage(changeMessage);
        return emailMessage;
    }
}

