/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.Bot;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BotRepository
extends EntityRepository<Bot> {
    private static final Logger LOG = LoggerFactory.getLogger(BotRepository.class);
    static final String BOT_UPDATE_FIELDS = "botUser";

    public BotRepository(CollectionDAO dao) {
        super("/v1/bots/", "bot", Bot.class, dao.botDAO(), dao, "", BOT_UPDATE_FIELDS);
        this.quoteFqn = true;
    }

    @Override
    public Bot setFields(Bot entity, EntityUtil.Fields fields) {
        return entity.withBotUser(this.getBotUser(entity));
    }

    @Override
    public Bot clearFields(Bot entity, EntityUtil.Fields fields) {
        return entity;
    }

    @Override
    public void prepare(Bot entity) {
        User user = (User)Entity.getEntity(entity.getBotUser(), "", Include.ALL);
        entity.withBotUser(user.getEntityReference());
    }

    @Override
    public void storeEntity(Bot entity, boolean update) {
        EntityReference botUser = entity.getBotUser();
        entity.withBotUser(null);
        this.store(entity, update);
        entity.withBotUser(botUser);
    }

    @Override
    public void storeRelationships(Bot entity) {
        this.addRelationship(entity.getId(), entity.getBotUser().getId(), "bot", "user", Relationship.CONTAINS);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Bot original, Bot updated, EntityRepository.Operation operation) {
        return new BotUpdater(original, updated, operation);
    }

    @Override
    public void restorePatchAttributes(Bot original, Bot updated) {
        updated.withBotUser(original.getBotUser());
    }

    public EntityReference getBotUser(Bot bot) {
        return bot.getBotUser() != null ? bot.getBotUser() : this.getToEntityRef(bot.getId(), Relationship.CONTAINS, "user", false);
    }

    public class BotUpdater
    extends EntityRepository.EntityUpdater {
        public BotUpdater(Bot original, Bot updated, EntityRepository.Operation operation) {
            super((EntityRepository)BotRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() {
            this.updateUser((Bot)this.original, (Bot)this.updated);
        }

        private void updateUser(Bot original, Bot updated) {
            BotRepository.this.deleteTo(original.getBotUser().getId(), "user", Relationship.CONTAINS, "bot");
            BotRepository.this.addRelationship(updated.getId(), updated.getBotUser().getId(), "bot", "user", Relationship.CONTAINS);
            if (original.getBotUser() == null || updated.getBotUser() == null || !updated.getBotUser().getId().equals(original.getBotUser().getId())) {
                this.recordChange(BotRepository.BOT_UPDATE_FIELDS, original.getBotUser(), updated.getBotUser());
            }
        }
    }
}

