/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.util.JsonUtils;

public class ChangeEventRepository {
    private final CollectionDAO.ChangeEventDAO dao;

    public ChangeEventRepository(CollectionDAO dao) {
        this.dao = dao.changeEventDAO();
    }

    @Transaction
    public List<ChangeEvent> list(long timestamp, List<String> entityCreatedList, List<String> entityUpdatedList, List<String> entityRestoredList, List<String> entityDeletedList) throws IOException {
        ArrayList<String> jsons = new ArrayList<String>();
        jsons.addAll(this.dao.list(EventType.ENTITY_CREATED.value(), entityCreatedList, timestamp));
        jsons.addAll(this.dao.list(EventType.ENTITY_UPDATED.value(), entityUpdatedList, timestamp));
        jsons.addAll(this.dao.list(EventType.ENTITY_RESTORED.value(), entityRestoredList, timestamp));
        jsons.addAll(this.dao.list(EventType.ENTITY_DELETED.value(), entityDeletedList, timestamp));
        jsons.addAll(this.dao.list(EventType.ENTITY_SOFT_DELETED.value(), entityDeletedList, timestamp));
        ArrayList<ChangeEvent> changeEvents = new ArrayList<ChangeEvent>();
        for (String json : jsons) {
            changeEvents.add(JsonUtils.readValue(json, ChangeEvent.class));
        }
        return changeEvents;
    }

    @Transaction
    public void deleteAll(String entityType) {
        this.dao.deleteAll(entityType);
    }
}

