/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.List;
import java.util.function.BiPredicate;
import javax.json.JsonPatch;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.DashboardDataModel;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.type.Column;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.TaskDetails;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ColumnUtil;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.resources.databases.DatabaseUtil;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardDataModelRepository
extends EntityRepository<DashboardDataModel> {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardDataModelRepository.class);

    public DashboardDataModelRepository(CollectionDAO dao) {
        super("/v1/dashboard/datamodels", "dashboardDataModel", DashboardDataModel.class, dao.dashboardDataModelDAO(), dao, "", "");
    }

    @Override
    public void setFullyQualifiedName(DashboardDataModel dashboardDataModel) {
        dashboardDataModel.setFullyQualifiedName(FullyQualifiedName.add(dashboardDataModel.getService().getName() + ".model", dashboardDataModel.getName()));
        ColumnUtil.setColumnFQN(dashboardDataModel.getFullyQualifiedName(), dashboardDataModel.getColumns());
    }

    @Override
    public void update(TaskDetails task, MessageParser.EntityLink entityLink, String newValue, String user) {
        if (entityLink.getFieldName().equals("columns")) {
            DashboardDataModel dashboardDataModel = (DashboardDataModel)this.getByName(null, entityLink.getEntityFQN(), this.getFields("columns,tags"), Include.ALL, false);
            String origJson = JsonUtils.pojoToJson(dashboardDataModel);
            Column column = dashboardDataModel.getColumns().stream().filter(c -> c.getName().equals(entityLink.getArrayFieldName())).findFirst().orElseThrow(() -> new IllegalArgumentException(CatalogExceptionMessage.invalidFieldName("column", entityLink.getArrayFieldName())));
            if (EntityUtil.isDescriptionTask(task.getType())) {
                column.setDescription(newValue);
            } else if (EntityUtil.isTagTask(task.getType())) {
                List<TagLabel> tags = JsonUtils.readObjects(newValue, TagLabel.class);
                column.setTags(tags);
            }
            String updatedEntityJson = JsonUtils.pojoToJson(dashboardDataModel);
            JsonPatch patch = JsonUtils.getJsonPatch(origJson, updatedEntityJson);
            this.patch(null, dashboardDataModel.getId(), user, patch);
            return;
        }
        super.update(task, entityLink, newValue, user);
    }

    @Override
    public void prepare(DashboardDataModel dashboardDataModel) {
        DashboardService dashboardService = (DashboardService)Entity.getEntity(dashboardDataModel.getService(), "", Include.ALL);
        dashboardDataModel.setService(dashboardService.getEntityReference());
        dashboardDataModel.setServiceType(dashboardService.getServiceType());
        this.validateColumnTags(dashboardDataModel.getColumns());
    }

    @Override
    public void storeEntity(DashboardDataModel dashboardDataModel, boolean update) {
        EntityReference service = dashboardDataModel.getService();
        dashboardDataModel.withService(null);
        this.store(dashboardDataModel, update);
        dashboardDataModel.withService(service);
    }

    @Override
    public void storeRelationships(DashboardDataModel dashboardDataModel) {
        EntityReference service = dashboardDataModel.getService();
        this.addRelationship(service.getId(), dashboardDataModel.getId(), service.getType(), "dashboardDataModel", Relationship.CONTAINS);
    }

    @Override
    public DashboardDataModel setFields(DashboardDataModel dashboardDataModel, EntityUtil.Fields fields) {
        this.getColumnTags(fields.contains("tags"), dashboardDataModel.getColumns());
        if (dashboardDataModel.getService() == null) {
            dashboardDataModel.withService(this.getContainer(dashboardDataModel.getId()));
        }
        return dashboardDataModel;
    }

    @Override
    public DashboardDataModel clearFields(DashboardDataModel dashboardDataModel, EntityUtil.Fields fields) {
        return dashboardDataModel;
    }

    @Override
    public void restorePatchAttributes(DashboardDataModel original, DashboardDataModel updated) {
        updated.withFullyQualifiedName(original.getFullyQualifiedName()).withName(original.getName()).withService(original.getService()).withId(original.getId());
    }

    private void getColumnTags(boolean setTags, List<Column> columns) {
        for (Column c : CommonUtil.listOrEmpty(columns)) {
            c.setTags((List)(setTags ? this.getTags(c.getFullyQualifiedName()) : c.getTags()));
            this.getColumnTags(setTags, c.getChildren());
        }
    }

    @Override
    private void applyTags(List<Column> columns) {
        for (Column column : columns) {
            this.applyTags(column.getTags(), column.getFullyQualifiedName());
            if (column.getChildren() == null) continue;
            this.applyTags(column.getChildren());
        }
    }

    @Override
    public void applyTags(DashboardDataModel dashboardDataModel) {
        super.applyTags(dashboardDataModel);
        this.applyTags(dashboardDataModel.getColumns());
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(DashboardDataModel original, DashboardDataModel updated, EntityRepository.Operation operation) {
        return new DataModelUpdater(original, updated, operation);
    }

    private void validateColumnTags(List<Column> columns) {
        for (Column column : columns) {
            this.checkMutuallyExclusive(column.getTags());
            if (column.getChildren() == null) continue;
            this.validateColumnTags(column.getChildren());
        }
    }

    public class DataModelUpdater
    extends EntityRepository.ColumnEntityUpdater {
        public DataModelUpdater(DashboardDataModel original, DashboardDataModel updated, EntityRepository.Operation operation) {
            super((EntityRepository)DashboardDataModelRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() {
            DatabaseUtil.validateColumns(((DashboardDataModel)this.original).getColumns());
            this.updateColumns("columns", ((DashboardDataModel)this.original).getColumns(), ((DashboardDataModel)this.updated).getColumns(), (BiPredicate)EntityUtil.columnMatch);
        }
    }
}

