/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Query;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;

public class QueryRepository
extends EntityRepository<Query> {
    private static final String QUERY_USED_IN_FIELD = "queryUsedIn";
    private static final String QUERY_USERS_FIELD = "users";
    private static final String QUERY_USED_BY_FIELD = "usedBy";
    private static final String QUERY_PATCH_FIELDS = "users,query,queryUsedIn";
    private static final String QUERY_UPDATE_FIELDS = "users,votes,queryUsedIn";

    public QueryRepository(CollectionDAO dao) {
        super("v1/queries/", "query", Query.class, dao.queryDAO(), dao, QUERY_PATCH_FIELDS, QUERY_UPDATE_FIELDS);
    }

    @Override
    public Query setFields(Query entity, EntityUtil.Fields fields) {
        entity.setVotes(fields.contains("votes") ? this.getVotes(entity) : entity.getVotes());
        entity.setQueryUsedIn(fields.contains(QUERY_USED_IN_FIELD) ? this.getQueryUsage(entity) : entity.getQueryUsedIn());
        return entity.withUsers(fields.contains(QUERY_USERS_FIELD) ? this.getQueryUsers(entity) : entity.getUsers());
    }

    @Override
    public Query clearFields(Query entity, EntityUtil.Fields fields) {
        entity.withVotes(fields.contains("votes") ? entity.getVotes() : null);
        entity.withQueryUsedIn(fields.contains(QUERY_USED_IN_FIELD) ? entity.getQueryUsedIn() : null);
        return entity.withUsers(fields.contains(QUERY_USERS_FIELD) ? this.getQueryUsers(entity) : null);
    }

    public List<EntityReference> getQueryUsage(Query queryEntity) {
        return queryEntity == null ? Collections.emptyList() : this.findFrom(queryEntity.getId(), "query", Relationship.MENTIONED_IN, null);
    }

    public List<EntityReference> getQueryUsers(Query queryEntity) {
        return queryEntity == null ? Collections.emptyList() : this.findFrom(queryEntity.getId(), "query", Relationship.USES, "user");
    }

    @Override
    public void prepare(Query entity) {
        if (CommonUtil.nullOrEmpty((String)entity.getName())) {
            String checkSum = EntityUtil.hash(entity.getQuery());
            entity.setChecksum(checkSum);
            entity.setName(checkSum);
        }
        entity.setUsers(EntityUtil.populateEntityReferences(entity.getUsers()));
    }

    @Override
    public void storeEntity(Query queryEntity, boolean update) {
        List queryUsage = queryEntity.getQueryUsedIn();
        List queryUsers = queryEntity.getUsers();
        queryEntity.withQueryUsedIn(null).withUsers(null);
        this.store(queryEntity, update);
        queryEntity.withQueryUsedIn(queryUsage).withUsers(queryUsers);
    }

    @Override
    public void storeRelationships(Query queryEntity) {
        if (queryEntity.getUsers() != null) {
            for (EntityReference entityRef : queryEntity.getUsers()) {
                this.addRelationship(entityRef.getId(), queryEntity.getId(), "user", "query", Relationship.USES);
            }
        }
        this.storeQueryUsedIn(queryEntity.getId(), queryEntity.getQueryUsedIn(), null);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Query original, Query updated, EntityRepository.Operation operation) {
        return new QueryUpdater(original, updated, operation);
    }

    private void storeQueryUsedIn(UUID queryId, List<EntityReference> addQueryUsedIn, List<EntityReference> deleteQueryUsedIn) {
        for (EntityReference entityRef : CommonUtil.listOrEmpty(addQueryUsedIn)) {
            this.addRelationship(entityRef.getId(), queryId, entityRef.getType(), "query", Relationship.MENTIONED_IN);
        }
        for (EntityReference entityRef : CommonUtil.listOrEmpty(deleteQueryUsedIn)) {
            this.deleteRelationship(entityRef.getId(), entityRef.getType(), queryId, "query", Relationship.MENTIONED_IN);
        }
    }

    public RestUtil.PutResponse<?> AddQueryUser(UriInfo uriInfo, String updatedBy, UUID queryId, List<String> userFqnList) {
        Query query = (Query)Entity.getEntity("query", queryId, QUERY_USERS_FIELD, Include.NON_DELETED);
        List oldValue = query.getUsers();
        for (String userFqn : userFqnList) {
            User user = (User)Entity.getEntityByName("user", userFqn, "", Include.NON_DELETED);
            EntityReference entityRef = user.getEntityReference();
            this.addRelationship(entityRef.getId(), queryId, entityRef.getType(), "query", Relationship.USES);
        }
        this.setFieldsInternal(query, new EntityUtil.Fields((Set<String>)this.allowedFields, QUERY_USERS_FIELD));
        Entity.withHref(uriInfo, query.getUsers());
        ChangeEvent changeEvent = this.getQueryChangeEvent(updatedBy, QUERY_USERS_FIELD, oldValue, query.getUsers(), this.withHref(uriInfo, query));
        return new RestUtil.PutResponse(Response.Status.CREATED, changeEvent, "entityFieldsChanged");
    }

    public RestUtil.PutResponse<?> AddQueryUsedBy(UriInfo uriInfo, String updatedBy, UUID queryId, List<String> userList) {
        Query query = (Query)Entity.getEntity("query", queryId, QUERY_UPDATE_FIELDS, Include.NON_DELETED);
        Query oldQuery = JsonUtils.readValue(JsonUtils.pojoToJson(query), Query.class);
        query.getUsedBy().addAll(userList);
        ChangeEvent changeEvent = this.getQueryChangeEvent(updatedBy, QUERY_USERS_FIELD, oldQuery.getUsedBy(), query.getUsers(), this.withHref(uriInfo, query));
        this.update(uriInfo, oldQuery, query);
        return new RestUtil.PutResponse(Response.Status.CREATED, changeEvent, "entityFieldsChanged");
    }

    public RestUtil.PutResponse<?> addQueryUsage(UriInfo uriInfo, String updatedBy, UUID queryId, List<EntityReference> entityIds) {
        Query query = (Query)Entity.getEntity("query", queryId, QUERY_USED_IN_FIELD, Include.NON_DELETED);
        List oldValue = query.getQueryUsedIn();
        entityIds.forEach(entityRef -> this.addRelationship(entityRef.getId(), queryId, entityRef.getType(), "query", Relationship.MENTIONED_IN));
        this.setFieldsInternal(query, new EntityUtil.Fields((Set<String>)this.allowedFields, QUERY_USED_IN_FIELD));
        Entity.withHref(uriInfo, query.getQueryUsedIn());
        ChangeEvent changeEvent = this.getQueryChangeEvent(updatedBy, QUERY_USED_IN_FIELD, oldValue, query.getQueryUsedIn(), this.withHref(uriInfo, query));
        return new RestUtil.PutResponse(Response.Status.CREATED, changeEvent, "entityFieldsChanged");
    }

    public RestUtil.PutResponse<?> removeQueryUsedIn(UriInfo uriInfo, String updatedBy, UUID queryId, List<EntityReference> entityIds) {
        Query query = (Query)Entity.getEntity("query", queryId, QUERY_USED_IN_FIELD, Include.NON_DELETED);
        List oldValue = query.getQueryUsedIn();
        for (EntityReference ref : entityIds) {
            this.deleteRelationship(ref.getId(), ref.getType(), queryId, "query", Relationship.MENTIONED_IN);
        }
        this.setFieldsInternal(query, new EntityUtil.Fields((Set<String>)this.allowedFields, QUERY_USED_IN_FIELD));
        Entity.withHref(uriInfo, query.getQueryUsedIn());
        ChangeEvent changeEvent = this.getQueryChangeEvent(updatedBy, QUERY_USED_IN_FIELD, oldValue, query.getQueryUsedIn(), this.withHref(uriInfo, query));
        return new RestUtil.PutResponse(Response.Status.CREATED, changeEvent, "entityFieldsChanged");
    }

    private ChangeEvent getQueryChangeEvent(String updatedBy, String fieldUpdated, Object oldValue, Object newValue, Query updatedQuery) {
        FieldChange fieldChange = new FieldChange().withName(fieldUpdated).withNewValue(newValue).withOldValue(oldValue);
        ChangeDescription change = new ChangeDescription().withPreviousVersion(updatedQuery.getVersion());
        change.getFieldsUpdated().add(fieldChange);
        return new ChangeEvent().withEntity((Object)updatedQuery).withChangeDescription(change).withEventType(EventType.ENTITY_UPDATED).withEntityType(this.entityType).withEntityId(updatedQuery.getId()).withEntityFullyQualifiedName(updatedQuery.getFullyQualifiedName()).withUserName(updatedBy).withTimestamp(Long.valueOf(System.currentTimeMillis())).withCurrentVersion(updatedQuery.getVersion()).withPreviousVersion(updatedQuery.getVersion());
    }

    public class QueryUpdater
    extends EntityRepository.EntityUpdater {
        public QueryUpdater(Query original, Query updated, EntityRepository.Operation operation) {
            super((EntityRepository)QueryRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() {
            String updatedChecksum;
            String originalChecksum;
            this.updateFromRelationships(QueryRepository.QUERY_USERS_FIELD, "user", ((Query)this.original).getUsers(), ((Query)this.updated).getUsers(), Relationship.USES, "query", ((Query)this.original).getId());
            ArrayList<EntityReference> added = new ArrayList<EntityReference>();
            ArrayList<EntityReference> deleted = new ArrayList<EntityReference>();
            this.recordListChange(QueryRepository.QUERY_USED_IN_FIELD, ((Query)this.original).getQueryUsedIn(), ((Query)this.updated).getQueryUsedIn(), added, deleted, EntityUtil.entityReferenceMatch);
            this.recordChange(QueryRepository.QUERY_USED_BY_FIELD, ((Query)this.original).getUsedBy(), ((Query)this.updated).getUsedBy(), true);
            QueryRepository.this.storeQueryUsedIn(((Query)this.updated).getId(), added, deleted);
            if (((Query)this.updated).getQuery() != null && !(originalChecksum = EntityUtil.hash(((Query)this.original).getQuery())).equals(updatedChecksum = EntityUtil.hash(((Query)this.updated).getQuery()))) {
                this.recordChange("query", ((Query)this.original).getQuery(), ((Query)this.updated).getQuery());
                this.recordChange("checkSum", ((Query)this.original).getChecksum(), updatedChecksum);
            }
        }
    }
}

