/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.tests.ResultSummary;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestCaseParameter;
import org.openmetadata.schema.tests.TestCaseParameterValue;
import org.openmetadata.schema.tests.TestDefinition;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.tests.type.TestCaseResult;
import org.openmetadata.schema.tests.type.TestCaseStatus;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.utils.EntityInterfaceUtil;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.EntityTimeSeriesDAO;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;

public class TestCaseRepository
extends EntityRepository<TestCase> {
    private static final String TEST_SUITE_FIELD = "testSuite";
    private static final String TEST_CASE_RESULT_FIELD = "testCaseResult";
    public static final String COLLECTION_PATH = "/v1/dataQuality/testCases";
    private static final String UPDATE_FIELDS = "entityLink,testSuite,testDefinition";
    private static final String PATCH_FIELDS = "entityLink,testSuite,testDefinition";
    public static final String TESTCASE_RESULT_EXTENSION = "testCase.testCaseResult";

    public TestCaseRepository(CollectionDAO dao) {
        super(COLLECTION_PATH, "testCase", TestCase.class, dao.testCaseDAO(), dao, "entityLink,testSuite,testDefinition", "entityLink,testSuite,testDefinition");
    }

    @Override
    public TestCase setFields(TestCase test, EntityUtil.Fields fields) {
        test.setTestSuites(fields.contains("testSuites") ? this.getTestSuites(test) : test.getTestSuites());
        test.setTestSuite(fields.contains(TEST_SUITE_FIELD) ? this.getTestSuite(test) : test.getTestSuite());
        test.setTestDefinition(fields.contains("testDefinition") ? this.getTestDefinition(test) : test.getTestDefinition());
        return test.withTestCaseResult(fields.contains(TEST_CASE_RESULT_FIELD) ? this.getTestCaseResult(test) : test.getTestCaseResult());
    }

    @Override
    public TestCase clearFields(TestCase test, EntityUtil.Fields fields) {
        test.setTestSuites(fields.contains("testSuites") ? test.getTestSuites() : null);
        test.setTestSuite(fields.contains(TEST_SUITE_FIELD) ? test.getTestSuite() : null);
        test.setTestDefinition(fields.contains("testDefinition") ? test.getTestDefinition() : null);
        return test.withTestCaseResult(fields.contains(TEST_CASE_RESULT_FIELD) ? test.getTestCaseResult() : null);
    }

    public RestUtil.PatchResponse<TestCaseResult> patchTestCaseResults(String fqn, Long timestamp, String user, JsonPatch patch) {
        String change = "entityNoChange";
        TestCaseResult original = JsonUtils.readValue(this.daoCollection.dataQualityDataTimeSeriesDao().getExtensionAtTimestamp(fqn, TESTCASE_RESULT_EXTENSION, timestamp), TestCaseResult.class);
        TestCaseResult updated = JsonUtils.applyPatch(original, patch, TestCaseResult.class);
        if (!Objects.equals(original.getTestCaseFailureStatus(), updated.getTestCaseFailureStatus())) {
            updated.getTestCaseFailureStatus().setUpdatedBy(user);
            updated.getTestCaseFailureStatus().setUpdatedAt(Long.valueOf(System.currentTimeMillis()));
            this.daoCollection.dataQualityDataTimeSeriesDao().update(fqn, TESTCASE_RESULT_EXTENSION, JsonUtils.pojoToJson(updated), timestamp);
            change = "entityUpdated";
        }
        return new RestUtil.PatchResponse<TestCaseResult>(Response.Status.OK, updated, change);
    }

    @Override
    public void setFullyQualifiedName(TestCase test) {
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(test.getEntityLink());
        test.setFullyQualifiedName(FullyQualifiedName.add(entityLink.getFullyQualifiedFieldValue(), EntityInterfaceUtil.quoteName((String)test.getName())));
        test.setEntityFQN(entityLink.getFullyQualifiedFieldValue());
    }

    @Override
    public void prepare(TestCase test) {
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(test.getEntityLink());
        EntityUtil.validateEntityLink(entityLink);
        TestSuite testSuite = (TestSuite)Entity.getEntity(test.getTestSuite(), "", Include.NON_DELETED);
        test.setTestSuite(testSuite.getEntityReference());
        TestDefinition testDefinition = (TestDefinition)Entity.getEntity(test.getTestDefinition(), "", Include.NON_DELETED);
        test.setTestDefinition(testDefinition.getEntityReference());
        this.validateTestParameters(test.getParameterValues(), testDefinition.getParameterDefinition());
    }

    private EntityReference getTestSuite(TestCase test) throws EntityNotFoundException {
        List<CollectionDAO.EntityRelationshipRecord> records = this.findFromRecords(test.getId(), this.entityType, Relationship.CONTAINS, TEST_SUITE_FIELD);
        for (CollectionDAO.EntityRelationshipRecord testSuiteId : records) {
            TestSuite testSuite = (TestSuite)Entity.getEntity(TEST_SUITE_FIELD, testSuiteId.getId(), "", Include.ALL);
            if (!Boolean.TRUE.equals(testSuite.getExecutable())) continue;
            return testSuite.getEntityReference();
        }
        throw new EntityNotFoundException(String.format("Error occurred when retrieving executable test suite for testCase %s. ", test.getName()) + "No executable test suite was found.");
    }

    private List<TestSuite> getTestSuites(TestCase test) {
        List<CollectionDAO.EntityRelationshipRecord> records = this.findFromRecords(test.getId(), this.entityType, Relationship.CONTAINS, TEST_SUITE_FIELD);
        return records.stream().map(testSuiteId -> (TestSuite)Entity.getEntity(TEST_SUITE_FIELD, testSuiteId.getId(), "", Include.ALL, false)).collect(Collectors.toList());
    }

    private EntityReference getTestDefinition(TestCase test) {
        return this.getFromEntityRef(test.getId(), Relationship.APPLIED_TO, "testDefinition", true);
    }

    private void validateTestParameters(List<TestCaseParameterValue> parameterValues, List<TestCaseParameter> parameterDefinition) {
        if (parameterValues != null) {
            if (parameterDefinition.isEmpty() && !parameterValues.isEmpty()) {
                throw new IllegalArgumentException("Parameter Values doesn't match Test Definition Parameters");
            }
            HashMap<String, String> values = new HashMap<String, String>();
            for (TestCaseParameterValue testCaseParameterValue : parameterValues) {
                values.put(testCaseParameterValue.getName(), testCaseParameterValue.getValue());
            }
            for (TestCaseParameter parameter : parameterDefinition) {
                if (!Boolean.TRUE.equals(parameter.getRequired()) || values.containsKey(parameter.getName()) && values.get(parameter.getName()) != null) continue;
                throw new IllegalArgumentException("Required parameter " + parameter.getName() + " is not passed in parameterValues");
            }
        }
    }

    @Override
    public void storeEntity(TestCase test, boolean update) {
        EntityReference testSuite = test.getTestSuite();
        EntityReference testDefinition = test.getTestDefinition();
        test.withTestSuite(null).withTestDefinition(null);
        this.store(test, update);
        test.withTestSuite(testSuite).withTestDefinition(testDefinition);
    }

    @Override
    public void storeRelationships(TestCase test) {
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(test.getEntityLink());
        EntityUtil.validateEntityLink(entityLink);
        this.addRelationship(test.getTestSuite().getId(), test.getId(), TEST_SUITE_FIELD, "testCase", Relationship.CONTAINS);
        this.addRelationship(test.getTestDefinition().getId(), test.getId(), "testDefinition", "testCase", Relationship.APPLIED_TO);
    }

    @Transaction
    public RestUtil.PutResponse<?> addTestCaseResult(String updatedBy, UriInfo uriInfo, String fqn, TestCaseResult testCaseResult) {
        TestCase testCase = (TestCase)this.dao.findEntityByName(fqn);
        this.daoCollection.dataQualityDataTimeSeriesDao().insert(testCase.getFullyQualifiedName(), TESTCASE_RESULT_EXTENSION, TEST_CASE_RESULT_FIELD, JsonUtils.pojoToJson(testCaseResult));
        this.setFieldsInternal(testCase, new EntityUtil.Fields((Set<String>)this.allowedFields, TEST_SUITE_FIELD));
        this.setTestSuiteSummary(testCase, testCaseResult.getTimestamp(), testCaseResult.getTestCaseStatus());
        ChangeDescription change = this.addTestCaseChangeDescription(testCase.getVersion(), testCaseResult);
        ChangeEvent changeEvent = this.getChangeEvent(updatedBy, (EntityInterface)this.withHref(uriInfo, testCase), change, this.entityType, testCase.getVersion());
        return new RestUtil.PutResponse(Response.Status.CREATED, changeEvent, "entityFieldsChanged");
    }

    @Transaction
    public RestUtil.PutResponse<?> deleteTestCaseResult(String updatedBy, String fqn, Long timestamp) {
        TestCase testCase = (TestCase)this.dao.findEntityByName(fqn);
        TestCaseResult storedTestCaseResult = JsonUtils.readValue(this.daoCollection.dataQualityDataTimeSeriesDao().getExtensionAtTimestamp(fqn, TESTCASE_RESULT_EXTENSION, timestamp), TestCaseResult.class);
        if (storedTestCaseResult != null) {
            this.daoCollection.dataQualityDataTimeSeriesDao().deleteAtTimestamp(fqn, TESTCASE_RESULT_EXTENSION, timestamp);
            testCase.setTestCaseResult(storedTestCaseResult);
            ChangeDescription change = this.deleteTestCaseChangeDescription(testCase.getVersion(), storedTestCaseResult);
            ChangeEvent changeEvent = this.getChangeEvent(updatedBy, (EntityInterface)testCase, change, this.entityType, testCase.getVersion());
            return new RestUtil.PutResponse(Response.Status.OK, changeEvent, "entityFieldsChanged");
        }
        throw new EntityNotFoundException(String.format("Failed to find testCase result for %s at %s", testCase.getName(), timestamp));
    }

    private ResultSummary getResultSummary(TestCase testCase, Long timestamp, TestCaseStatus testCaseStatus) {
        return new ResultSummary().withTestCaseName(testCase.getFullyQualifiedName()).withStatus(testCaseStatus).withTimestamp(timestamp);
    }

    private void setTestSuiteSummary(TestCase testCase, Long timestamp, TestCaseStatus testCaseStatus) {
        ResultSummary resultSummary = this.getResultSummary(testCase, timestamp, testCaseStatus);
        List<TestSuite> testSuites = this.getTestSuites(testCase);
        for (TestSuite testSuite : testSuites) {
            testSuite.setSummary(null);
            List resultSummaries = CommonUtil.listOrEmpty((List)testSuite.getTestCaseResultSummary());
            if (resultSummaries.isEmpty()) {
                resultSummaries.add(resultSummary);
            } else {
                resultSummaries.removeIf(summary -> summary.getTestCaseName().equals(resultSummary.getTestCaseName()));
                resultSummaries.add(resultSummary);
            }
            testSuite.setTestCaseResultSummary(resultSummaries);
            this.daoCollection.testSuiteDAO().update(testSuite.getId(), testSuite.getFullyQualifiedName(), JsonUtils.pojoToJson(testSuite));
        }
    }

    private ChangeDescription addTestCaseChangeDescription(Double version, Object newValue) {
        FieldChange fieldChange = new FieldChange().withName(TEST_CASE_RESULT_FIELD).withNewValue(newValue);
        ChangeDescription change = new ChangeDescription().withPreviousVersion(version);
        change.getFieldsAdded().add(fieldChange);
        return change;
    }

    private ChangeDescription deleteTestCaseChangeDescription(Double version, Object oldValue) {
        FieldChange fieldChange = new FieldChange().withName(TEST_CASE_RESULT_FIELD).withOldValue(oldValue);
        ChangeDescription change = new ChangeDescription().withPreviousVersion(version);
        change.getFieldsDeleted().add(fieldChange);
        return change;
    }

    private ChangeEvent getChangeEvent(String updatedBy, EntityInterface updated, ChangeDescription change, String entityType, Double prevVersion) {
        return new ChangeEvent().withEntity((Object)updated).withChangeDescription(change).withEventType(EventType.ENTITY_UPDATED).withEntityType(entityType).withEntityId(updated.getId()).withEntityFullyQualifiedName(updated.getFullyQualifiedName()).withUserName(updatedBy).withTimestamp(Long.valueOf(System.currentTimeMillis())).withCurrentVersion(updated.getVersion()).withPreviousVersion(prevVersion);
    }

    private TestCaseResult getTestCaseResult(TestCase testCase) {
        return JsonUtils.readValue(this.daoCollection.dataQualityDataTimeSeriesDao().getLatestExtension(testCase.getFullyQualifiedName(), TESTCASE_RESULT_EXTENSION), TestCaseResult.class);
    }

    public ResultList<TestCaseResult> getTestCaseResults(String fqn, Long startTs, Long endTs) {
        List<TestCaseResult> testCaseResults = JsonUtils.readObjects(this.daoCollection.dataQualityDataTimeSeriesDao().listBetweenTimestampsByOrder(fqn, TESTCASE_RESULT_EXTENSION, startTs, endTs, EntityTimeSeriesDAO.OrderBy.DESC), TestCaseResult.class);
        return new ResultList<TestCaseResult>(testCaseResults, String.valueOf(startTs), String.valueOf(endTs), testCaseResults.size());
    }

    public int getTestCaseCount(List<UUID> testCaseIds) {
        return this.daoCollection.testCaseDAO().countOfTestCases(testCaseIds);
    }

    public void isTestSuiteExecutable(String testSuiteFqn) {
        TestSuite testSuite = (TestSuite)Entity.getEntityByName(TEST_SUITE_FIELD, testSuiteFqn, null, null);
        if (Boolean.FALSE.equals(testSuite.getExecutable())) {
            throw new IllegalArgumentException("Test suite " + testSuite.getName() + " is not executable. Cannot create test cases for non-executable test suites.");
        }
    }

    public RestUtil.PutResponse<TestSuite> addTestCasesToLogicalTestSuite(TestSuite testSuite, List<UUID> testCaseIds) {
        this.bulkAddToRelationship(testSuite.getId(), testCaseIds, TEST_SUITE_FIELD, "testCase", Relationship.CONTAINS);
        ArrayList<EntityReference> testCasesEntityReferences = new ArrayList<EntityReference>();
        List resultSummaries = CommonUtil.listOrEmpty((List)testSuite.getTestCaseResultSummary());
        for (UUID testCaseId : testCaseIds) {
            TestCase testCase = (TestCase)Entity.getEntity("testCase", testCaseId, "", Include.ALL);
            String result = this.daoCollection.dataQualityDataTimeSeriesDao().getLatestExtension(testCase.getFullyQualifiedName(), TESTCASE_RESULT_EXTENSION);
            if (result != null) {
                TestCaseResult testCaseResult = JsonUtils.readValue(result, TestCaseResult.class);
                ResultSummary resultSummary = this.getResultSummary(testCase, testCaseResult.getTimestamp(), testCaseResult.getTestCaseStatus());
                resultSummaries.removeIf(summary -> summary.getTestCaseName().equals(resultSummary.getTestCaseName()));
                resultSummaries.add(resultSummary);
            }
            testCasesEntityReferences.add(new EntityReference().withId(testCase.getId()).withName(testCase.getName()).withFullyQualifiedName(testCase.getFullyQualifiedName()).withDescription(testCase.getDescription()).withDisplayName(testCase.getDisplayName()).withHref(testCase.getHref()).withDeleted(testCase.getDeleted()));
        }
        testSuite.setTestCaseResultSummary(resultSummaries);
        testSuite.setSummary(null);
        this.daoCollection.testSuiteDAO().update(testSuite.getId(), testSuite.getFullyQualifiedName(), JsonUtils.pojoToJson(testSuite));
        testSuite.setTests(testCasesEntityReferences);
        return new RestUtil.PutResponse<TestSuite>(Response.Status.OK, testSuite, "Logical Test Cases Added to Test Suite");
    }

    public RestUtil.DeleteResponse<TestCase> deleteTestCaseFromLogicalTestSuite(UUID testSuiteId, UUID testCaseId) {
        TestCase testCase = (TestCase)Entity.getEntity("testCase", testCaseId, null, null);
        this.deleteRelationship(testSuiteId, TEST_SUITE_FIELD, testCaseId, "testCase", Relationship.CONTAINS);
        this.removeTestCaseFromTestSuiteResultSummary(testSuiteId, testCase.getFullyQualifiedName());
        EntityReference entityReference = Entity.getEntityReferenceById(TEST_SUITE_FIELD, testSuiteId, Include.ALL);
        testCase.setTestSuite(entityReference);
        return new RestUtil.DeleteResponse<TestCase>(testCase, "entityDeleted");
    }

    private void removeTestCaseFromTestSuiteResultSummary(UUID testSuiteId, String testCaseFqn) {
        TestSuite testSuite = (TestSuite)Entity.getEntity(TEST_SUITE_FIELD, testSuiteId, "*", Include.ALL, false);
        testSuite.setSummary(null);
        List resultSummaries = testSuite.getTestCaseResultSummary();
        resultSummaries.removeIf(summary -> summary.getTestCaseName().equals(testCaseFqn));
        testSuite.setTestCaseResultSummary(resultSummaries);
        this.daoCollection.testSuiteDAO().update(testSuite.getId(), testSuite.getFullyQualifiedName(), JsonUtils.pojoToJson(testSuite));
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(TestCase original, TestCase updated, EntityRepository.Operation operation) {
        return new TestUpdater(original, updated, operation);
    }

    @Override
    protected void preDelete(TestCase entity) {
        List<TestSuite> testSuites = this.getTestSuites(entity);
        if (!testSuites.isEmpty()) {
            for (TestSuite testSuite : testSuites) {
                this.removeTestCaseFromTestSuiteResultSummary(testSuite.getId(), entity.getFullyQualifiedName());
            }
        }
    }

    public class TestUpdater
    extends EntityRepository.EntityUpdater {
        public TestUpdater(TestCase original, TestCase updated, EntityRepository.Operation operation) {
            super((EntityRepository)TestCaseRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() {
            MessageParser.EntityLink origEntityLink = MessageParser.EntityLink.parse(((TestCase)this.original).getEntityLink());
            EntityReference origTableRef = EntityUtil.validateEntityLink(origEntityLink);
            MessageParser.EntityLink updatedEntityLink = MessageParser.EntityLink.parse(((TestCase)this.updated).getEntityLink());
            EntityReference updatedTableRef = EntityUtil.validateEntityLink(updatedEntityLink);
            this.updateFromRelationship("entity", updatedTableRef.getType(), origTableRef, updatedTableRef, Relationship.CONTAINS, "testCase", ((TestCase)this.updated).getId());
            this.updateFromRelationship(TestCaseRepository.TEST_SUITE_FIELD, TestCaseRepository.TEST_SUITE_FIELD, ((TestCase)this.original).getTestSuite(), ((TestCase)this.updated).getTestSuite(), Relationship.HAS, "testCase", ((TestCase)this.updated).getId());
            this.updateFromRelationship("testDefinition", "testDefinition", ((TestCase)this.original).getTestDefinition(), ((TestCase)this.updated).getTestDefinition(), Relationship.APPLIED_TO, "testCase", ((TestCase)this.updated).getId());
            this.recordChange("parameterValues", ((TestCase)this.original).getParameterValues(), ((TestCase)this.updated).getParameterValues());
        }
    }
}

