/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.utils;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.database.postgresql.PostgreSQLParser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.resource.filesystem.FileSystemResource;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.sqlscript.SqlStatementIterator;
import org.flywaydb.database.mysql.MySQLParser;
import org.openmetadata.service.jdbi3.MigrationDAO;
import org.openmetadata.service.jdbi3.locator.ConnectionType;
import org.openmetadata.service.util.EntityUtil;

public class MigrationFile
implements Comparable<MigrationFile> {
    public final int[] versionNumbers;
    public final String version;
    public final ConnectionType connectionType;
    public final File dir;
    public final String dbPackageName;
    private final MigrationDAO migrationDAO;
    private final List<String> schemaChanges;
    private final List<String> postDDLScripts;
    public final String DEFAULT_MIGRATION_PROCESS_CLASS = "org.openmetadata.service.migration.api.MigrationProcessImpl";

    public MigrationFile(File dir, MigrationDAO migrationDAO, ConnectionType connectionType) {
        this.dir = dir;
        this.version = dir.getName();
        this.connectionType = connectionType;
        this.migrationDAO = migrationDAO;
        this.dbPackageName = connectionType == ConnectionType.MYSQL ? "mysql" : "postgres";
        this.versionNumbers = this.convertToNumber(this.version);
        this.schemaChanges = new ArrayList<String>();
        this.postDDLScripts = new ArrayList<String>();
    }

    @Override
    public int compareTo(MigrationFile another) {
        return this.compareVersionNumbers(another.versionNumbers);
    }

    public boolean biggerThan(String version) {
        int[] numbers = this.convertToNumber(version);
        int compare = this.compareVersionNumbers(numbers);
        return compare > 0;
    }

    public void parseSQLFiles() {
        String sqlStatement;
        SqlStatementIterator schemaChangesIterator;
        ParsingContext parsingContext = new ParsingContext();
        ClassicConfiguration configuration = new ClassicConfiguration();
        PostgreSQLParser parser = new PostgreSQLParser((Configuration)configuration, parsingContext);
        if (this.connectionType == ConnectionType.MYSQL) {
            parser = new MySQLParser((Configuration)configuration, parsingContext);
        }
        if (new File(this.getSchemaChangesFile()).isFile()) {
            schemaChangesIterator = parser.parse((LoadableResource)new FileSystemResource(null, this.getSchemaChangesFile(), StandardCharsets.UTF_8, true));
            try {
                while (schemaChangesIterator.hasNext()) {
                    sqlStatement = ((SqlStatement)schemaChangesIterator.next()).getSql();
                    if (this.checkIfQueryPreviouslyRan(sqlStatement)) continue;
                    this.schemaChanges.add(sqlStatement);
                }
            }
            finally {
                if (schemaChangesIterator != null) {
                    schemaChangesIterator.close();
                }
            }
        }
        if (new File(this.getPostDDLScriptFile()).isFile()) {
            schemaChangesIterator = parser.parse((LoadableResource)new FileSystemResource(null, this.getPostDDLScriptFile(), StandardCharsets.UTF_8, true));
            try {
                while (schemaChangesIterator.hasNext()) {
                    sqlStatement = ((SqlStatement)schemaChangesIterator.next()).getSql();
                    if (this.checkIfQueryPreviouslyRan(sqlStatement)) continue;
                    this.postDDLScripts.add(sqlStatement);
                }
            }
            finally {
                if (schemaChangesIterator != null) {
                    schemaChangesIterator.close();
                }
            }
        }
    }

    public String getMigrationProcessClassName() {
        String clazzName = String.format("org.openmetadata.service.migration.%s.%s.Migration", this.dbPackageName, this.getVersionPackageName());
        try {
            Class.forName(clazzName);
        }
        catch (ClassNotFoundException e) {
            return "org.openmetadata.service.migration.api.MigrationProcessImpl";
        }
        return clazzName;
    }

    public String getMigrationsFilePath() {
        if (this.connectionType == ConnectionType.MYSQL) {
            return Paths.get(this.dir.getAbsolutePath(), "mysql").toString();
        }
        return Paths.get(this.dir.getAbsolutePath(), "postgres").toString();
    }

    public String getSchemaChangesFile() {
        if (this.connectionType == ConnectionType.MYSQL) {
            return Paths.get(this.dir.getAbsolutePath(), "mysql", "schemaChanges.sql").toString();
        }
        return Paths.get(this.dir.getAbsolutePath(), "postgres", "schemaChanges.sql").toString();
    }

    public String getPostDDLScriptFile() {
        if (this.connectionType == ConnectionType.MYSQL) {
            return Paths.get(this.dir.getAbsolutePath(), "mysql", "postDataMigrationSQLScript.sql").toString();
        }
        return Paths.get(this.dir.getAbsolutePath(), "postgres", "postDataMigrationSQLScript.sql").toString();
    }

    public List<String> getSchemaChanges() {
        return this.schemaChanges;
    }

    public List<String> getPostDDLScripts() {
        return this.postDDLScripts;
    }

    private int[] convertToNumber(String version) {
        String[] split = version.split("\\-")[0].split("\\.");
        int[] numbers = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            numbers[i] = Integer.parseInt(split[i]);
        }
        return numbers;
    }

    private int compareVersionNumbers(int[] another) {
        int maxLength = Math.max(this.versionNumbers.length, another.length);
        for (int i = 0; i < maxLength; ++i) {
            int right;
            int left = i < this.versionNumbers.length ? this.versionNumbers[i] : 0;
            int n = right = i < another.length ? another[i] : 0;
            if (left == right) continue;
            return left < right ? -1 : 1;
        }
        return 0;
    }

    private String getVersionPackageName() {
        StringBuilder arrayAsString = new StringBuilder();
        for (int i = 0; i < this.versionNumbers.length; ++i) {
            arrayAsString.append(this.versionNumbers[i]);
        }
        return "v" + arrayAsString;
    }

    private boolean checkIfQueryPreviouslyRan(String query) {
        String checksum = EntityUtil.hash(query);
        String sqlStatement = this.migrationDAO.checkIfQueryPreviouslyRan(checksum);
        return sqlStatement != null;
    }
}

