/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.utils.V112;

import java.util.List;
import java.util.Set;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.utils.EntityInterfaceUtil;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TestSuiteRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationUtil.class);

    private MigrationUtil() {
    }

    public static void fixExecutableTestSuiteFQN(CollectionDAO collectionDAO) {
        TestSuiteRepository testSuiteRepository = new TestSuiteRepository(collectionDAO);
        List testSuites = testSuiteRepository.listAll(new EntityUtil.Fields(Set.of("id")), new ListFilter(Include.ALL));
        for (TestSuite suite : testSuites) {
            if (!Boolean.TRUE.equals(suite.getExecutable()) || suite.getExecutableEntityReference() == null) continue;
            String tableFQN = suite.getExecutableEntityReference().getFullyQualifiedName();
            String suiteFQN = tableFQN + ".testSuite";
            suite.setName(suiteFQN);
            suite.setFullyQualifiedName(suiteFQN);
            collectionDAO.testSuiteDAO().update((EntityInterface)suite);
        }
    }

    public static void lowerCaseUserNameAndEmail(CollectionDAO daoCollection) {
        LOG.debug("Starting Migration UserName and Email to Lowercase");
        int total = daoCollection.userDAO().listTotalCount();
        int limit = 200;
        for (int offset = 0; offset < total; offset += limit) {
            List<String> userEntities = daoCollection.userDAO().listAfterWithOffset(limit, offset);
            for (String json : userEntities) {
                User userEntity = JsonUtils.readValue(json, User.class);
                userEntity.setFullyQualifiedName(EntityInterfaceUtil.quoteName((String)userEntity.getFullyQualifiedName().toLowerCase()));
                daoCollection.userDAO().update((EntityInterface)userEntity);
            }
        }
        LOG.debug("Completed Migrating UserName and Email to Lowercase");
    }
}

