/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.utils.V114;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TestSuiteRepository;
import org.openmetadata.service.util.EntityUtil;

public class MigrationUtil {
    private MigrationUtil() {
    }

    public static void fixTestSuites(CollectionDAO collectionDAO) {
        TestSuiteRepository testSuiteRepository = new TestSuiteRepository(collectionDAO);
        List testSuites = testSuiteRepository.listAll(new EntityUtil.Fields(Set.of("id")), new ListFilter(Include.ALL));
        for (TestSuite suite : testSuites) {
            if (suite.getExecutableEntityReference() == null || suite.getExecutable().booleanValue() && suite.getFullyQualifiedName().contains("testSuite")) continue;
            String tableFQN = suite.getExecutableEntityReference().getFullyQualifiedName();
            String suiteFQN = tableFQN + ".testSuite";
            suite.setName(suiteFQN);
            suite.setFullyQualifiedName(suiteFQN);
            suite.setExecutable(Boolean.valueOf(true));
            collectionDAO.testSuiteDAO().update((EntityInterface)suite);
        }
        Map<String, ArrayList<TestCase>> testCasesGroupByTable = org.openmetadata.service.migration.utils.v110.MigrationUtil.groupTestCasesByTable(collectionDAO);
        for (String tableFQN : testCasesGroupByTable.keySet()) {
            List testCases = testCasesGroupByTable.get(tableFQN);
            String executableTestSuiteFQN = tableFQN + ".testSuite";
            TestSuite executableTestSuite = (TestSuite)testSuiteRepository.getDao().findEntityByName(executableTestSuiteFQN, "fqnHash", Include.ALL);
            for (TestCase testCase : testCases) {
                List<CollectionDAO.EntityRelationshipRecord> existingRelations = testSuiteRepository.findFromRecords(testCase.getId(), "testCase", Relationship.CONTAINS, "testSuite");
                boolean relationWithExecutableTestSuiteExists = false;
                if (existingRelations != null) {
                    for (CollectionDAO.EntityRelationshipRecord existingTestSuiteRel : existingRelations) {
                        try {
                            TestSuite existingTestSuite = (TestSuite)testSuiteRepository.getDao().findEntityById(existingTestSuiteRel.getId());
                            if (!existingTestSuite.getExecutable().booleanValue() || !existingTestSuite.getFullyQualifiedName().equals(executableTestSuiteFQN)) continue;
                            relationWithExecutableTestSuiteExists = true;
                        }
                        catch (EntityNotFoundException ex) {
                            testSuiteRepository.deleteRelationship(existingTestSuiteRel.getId(), "testSuite", testCase.getId(), "testCase", Relationship.CONTAINS);
                        }
                    }
                }
                if (relationWithExecutableTestSuiteExists) continue;
                testSuiteRepository.addRelationship(executableTestSuite.getId(), testCase.getId(), "testSuite", "testCase", Relationship.CONTAINS);
            }
            List<CollectionDAO.EntityRelationshipRecord> testSuiteRels = testSuiteRepository.findToRecords(executableTestSuite.getExecutableEntityReference().getId(), "table", Relationship.CONTAINS, "testSuite");
            for (CollectionDAO.EntityRelationshipRecord testSuiteRel : testSuiteRels) {
                try {
                    TestSuite relationWithExecutableTestSuiteExists = (TestSuite)testSuiteRepository.getDao().findEntityById(testSuiteRel.getId());
                }
                catch (EntityNotFoundException ex) {
                    testSuiteRepository.deleteRelationship(executableTestSuite.getExecutableEntityReference().getId(), "table", testSuiteRel.getId(), "testSuite", Relationship.CONTAINS);
                }
            }
        }
    }
}

