/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.databases;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.CreateTable;
import org.openmetadata.schema.api.data.CreateTableProfile;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.api.tests.CreateCustomMetric;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.tests.CustomMetric;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.ColumnProfile;
import org.openmetadata.schema.type.DataModel;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.SystemProfile;
import org.openmetadata.schema.type.TableData;
import org.openmetadata.schema.type.TableJoins;
import org.openmetadata.schema.type.TableProfile;
import org.openmetadata.schema.type.TableProfilerConfig;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TableRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.resources.databases.DatabaseUtil;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.ResourceContext;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/tables")
@Tag(name="Tables", description="`Table` organizes data in rows and columns and is defined in a `Database Schema`.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="tables")
public class TableResource
extends EntityResource<Table, TableRepository> {
    public static final String COLLECTION_PATH = "v1/tables/";
    static final String FIELDS = "tableConstraints,tablePartition,usageSummary,owner,customMetrics,tags,followers,joins,viewDefinition,dataModel,extension,testSuite";

    @Override
    public Table addHref(UriInfo uriInfo, Table table) {
        Entity.withHref(uriInfo, table.getDatabaseSchema());
        Entity.withHref(uriInfo, table.getDatabase());
        Entity.withHref(uriInfo, table.getService());
        Entity.withHref(uriInfo, table.getOwner());
        Entity.withHref(uriInfo, table.getFollowers());
        return table;
    }

    public TableResource(CollectionDAO dao, Authorizer authorizer) {
        super(Table.class, new TableRepository(dao), authorizer);
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.allowedFields.add("customMetrics");
        this.addViewOperation("columns,tableConstraints,tablePartition,joins,viewDefinition,dataModel", MetadataOperation.VIEW_BASIC);
        this.addViewOperation("usageSummary", MetadataOperation.VIEW_USAGE);
        this.addViewOperation("customMetrics", MetadataOperation.VIEW_TESTS);
        this.addViewOperation("testSuite", MetadataOperation.VIEW_TESTS);
        return CommonUtil.listOf((Object[])new MetadataOperation[]{MetadataOperation.VIEW_TESTS, MetadataOperation.VIEW_QUERIES, MetadataOperation.VIEW_DATA_PROFILE, MetadataOperation.VIEW_SAMPLE_DATA, MetadataOperation.VIEW_USAGE, MetadataOperation.EDIT_TESTS, MetadataOperation.EDIT_QUERIES, MetadataOperation.EDIT_DATA_PROFILE, MetadataOperation.EDIT_SAMPLE_DATA, MetadataOperation.EDIT_LINEAGE});
    }

    @GET
    @Operation(operationId="listTables", summary="List tables", description="Get a list of tables, optionally filtered by `database` it belongs to. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of tables", content={@Content(mediaType="application/json", schema=@Schema(implementation=TableList.class))})})
    public ResultList<Table> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="tableConstraints,tablePartition,usageSummary,owner,customMetrics,tags,followers,joins,viewDefinition,dataModel,extension,testSuite")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter tables by database fully qualified name", schema=@Schema(type="string", example="snowflakeWestCoast.financeDB")) @QueryParam(value="database") String databaseParam, @Parameter(description="Filter tables by databaseSchema fully qualified name", schema=@Schema(type="string", example="snowflakeWestCoast.financeDB.schema")) @QueryParam(value="databaseSchema") String databaseSchemaParam, @Parameter(description="Include tables with an empty test suite (i.e. no test cases have been created for this table). Default to true", schema=@Schema(type="boolean", example="true")) @QueryParam(value="includeEmptyTestSuite") @DefaultValue(value="true") boolean includeEmptyTestSuite, @Parameter(description="Limit the number tables returned. (1 to 1000000, default = 10) ") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of tables before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of tables after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        ListFilter filter = new ListFilter(include).addQueryParam("database", databaseParam).addQueryParam("databaseSchema", databaseSchemaParam).addQueryParam("includeEmptyTestSuite", includeEmptyTestSuite);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getTableByID", summary="Get a table by Id", description="Get a table by `Id`", responses={@ApiResponse(responseCode="200", description="table", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))}), @ApiResponse(responseCode="404", description="Table for instance {id} is not found")})
    public Table get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="table Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="tableConstraints,tablePartition,usageSummary,owner,customMetrics,tags,followers,joins,viewDefinition,dataModel,extension,testSuite")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Table)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getTableByFQN", summary="Get a table by fully qualified name", description="Get a table by fully qualified table name.", responses={@ApiResponse(responseCode="200", description="table", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))}), @ApiResponse(responseCode="404", description="Table for instance {fqn} is not found")})
    public Table getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fully qualified name of the table", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="tableConstraints,tablePartition,usageSummary,owner,customMetrics,tags,followers,joins,viewDefinition,dataModel,extension,testSuite")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Table)this.getByNameInternal(uriInfo, securityContext, fqn, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllTableVersion", summary="List table versions", description="Get a list of all the versions of a table identified by `Id`", responses={@ApiResponse(responseCode="200", description="List of table versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Table Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificDatabaseVersion", summary="Get a version of the table", description="Get a version of the table by given `Id`", responses={@ApiResponse(responseCode="200", description="table", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))}), @ApiResponse(responseCode="404", description="Table for instance {id} and version {version} is not found")})
    public Table getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Table Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Table version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (Table)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createTable", summary="Create a table", description="Create a new table under an existing `database`.", responses={@ApiResponse(responseCode="200", description="table", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateTable create) {
        Table table = this.getTable(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, table);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateTable", summary="Create or update a table", description="Create a table, if it does not exist. If a table already exists, update the table.", responses={@ApiResponse(responseCode="200", description="The table", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateTable create) {
        Table table = this.getTable(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, table);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchTable", summary="Update a table", description="Update an existing table using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteTable", summary="Delete a table by Id", description="Delete a table by `Id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Table for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @QueryParam(value="recursive") @DefaultValue(value="false") boolean recursive, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete);
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deleteTable", summary="Delete a table by fully qualified name", description="Delete a table by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Table for instance {fqn} is not found")})
    public Response deleteByFqn(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Name of the table", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) {
        return this.deleteByName(uriInfo, securityContext, fqn, false, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted table", description="Restore a soft deleted table.", responses={@ApiResponse(responseCode="200", description="Successfully restored the Table ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Response restoreTable(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    @PUT
    @Path(value="/{id}/followers")
    @Operation(operationId="addFollowerToTable", summary="Add a follower", description="Add a user identified by `userId` as followed of this table", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))}), @ApiResponse(responseCode="404", description="Table for instance {id} is not found")})
    public Response addFollower(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Id of the user to be added as follower", schema=@Schema(type="string")) UUID userId) {
        return ((TableRepository)this.repository).addFollower(securityContext.getUserPrincipal().getName(), id, userId).toResponse();
    }

    @PUT
    @Path(value="/{id}/joins")
    @Operation(operationId="addTableJoinInfo", summary="Add table join information", description="Add information about other tables that this table is joined with. Join information can only be added for the last 30 days starting today.", responses={@ApiResponse(responseCode="200", description="Successfully updated the Table", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))}), @ApiResponse(responseCode="404", description="Table for instance {id} is not found"), @ApiResponse(responseCode="400", description="Date range can only include past 30 days starting today")})
    public Table addJoins(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid TableJoins joins) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_ALL);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        Table table = ((TableRepository)this.repository).addJoins(id, joins);
        return this.addHref(uriInfo, table);
    }

    @PUT
    @Path(value="/{id}/sampleData")
    @Operation(operationId="addSampleData", summary="Add sample data", description="Add sample data to the table.", responses={@ApiResponse(responseCode="200", description="Successfully update the Table", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Table addSampleData(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid TableData tableData) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_SAMPLE_DATA);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        Table table = ((TableRepository)this.repository).addSampleData(id, tableData);
        return this.addHref(uriInfo, table);
    }

    @GET
    @Path(value="/{id}/sampleData")
    @Operation(operationId="getSampleData", summary="Get sample data", description="Get sample data from the table.", responses={@ApiResponse(responseCode="200", description="Successfully update the Table", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Table getSampleData(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.VIEW_SAMPLE_DATA);
        ResourceContext resourceContext = this.getResourceContextById(id);
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        boolean authorizePII = this.authorizer.authorizePII(securityContext, resourceContext.getOwner());
        Table table = ((TableRepository)this.repository).getSampleData(id, authorizePII);
        return this.addHref(uriInfo, table);
    }

    @DELETE
    @Path(value="/{id}/sampleData")
    @Operation(operationId="deleteSampleData", summary="Delete sample data", description="Delete sample data from the table.", responses={@ApiResponse(responseCode="200", description="Successfully update the Table", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Table deleteSampleData(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_SAMPLE_DATA);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        Table table = ((TableRepository)this.repository).deleteSampleData(id);
        return this.addHref(uriInfo, table);
    }

    @PUT
    @Path(value="/{id}/tableProfilerConfig")
    @Operation(operationId="addDataProfilerConfig", summary="Add table profile config", description="Add table profile config to the table.", responses={@ApiResponse(responseCode="200", description="Successfully updated the Table ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Table addDataProfilerConfig(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid TableProfilerConfig tableProfilerConfig) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_DATA_PROFILE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        Table table = ((TableRepository)this.repository).addTableProfilerConfig(id, tableProfilerConfig);
        return this.addHref(uriInfo, table);
    }

    @GET
    @Path(value="/{id}/tableProfilerConfig")
    @Operation(operationId="getDataProfilerConfig", summary="Get table profile config", description="Get table profile config to the table.", responses={@ApiResponse(responseCode="200", description="Successfully updated the Table ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Table getDataProfilerConfig(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.VIEW_DATA_PROFILE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        Table table = (Table)((TableRepository)this.repository).find(id, Include.NON_DELETED);
        return this.addHref(uriInfo, table.withTableProfilerConfig(((TableRepository)this.repository).getTableProfilerConfig(table)));
    }

    @DELETE
    @Path(value="/{id}/tableProfilerConfig")
    @Operation(operationId="delete DataProfilerConfig", summary="Delete table profiler config", description="delete table profile config to the table.", responses={@ApiResponse(responseCode="200", description="Successfully deleted the Table profiler config", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Table deleteDataProfilerConfig(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_DATA_PROFILE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        Table table = ((TableRepository)this.repository).deleteTableProfilerConfig(id);
        return this.addHref(uriInfo, table);
    }

    @GET
    @Path(value="/{fqn}/tableProfile/latest")
    @Operation(operationId="Get the latest table and column profile", summary="Get the latest table profile", description="Get the latest table and column profile ", responses={@ApiResponse(responseCode="200", description="Table with profile and column profile", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Response getLatestTableProfile(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="FQN of the table or column", schema=@Schema(type="String")) @PathParam(value="fqn") String fqn) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.VIEW_DATA_PROFILE);
        ResourceContext resourceContext = this.getResourceContextByName(fqn);
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        boolean authorizePII = this.authorizer.authorizePII(securityContext, resourceContext.getOwner());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)JsonUtils.pojoToJson(((TableRepository)this.repository).getLatestTableProfile(fqn, authorizePII))).build();
    }

    @GET
    @Path(value="/{fqn}/tableProfile")
    @Operation(operationId="list Profiles", summary="List of table profiles", description="Get a list of all the table profiles for the given table fqn, optionally filtered by `extension`, `startTs` and `endTs` of the profile. Use cursor-based pagination to limit the number of entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of table profiles", content={@Content(mediaType="application/json", schema=@Schema(implementation=TableProfileList.class))})})
    public Response listTableProfiles(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="FQN of the table or column", schema=@Schema(type="String")) @PathParam(value="fqn") String fqn, @Parameter(description="Filter table/column profiles after the given start timestamp", schema=@Schema(type="number")) @QueryParam(value="startTs") Long startTs, @Parameter(description="Filter table/column profiles before the given end timestamp", schema=@Schema(type="number")) @QueryParam(value="endTs") Long endTs) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.VIEW_DATA_PROFILE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextByName(fqn));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)JsonUtils.pojoToJson(((TableRepository)this.repository).getTableProfiles(fqn, startTs, endTs))).build();
    }

    @GET
    @Path(value="/{fqn}/columnProfile")
    @Operation(operationId="list column Profiles", summary="List of column profiles", description="Get a list of all the column profiles for the given table fqn, optionally filtered by `extension`, `startTs` and `endTs` of the profile. Use cursor-based pagination to limit the number of entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of table profiles", content={@Content(mediaType="application/json", schema=@Schema(implementation=ColumnProfileList.class))})})
    public ResultList<ColumnProfile> listColumnProfiles(@Context SecurityContext securityContext, @Parameter(description="FQN of the column", schema=@Schema(type="String")) @PathParam(value="fqn") String fqn, @Parameter(description="Filter table/column profiles after the given start timestamp", schema=@Schema(type="number")) @NotNull @QueryParam(value="startTs") Long startTs, @Parameter(description="Filter table/column profiles before the given end timestamp", schema=@Schema(type="number")) @NotNull @QueryParam(value="endTs") Long endTs) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.VIEW_DATA_PROFILE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextByName(fqn));
        return ((TableRepository)this.repository).getColumnProfiles(fqn, startTs, endTs);
    }

    @GET
    @Path(value="/{fqn}/systemProfile")
    @Operation(operationId="list system Profiles", summary="List of system profiles", description="Get a list of all the system profiles for the given table fqn, filtered by `extension`, `startTs` and `endTs` of the profile. Use cursor-based pagination to limit the number of entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of system profiles", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemProfileList.class))})})
    public ResultList<SystemProfile> listSystemProfiles(@Context SecurityContext securityContext, @Parameter(description="FQN of the table", schema=@Schema(type="String")) @PathParam(value="fqn") String fqn, @Parameter(description="Filter system profiles after the given start timestamp", schema=@Schema(type="number")) @NotNull @QueryParam(value="startTs") Long startTs, @Parameter(description="Filter system profiles before the given end timestamp", schema=@Schema(type="number")) @NotNull @QueryParam(value="endTs") Long endTs) {
        return ((TableRepository)this.repository).getSystemProfiles(fqn, startTs, endTs);
    }

    @PUT
    @Path(value="/{id}/tableProfile")
    @Operation(operationId="addDataProfiler", summary="Add table profile data", description="Add table profile data to the table.", responses={@ApiResponse(responseCode="200", description="Successfully updated the Table ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Table addDataProfiler(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid CreateTableProfile createTableProfile) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_DATA_PROFILE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        Table table = ((TableRepository)this.repository).addTableProfileData(id, createTableProfile);
        return this.addHref(uriInfo, table);
    }

    @DELETE
    @Path(value="/{fqn}/{entityType}/{timestamp}/profile")
    @Operation(operationId="deleteDataProfiler", summary="Delete table profile data", description="Delete table profile data to the table.", responses={@ApiResponse(responseCode="200", description="Successfully deleted the Table Profile", content={@Content(mediaType="application/json", schema=@Schema(implementation=TableProfile.class))})})
    public Response deleteDataProfiler(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="FQN of the table or column", schema=@Schema(type="String")) @PathParam(value="fqn") String fqn, @Parameter(description="type of the entity table or column", schema=@Schema(type="String")) @PathParam(value="entityType") String entityType, @Parameter(description="Timestamp of the table profile", schema=@Schema(type="long")) @PathParam(value="timestamp") Long timestamp) {
        OperationContext operationContext = new OperationContext(entityType, MetadataOperation.EDIT_DATA_PROFILE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextByName(fqn));
        ((TableRepository)this.repository).deleteTableProfile(fqn, entityType, timestamp);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/{id}/dataModel")
    @Operation(operationId="addDataModel", summary="Add data modeling information to a table", description="Add data modeling (such as DBT model) information on how the table was created to the table.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Table addDataModel(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="string")) @PathParam(value="id") UUID id, @Valid DataModel dataModel) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_ALL);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        Table table = ((TableRepository)this.repository).addDataModel(id, dataModel);
        return this.addHref(uriInfo, table);
    }

    @PUT
    @Path(value="/{id}/customMetric")
    @Operation(operationId="addCustomMetric", summary="Add column custom metrics", description="Add column custom metrics.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Table addCustomMetric(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid CreateCustomMetric createCustomMetric) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_DATA_PROFILE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        CustomMetric customMetric = this.getCustomMetric(securityContext, createCustomMetric);
        Table table = ((TableRepository)this.repository).addCustomMetric(id, customMetric);
        return this.addHref(uriInfo, table);
    }

    @DELETE
    @Path(value="/{id}/customMetric/{columnName}/{customMetricName}")
    @Operation(operationId="deleteCustomMetric", summary="Delete custom metric from a column", description="Delete a custom metric from a column.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Table.class))})})
    public Table deleteCustomMetric(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="column of the table", schema=@Schema(type="string")) @PathParam(value="columnName") String columnName, @Parameter(description="column Test Type", schema=@Schema(type="string")) @PathParam(value="customMetricName") String customMetricName) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_TESTS);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        Table table = ((TableRepository)this.repository).deleteCustomMetric(id, columnName, customMetricName);
        return this.addHref(uriInfo, table);
    }

    @DELETE
    @Path(value="/{id}/followers/{userId}")
    @Operation(operationId="deleteFollower", summary="Remove a follower", description="Remove the user identified `userId` as a follower of the table.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))})})
    public Response deleteFollower(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the table", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Id of the user being removed as follower", schema=@Schema(type="string")) @PathParam(value="userId") String userId) {
        return ((TableRepository)this.repository).deleteFollower(securityContext.getUserPrincipal().getName(), id, UUID.fromString(userId)).toResponse();
    }

    public static Table validateNewTable(Table table) {
        table.setId(UUID.randomUUID());
        DatabaseUtil.validateConstraints(table.getColumns(), table.getTableConstraints());
        DatabaseUtil.validateTablePartition(table.getColumns(), table.getTablePartition());
        DatabaseUtil.validateViewDefinition(table.getTableType(), table.getViewDefinition());
        DatabaseUtil.validateColumns(table.getColumns());
        return table;
    }

    private Table getTable(CreateTable create, String user) {
        return TableResource.validateNewTable(this.copy(new Table(), (CreateEntity)create, user).withColumns(create.getColumns()).withSourceUrl(create.getSourceUrl()).withTableConstraints(create.getTableConstraints()).withTablePartition(create.getTablePartition()).withTableType(create.getTableType()).withTags(create.getTags()).withFileFormat(create.getFileFormat()).withViewDefinition(create.getViewDefinition()).withTableProfilerConfig(create.getTableProfilerConfig()).withDatabaseSchema(this.getEntityReference("databaseSchema", create.getDatabaseSchema()))).withDatabaseSchema(this.getEntityReference("databaseSchema", create.getDatabaseSchema())).withRetentionPeriod(create.getRetentionPeriod());
    }

    private CustomMetric getCustomMetric(SecurityContext securityContext, CreateCustomMetric create) {
        return new CustomMetric().withId(UUID.randomUUID()).withDescription(create.getDescription()).withName(create.getName()).withColumnName(create.getColumnName()).withOwner(create.getOwner()).withExpression(create.getExpression()).withUpdatedBy(securityContext.getUserPrincipal().getName()).withUpdatedAt(Long.valueOf(System.currentTimeMillis()));
    }

    public static class SystemProfileList
    extends ResultList<SystemProfile> {
    }

    public static class ColumnProfileList
    extends ResultList<ColumnProfile> {
    }

    public static class TableProfileList
    extends ResultList<TableProfile> {
    }

    public static class TableList
    extends ResultList<Table> {
    }
}

