/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.query;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.VoteRequest;
import org.openmetadata.schema.api.data.CreateQuery;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.entity.data.Query;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.Votes;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.QueryRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.mask.PIIMasker;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/queries")
@Tag(name="Queries", description="A `Query` entity represents a SQL query associated with data assets it is run against.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="queries")
public class QueryResource
extends EntityResource<Query, QueryRepository> {
    public static final String COLLECTION_PATH = "v1/queries/";
    static final String FIELDS = "owner,followers,users,votes,tags,queryUsedIn";

    public QueryResource(CollectionDAO dao, Authorizer authorizer) {
        super(Query.class, new QueryRepository(dao), authorizer);
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation("users,votes,queryUsedIn", MetadataOperation.VIEW_BASIC);
        return null;
    }

    @Override
    public Query addHref(UriInfo uriInfo, Query entity) {
        Entity.withHref(uriInfo, entity.getOwner());
        Entity.withHref(uriInfo, entity.getFollowers());
        Entity.withHref(uriInfo, entity.getUsers());
        Entity.withHref(uriInfo, entity.getQueryUsedIn());
        return entity;
    }

    @GET
    @Operation(operationId="listQueries", summary="Get a list of Queries", description="Get a list of queries. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="Get List of queries", content={@Content(mediaType="application/json", schema=@Schema(implementation=QueryList.class))})})
    public ResultList<Query> listQueries(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,followers,users,votes,tags,queryUsedIn")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="UUID of the entity for which to list the Queries", schema=@Schema(type="UUID")) @QueryParam(value="entityId") UUID entityId, @Parameter(description="Limit the number queries returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of queries before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of queries after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after) {
        ListFilter filter = new ListFilter(null);
        if (!CommonUtil.nullOrEmpty((Object)entityId)) {
            filter.addQueryParam("entityId", entityId.toString());
        }
        ResultList<Query> queries = super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
        return PIIMasker.getQueries(queries, this.authorizer, securityContext);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getQueryById", summary="Get a query", description="Get a Query by `id`", responses={@ApiResponse(responseCode="200", description="query", content={@Content(mediaType="application/json", schema=@Schema(implementation=Query.class))}), @ApiResponse(responseCode="404", description="Query for instance {id} is not found")})
    public Query getQueryById(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="query Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,followers,users,votes,tags,queryUsedIn")) @QueryParam(value="fields") String fieldsParam) {
        return (Query)this.getInternal(uriInfo, securityContext, id, fieldsParam, null);
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getQueryFqn", summary="Get a query by name", description="Get a query by fully qualified table name.", responses={@ApiResponse(responseCode="200", description="query", content={@Content(mediaType="application/json", schema=@Schema(implementation=Query.class))}), @ApiResponse(responseCode="404", description="Query for instance {id} is not found")})
    public Query getQueryByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fully qualified name of the query", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,followers,users,votes,tags,queryUsedIn")) @QueryParam(value="fields") String fieldsParam) {
        return (Query)this.getByNameInternal(uriInfo, securityContext, fqn, fieldsParam, null);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllQueryVersion", summary="Get List of all query versions", description="Get a list of all the versions of a query identified by `id`", responses={@ApiResponse(responseCode="200", description="List of query versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Query Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificQueryVersion", summary="Get a specific version of the query", description="Get a version of the query by given `id`", responses={@ApiResponse(responseCode="200", description="query", content={@Content(mediaType="application/json", schema=@Schema(implementation=Query.class))}), @ApiResponse(responseCode="404", description="query for instance {id} and version {version} is not found")})
    public Query getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Query Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Query version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (Query)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createQuery", summary="Create a query", description="Create a query under an existing entity.", responses={@ApiResponse(responseCode="200", description="The query", content={@Content(mediaType="application/json", schema=@Schema(implementation=QueryList.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateQuery create) {
        Query query = this.getQuery(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, query);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateQuery", summary="Create or update a query", description="Create a query, if it does not exist. If a query already exists, update the query.", responses={@ApiResponse(responseCode="200", description="The query", content={@Content(mediaType="application/json", schema=@Schema(implementation=Query.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateQuery create) {
        Query query = this.getQuery(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, query);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchQuery", summary="Update a query", description="Update an existing query using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the query", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @PUT
    @Path(value="/{id}/followers")
    @Operation(operationId="addFollower", summary="Add a follower", description="Add a user identified by `userId` as follower of this model", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))}), @ApiResponse(responseCode="404", description="model for instance {id} is not found")})
    public Response addFollower(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Query", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Id of the user to be added as follower", schema=@Schema(type="UUID")) UUID userId) {
        return ((QueryRepository)this.repository).addFollower(securityContext.getUserPrincipal().getName(), id, userId).toResponse();
    }

    @PUT
    @Path(value="/{id}/vote")
    @Operation(operationId="updateVote", summary="Update Vote for a query", description="Update vote for a query", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))}), @ApiResponse(responseCode="404", description="model for instance {id} is not found")})
    public Response updateVote(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Query", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid VoteRequest request) {
        return ((QueryRepository)this.repository).updateVote(securityContext.getUserPrincipal().getName(), id, request).toResponse();
    }

    @DELETE
    @Path(value="/{id}/followers/{userId}")
    @Operation(operationId="deleteFollower", summary="Remove a follower", description="Remove the user identified `userId` as a follower of the model.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))})})
    public Response deleteFollower(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Query", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Id of the user being removed as follower", schema=@Schema(type="UUID")) @PathParam(value="userId") UUID userId) {
        return ((QueryRepository)this.repository).deleteFollower(securityContext.getUserPrincipal().getName(), id, userId).toResponse();
    }

    @PUT
    @Path(value="/{id}/usage")
    @Operation(operationId="addQueryUsage", summary="Add query usage", description="Add query usage", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Query.class))})})
    public Response addQueryUsage(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the query", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid List<EntityReference> entityIds) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_ALL);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        return ((QueryRepository)this.repository).addQueryUsage(uriInfo, securityContext.getUserPrincipal().getName(), id, entityIds).toResponse();
    }

    @PUT
    @Path(value="/{id}/users")
    @Operation(operationId="addQueryUsers", summary="Add query users", description="Add query users", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Query.class))})})
    public Response addQueryUsers(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the query", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid List<String> userFqnList) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_ALL);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        return ((QueryRepository)this.repository).AddQueryUser(uriInfo, securityContext.getUserPrincipal().getName(), id, userFqnList).toResponse();
    }

    @PUT
    @Path(value="/{id}/usedBy")
    @Operation(operationId="addQueryUsedBy", summary="Populate Used By Field", description="Add query users", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Query.class))})})
    public Response addQueryUsedBy(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the query", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid List<String> usedByList) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_ALL);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        return ((QueryRepository)this.repository).AddQueryUsedBy(uriInfo, securityContext.getUserPrincipal().getName(), id, usedByList).toResponse();
    }

    @DELETE
    @Path(value="/{id}/usage")
    @Operation(operationId="removeQueryUsedIn", summary="remove query used in", description="remove Query Used in", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Query.class))})})
    public Response removeQueryUsedIn(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the query", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid List<EntityReference> entityIds) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.EDIT_ALL);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        return ((QueryRepository)this.repository).removeQueryUsedIn(uriInfo, securityContext.getUserPrincipal().getName(), id, entityIds).toResponse();
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted Query", description="Restore a soft deleted Query.", responses={@ApiResponse(responseCode="200", description="Successfully restored the Query ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Query.class))})})
    public Response restoreQuery(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteQuery", summary="Delete a query", description="Delete a query by `id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Query for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the query", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, false, true);
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deleteQueryByFQN", summary="Delete a query", description="Delete a query by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Query for instance {fqn} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fully qualified name of the location", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) {
        return this.deleteByName(uriInfo, securityContext, fqn, false, true);
    }

    private Query getQuery(CreateQuery create, String user) {
        return this.copy(new Query(), (CreateEntity)create, user).withTags(create.getTags()).withQuery(create.getQuery()).withDuration(create.getDuration()).withVotes(new Votes().withUpVotes(Integer.valueOf(0)).withDownVotes(Integer.valueOf(0))).withUsers(this.getEntityReferences("user", create.getUsers())).withQueryUsedIn(EntityUtil.populateEntityReferences(create.getQueryUsedIn())).withQueryDate(create.getQueryDate());
    }

    public static class QueryList
    extends ResultList<Query> {
    }
}

