/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.system;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.openmetadata.api.configuration.ApplicationConfiguration;
import org.openmetadata.api.configuration.LogoConfiguration;
import org.openmetadata.catalog.security.client.SamlSSOClientConfig;
import org.openmetadata.catalog.type.IdentityProviderConfig;
import org.openmetadata.schema.api.security.AuthenticationConfiguration;
import org.openmetadata.schema.api.security.AuthorizerConfiguration;
import org.openmetadata.schema.settings.SettingsType;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.clients.pipeline.PipelineServiceAPIClientConfig;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.settings.SettingsCache;
import org.openmetadata.service.security.jwt.JWKSResponse;
import org.openmetadata.service.security.jwt.JWTTokenGenerator;

@Path(value="/v1/system/config")
@Tag(name="System", description="APIs related to System configuration and settings.")
@Hidden
@Produces(value={"application/json"})
@Collection(name="config")
public class ConfigResource {
    private OpenMetadataApplicationConfig openMetadataApplicationConfig;
    private final JWTTokenGenerator jwtTokenGenerator = JWTTokenGenerator.getInstance();

    public void initialize(OpenMetadataApplicationConfig config) {
        this.openMetadataApplicationConfig = config;
    }

    @GET
    @Path(value="/auth")
    @Operation(operationId="getAuthConfiguration", summary="Get auth configuration", responses={@ApiResponse(responseCode="200", description="Auth configuration", content={@Content(mediaType="application/json", schema=@Schema(implementation=AuthenticationConfiguration.class))})})
    public AuthenticationConfiguration getAuthConfig() {
        AuthenticationConfiguration authenticationConfiguration = new AuthenticationConfiguration();
        if (this.openMetadataApplicationConfig.getAuthenticationConfiguration() != null) {
            authenticationConfiguration = this.openMetadataApplicationConfig.getAuthenticationConfiguration();
            authenticationConfiguration.setLdapConfiguration(null);
            if (authenticationConfiguration.getSamlConfiguration() != null) {
                SamlSSOClientConfig ssoClientConfig = new SamlSSOClientConfig();
                ssoClientConfig.setIdp(new IdentityProviderConfig().withAuthorityUrl(authenticationConfiguration.getSamlConfiguration().getIdp().getAuthorityUrl()));
                authenticationConfiguration.setSamlConfiguration(ssoClientConfig);
            }
        }
        return authenticationConfiguration;
    }

    @GET
    @Path(value="/customLogoConfiguration")
    @Operation(operationId="getCustomLogoConfiguration", summary="Get Custom Logo configuration", responses={@ApiResponse(responseCode="200", description="Logo Configuration", content={@Content(mediaType="application/json", schema=@Schema(implementation=AuthenticationConfiguration.class))})})
    public LogoConfiguration getCustomLogoConfig() {
        return SettingsCache.getSetting(SettingsType.CUSTOM_LOGO_CONFIGURATION, LogoConfiguration.class);
    }

    @GET
    @Path(value="/authorizer")
    @Operation(operationId="getAuthorizerConfig", summary="Get authorizer configuration", responses={@ApiResponse(responseCode="200", description="Authorizer configuration", content={@Content(mediaType="application/json", schema=@Schema(implementation=AuthorizerConfiguration.class))})})
    public AuthorizerConfiguration getAuthorizerConfig() {
        AuthorizerConfiguration authorizerConfiguration = new AuthorizerConfiguration();
        if (this.openMetadataApplicationConfig.getAuthorizerConfiguration() != null) {
            authorizerConfiguration = this.openMetadataApplicationConfig.getAuthorizerConfiguration();
        }
        return authorizerConfiguration;
    }

    @GET
    @Path(value="/applicationConfig")
    @Operation(operationId="getApplicationConfiguration", summary="Get application configuration", responses={@ApiResponse(responseCode="200", description="Get application configuration", content={@Content(mediaType="application/json", schema=@Schema(implementation=ApplicationConfiguration.class))})})
    public ApplicationConfiguration getApplicationConfiguration() {
        return this.openMetadataApplicationConfig.getApplicationConfiguration();
    }

    @GET
    @Path(value="/pipeline-service-client")
    @Operation(operationId="getAirflowConfiguration", summary="Get airflow configuration", responses={@ApiResponse(responseCode="200", description="Airflow configuration", content={@Content(mediaType="application/json", schema=@Schema(implementation=PipelineServiceAPIClientConfig.class))})})
    public PipelineServiceAPIClientConfig getPipelineServiceConfig() {
        PipelineServiceAPIClientConfig pipelineServiceClientConfigForAPI = new PipelineServiceAPIClientConfig();
        if (this.openMetadataApplicationConfig.getPipelineServiceClientConfiguration() != null) {
            pipelineServiceClientConfigForAPI.setApiEndpoint(this.openMetadataApplicationConfig.getPipelineServiceClientConfiguration().getApiEndpoint());
        }
        return pipelineServiceClientConfigForAPI;
    }

    @GET
    @Path(value="/jwks")
    @Operation(operationId="getJWKSResponse", summary="Get JWKS public key", responses={@ApiResponse(responseCode="200", description="JWKS public key", content={@Content(mediaType="application/json", schema=@Schema(implementation=JWKSResponse.class))})})
    public JWKSResponse getJWKSResponse() {
        return this.jwtTokenGenerator.getJWKSResponse();
    }
}

