/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.openmetadata.annotations.PasswordField;
import org.openmetadata.schema.auth.BasicAuthMechanism;
import org.openmetadata.schema.entity.automations.Workflow;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.security.client.OpenMetadataJWTClientConfig;
import org.openmetadata.schema.security.secrets.SecretsManagerProvider;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.service.exception.CustomExceptionMessage;
import org.openmetadata.service.exception.InvalidServiceConnectionException;
import org.openmetadata.service.exception.SecretsManagerException;
import org.openmetadata.service.fernet.Fernet;
import org.openmetadata.service.secrets.SecretsUtil;
import org.openmetadata.service.secrets.converter.ClassConverterFactory;
import org.openmetadata.service.util.AuthenticationMechanismBuilder;
import org.openmetadata.service.util.IngestionPipelineBuilder;
import org.openmetadata.service.util.ReflectionUtil;

public abstract class SecretsManager {
    private final String clusterPrefix;
    private final SecretsManagerProvider secretsManagerProvider;
    private Fernet fernet;
    private static final Set<Class<?>> DO_NOT_ENCRYPT_CLASSES = Set.of(OpenMetadataJWTClientConfig.class, BasicAuthMechanism.class);

    protected SecretsManager(SecretsManagerProvider secretsManagerProvider, String clusterPrefix) {
        this.secretsManagerProvider = secretsManagerProvider;
        this.clusterPrefix = clusterPrefix;
        this.fernet = Fernet.getInstance();
    }

    public Object encryptServiceConnectionConfig(Object connectionConfig, String connectionType, String connectionName, ServiceType serviceType) {
        try {
            Class<?> clazz = ReflectionUtil.createConnectionConfigClass(connectionType, serviceType);
            Object newConnectionConfig = ClassConverterFactory.getConverter(clazz).convert(connectionConfig);
            return this.encryptPasswordFields(newConnectionConfig, this.buildSecretId(true, serviceType.value(), connectionName), true);
        }
        catch (Exception e) {
            String message = SecretsUtil.buildExceptionMessageConnection(e.getMessage(), connectionType, true);
            if (message != null) {
                throw new InvalidServiceConnectionException(message);
            }
            throw InvalidServiceConnectionException.byMessage(connectionType, String.format("Failed to encrypt connection instance of %s", connectionType));
        }
    }

    public Object decryptServiceConnectionConfig(Object connectionConfig, String connectionType, ServiceType serviceType) {
        try {
            Class<?> clazz = ReflectionUtil.createConnectionConfigClass(connectionType, serviceType);
            Object newConnectionConfig = ClassConverterFactory.getConverter(clazz).convert(connectionConfig);
            return this.decryptPasswordFields(newConnectionConfig);
        }
        catch (Exception e) {
            String message = SecretsUtil.buildExceptionMessageConnection(e.getMessage(), connectionType, false);
            if (message != null) {
                throw new InvalidServiceConnectionException(message);
            }
            throw InvalidServiceConnectionException.byMessage(connectionType, String.format("Failed to encrypt connection instance of %s", connectionType));
        }
    }

    public void encryptAuthenticationMechanism(String name, AuthenticationMechanism authenticationMechanism) {
        if (authenticationMechanism != null) {
            AuthenticationMechanismBuilder.addDefinedConfig(authenticationMechanism);
            try {
                this.encryptPasswordFields(authenticationMechanism, this.buildSecretId(true, "bot", name), true);
            }
            catch (Exception e) {
                throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, String.format("Failed to encrypt user bot instance [%s]", name));
            }
        }
    }

    public void decryptAuthenticationMechanism(String name, AuthenticationMechanism authenticationMechanism) {
        if (authenticationMechanism != null) {
            AuthenticationMechanismBuilder.addDefinedConfig(authenticationMechanism);
            try {
                this.decryptPasswordFields(authenticationMechanism);
            }
            catch (Exception e) {
                throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, String.format("Failed to encrypt user bot instance [%s]", name));
            }
        }
    }

    public void encryptIngestionPipeline(IngestionPipeline ingestionPipeline) {
        OpenMetadataConnection openMetadataConnection = this.encryptOpenMetadataConnection(ingestionPipeline.getOpenMetadataServerConnection(), true);
        ingestionPipeline.setOpenMetadataServerConnection(null);
        IngestionPipelineBuilder.addDefinedConfig(ingestionPipeline);
        try {
            this.encryptPasswordFields(ingestionPipeline, this.buildSecretId(true, "pipeline", ingestionPipeline.getName()), true);
        }
        catch (Exception e) {
            throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, String.format("Failed to encrypt ingestion pipeline instance [%s]", ingestionPipeline.getName()));
        }
        ingestionPipeline.setOpenMetadataServerConnection(openMetadataConnection);
    }

    public void decryptIngestionPipeline(IngestionPipeline ingestionPipeline) {
        OpenMetadataConnection openMetadataConnection = this.decryptOpenMetadataConnection(ingestionPipeline.getOpenMetadataServerConnection(), true);
        ingestionPipeline.setOpenMetadataServerConnection(null);
        IngestionPipelineBuilder.addDefinedConfig(ingestionPipeline);
        try {
            this.decryptPasswordFields(ingestionPipeline);
        }
        catch (Exception e) {
            throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, String.format("Failed to encrypt ingestion pipeline instance [%s]", ingestionPipeline.getName()));
        }
        ingestionPipeline.setOpenMetadataServerConnection(openMetadataConnection);
    }

    public Workflow encryptWorkflow(Workflow workflow) {
        OpenMetadataConnection openMetadataConnection = this.encryptOpenMetadataConnection(workflow.getOpenMetadataServerConnection(), true);
        Workflow workflowConverted = (Workflow)ClassConverterFactory.getConverter(Workflow.class).convert(workflow);
        workflowConverted.setOpenMetadataServerConnection(null);
        try {
            this.encryptPasswordFields(workflowConverted, this.buildSecretId(true, "workflow", workflow.getName()), true);
        }
        catch (Exception e) {
            throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, String.format("Failed to encrypt workflow instance [%s]", workflow.getName()));
        }
        workflowConverted.setOpenMetadataServerConnection(openMetadataConnection);
        return workflowConverted;
    }

    public Workflow decryptWorkflow(Workflow workflow) {
        OpenMetadataConnection openMetadataConnection = this.decryptOpenMetadataConnection(workflow.getOpenMetadataServerConnection(), true);
        Workflow workflowConverted = (Workflow)ClassConverterFactory.getConverter(Workflow.class).convert(workflow);
        workflowConverted.setOpenMetadataServerConnection(null);
        try {
            this.decryptPasswordFields(workflowConverted);
        }
        catch (Exception e) {
            throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, String.format("Failed to encrypt workflow instance [%s]", workflow.getName()));
        }
        workflowConverted.setOpenMetadataServerConnection(openMetadataConnection);
        return workflowConverted;
    }

    public OpenMetadataConnection encryptOpenMetadataConnection(OpenMetadataConnection openMetadataConnection, boolean store) {
        if (openMetadataConnection != null) {
            OpenMetadataConnection openMetadataConnectionConverted = (OpenMetadataConnection)ClassConverterFactory.getConverter(OpenMetadataConnection.class).convert(openMetadataConnection);
            try {
                this.encryptPasswordFields(openMetadataConnectionConverted, this.buildSecretId(true, "serverconnection"), store);
            }
            catch (Exception e) {
                throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, "Failed to encrypt OpenMetadataConnection instance.");
            }
            return openMetadataConnectionConverted;
        }
        return null;
    }

    public OpenMetadataConnection decryptOpenMetadataConnection(OpenMetadataConnection openMetadataConnection, boolean store) {
        if (openMetadataConnection != null) {
            OpenMetadataConnection openMetadataConnectionConverted = (OpenMetadataConnection)ClassConverterFactory.getConverter(OpenMetadataConnection.class).convert(openMetadataConnection);
            try {
                this.decryptPasswordFields(openMetadataConnectionConverted);
            }
            catch (Exception e) {
                throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, "Failed to encrypt OpenMetadataConnection instance.");
            }
            return openMetadataConnectionConverted;
        }
        return null;
    }

    private Object encryptPasswordFields(Object toEncryptObject, String secretId, boolean store) {
        if (!DO_NOT_ENCRYPT_CLASSES.contains(toEncryptObject.getClass())) {
            Arrays.stream(toEncryptObject.getClass().getMethods()).filter(ReflectionUtil::isGetMethodOfObject).forEach(method -> {
                Object obj = ReflectionUtil.getObjectFromMethod(method, toEncryptObject);
                String fieldName = method.getName().replaceFirst("get", "");
                if (obj != null && obj.getClass().getPackageName().startsWith("org.openmetadata")) {
                    this.encryptPasswordFields(obj, this.buildSecretId(false, secretId, fieldName.toLowerCase(Locale.ROOT)), store);
                } else if (obj != null && method.getAnnotation(PasswordField.class) != null) {
                    String newFieldValue = this.storeValue(fieldName, this.fernet.decryptIfApplies((String)obj), secretId, store);
                    Method toSet = ReflectionUtil.getToSetMethod(toEncryptObject, obj, fieldName);
                    ReflectionUtil.setValueInMethod(toEncryptObject, Fernet.isTokenized(newFieldValue) ? newFieldValue : (store ? this.fernet.encrypt(newFieldValue) : newFieldValue), toSet);
                }
            });
        }
        return toEncryptObject;
    }

    private Object decryptPasswordFields(Object toDecryptObject) {
        Arrays.stream(toDecryptObject.getClass().getMethods()).filter(ReflectionUtil::isGetMethodOfObject).forEach(method -> {
            Object obj = ReflectionUtil.getObjectFromMethod(method, toDecryptObject);
            String fieldName = method.getName().replaceFirst("get", "");
            if (obj != null && obj.getClass().getPackageName().startsWith("org.openmetadata")) {
                this.decryptPasswordFields(obj);
            } else if (obj != null && method.getAnnotation(PasswordField.class) != null) {
                String fieldValue = (String)obj;
                Method toSet = ReflectionUtil.getToSetMethod(toDecryptObject, obj, fieldName);
                ReflectionUtil.setValueInMethod(toDecryptObject, Fernet.isTokenized(fieldValue) ? this.fernet.decrypt(fieldValue) : fieldValue, toSet);
            }
        });
        return toDecryptObject;
    }

    protected abstract String storeValue(String var1, String var2, String var3, boolean var4);

    protected String getSecretSeparator() {
        return "/";
    }

    protected boolean startsWithSeparator() {
        return true;
    }

    protected String buildSecretId(boolean addClusterPrefix, String ... secretIdValues) {
        StringBuilder format = new StringBuilder();
        if (addClusterPrefix) {
            format.append(this.startsWithSeparator() ? this.getSecretSeparator() : "");
            format.append(this.clusterPrefix);
        } else {
            format.append("%s");
        }
        Arrays.stream(secretIdValues).skip(addClusterPrefix ? 0L : 1L).forEach(secretIdValue -> {
            if (Objects.isNull(secretIdValue)) {
                throw new SecretsManagerException("Cannot build a secret id with null values.");
            }
            format.append(this.getSecretSeparator());
            format.append("%s");
        });
        return String.format(format.toString(), secretIdValues).toLowerCase();
    }

    @VisibleForTesting
    void setFernet(Fernet fernet) {
        this.fernet = fernet;
    }

    protected abstract void deleteSecretInternal(String var1);

    public void deleteSecretsFromServiceConnectionConfig(Object connectionConfig, String connectionType, String connectionName, ServiceType serviceType) {
        try {
            Class<?> clazz = ReflectionUtil.createConnectionConfigClass(connectionType, serviceType);
            Object newConnectionConfig = ClassConverterFactory.getConverter(clazz).convert(connectionConfig);
            this.deleteSecrets(newConnectionConfig, this.buildSecretId(true, serviceType.value(), connectionName));
        }
        catch (Exception e) {
            String message = SecretsUtil.buildExceptionMessageConnection(e.getMessage(), connectionType, true);
            if (message != null) {
                throw new InvalidServiceConnectionException(message);
            }
            throw InvalidServiceConnectionException.byMessage(connectionType, String.format("Failed to delete secrets from connection instance of %s", connectionType));
        }
    }

    public void deleteSecretsFromWorkflow(Workflow workflow) {
        Workflow workflowConverted = (Workflow)ClassConverterFactory.getConverter(Workflow.class).convert(workflow);
        workflowConverted.setOpenMetadataServerConnection(null);
        try {
            this.deleteSecrets(workflowConverted, this.buildSecretId(true, "workflow", workflow.getName()));
        }
        catch (Exception e) {
            throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, String.format("Failed to delete secrets from workflow instance [%s]", workflow.getName()));
        }
    }

    private void deleteSecrets(Object toDeleteSecretsFrom, String secretId) {
        if (!DO_NOT_ENCRYPT_CLASSES.contains(toDeleteSecretsFrom.getClass())) {
            Arrays.stream(toDeleteSecretsFrom.getClass().getMethods()).filter(ReflectionUtil::isGetMethodOfObject).forEach(method -> {
                Object obj = ReflectionUtil.getObjectFromMethod(method, toDeleteSecretsFrom);
                String fieldName = method.getName().replaceFirst("get", "");
                if (obj != null && obj.getClass().getPackageName().startsWith("org.openmetadata")) {
                    this.deleteSecrets(obj, this.buildSecretId(false, secretId, fieldName.toLowerCase(Locale.ROOT)));
                } else if (obj != null && method.getAnnotation(PasswordField.class) != null) {
                    this.deleteSecretInternal(this.buildSecretId(false, secretId, fieldName.toLowerCase(Locale.ROOT)));
                }
            });
        }
    }

    public String getClusterPrefix() {
        return this.clusterPrefix;
    }

    public SecretsManagerProvider getSecretsManagerProvider() {
        return this.secretsManagerProvider;
    }
}

