/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security;

import com.google.common.collect.ImmutableMap;
import java.security.Principal;
import java.util.Map;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.SecurityContext;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.service.OpenMetadataApplicationConfig;

public final class SecurityUtil {
    public static final String DEFAULT_PRINCIPAL_DOMAIN = "openmetadata.org";

    private SecurityUtil() {
    }

    public static String getUserName(SecurityContext securityContext) {
        Principal principal = securityContext.getUserPrincipal();
        return principal == null ? null : principal.getName().split("[/@]")[0];
    }

    public static Map<String, String> authHeaders(String username) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (username != null) {
            builder.put((Object)"X-Auth-Params-Email", (Object)username);
        }
        return builder.build();
    }

    public static String getPrincipalName(Map<String, String> authHeaders) {
        if (authHeaders == null) {
            return null;
        }
        String principal = authHeaders.get("X-Auth-Params-Email");
        return principal == null ? null : principal.split("@")[0];
    }

    public static String getDomain(OpenMetadataApplicationConfig config) {
        String principalDomain = config.getAuthorizerConfiguration().getPrincipalDomain();
        return CommonUtil.nullOrEmpty((String)principalDomain) ? DEFAULT_PRINCIPAL_DOMAIN : principalDomain;
    }

    public static Invocation.Builder addHeaders(WebTarget target, Map<String, String> headers) {
        if (headers != null) {
            return target.request().header("X-Auth-Params-Email", (Object)headers.get("X-Auth-Params-Email"));
        }
        return target.request();
    }
}

