/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.util.ArrayList;
import org.passay.CharacterData;
import org.passay.CharacterRule;
import org.passay.EnglishCharacterData;
import org.passay.LengthRule;
import org.passay.PasswordData;
import org.passay.PasswordGenerator;
import org.passay.PasswordValidator;
import org.passay.RuleResult;
import org.passay.WhitespaceRule;

public class PasswordUtil {
    private static final PasswordValidator VALIDATOR;

    private PasswordUtil() {
    }

    public static void validatePassword(String pwd) {
        PasswordData password = new PasswordData(pwd);
        RuleResult result = VALIDATOR.validate(password);
        if (!result.isValid()) {
            throw new RuntimeException("Password must be of minimum 8 characters, with one special, one Upper, one lower case character, and one Digit.");
        }
    }

    public static String generateRandomPassword() {
        PasswordGenerator gen = new PasswordGenerator();
        EnglishCharacterData lowerCaseChars = EnglishCharacterData.LowerCase;
        CharacterRule lowerCaseRule = new CharacterRule((CharacterData)lowerCaseChars);
        lowerCaseRule.setNumberOfCharacters(2);
        EnglishCharacterData upperCaseChars = EnglishCharacterData.UpperCase;
        CharacterRule upperCaseRule = new CharacterRule((CharacterData)upperCaseChars);
        upperCaseRule.setNumberOfCharacters(2);
        EnglishCharacterData digitChars = EnglishCharacterData.Digit;
        CharacterRule digitRule = new CharacterRule((CharacterData)digitChars);
        digitRule.setNumberOfCharacters(2);
        CharacterData specialChars = new CharacterData(){

            public String getErrorCode() {
                return "Invalid Special Char";
            }

            public String getCharacters() {
                return "!@#$%^&*()_+";
            }
        };
        CharacterRule splCharRule = new CharacterRule(specialChars);
        splCharRule.setNumberOfCharacters(2);
        return gen.generatePassword(8, new CharacterRule[]{splCharRule, lowerCaseRule, upperCaseRule, digitRule});
    }

    static {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new LengthRule(8, 16));
        rules.add(new WhitespaceRule());
        rules.add(new CharacterRule((CharacterData)EnglishCharacterData.UpperCase, 1));
        rules.add(new CharacterRule((CharacterData)EnglishCharacterData.LowerCase, 1));
        rules.add(new CharacterRule((CharacterData)EnglishCharacterData.Digit, 1));
        rules.add(new CharacterRule((CharacterData)EnglishCharacterData.Special, 1));
        VALIDATOR = new PasswordValidator(rules);
    }
}

