/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.workflows.searchIndex;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.api.CreateEventPublisherJob;
import org.openmetadata.schema.type.IndexMappingLanguage;
import org.openmetadata.service.resources.Reindex;
import org.openmetadata.service.util.ReIndexingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Reindex
public class SearchIndexEvent
implements ContainerResponseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(SearchIndexEvent.class);

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) {
        if (ReIndexingHandler.getInstance() != null) {
            Annotation[] annotations;
            Reindex annotationFromResource = null;
            for (Annotation an : annotations = containerResponseContext.getEntityAnnotations()) {
                if (!(an instanceof Reindex)) continue;
                annotationFromResource = (Reindex)an;
                break;
            }
            if (annotationFromResource != null && !CommonUtil.nullOrEmpty((String)annotationFromResource.entities())) {
                String jobName = annotationFromResource.jobName();
                HashSet<String> entityList = new HashSet<String>(Arrays.asList(annotationFromResource.entities().split(",")));
                CreateEventPublisherJob jobRequest = new CreateEventPublisherJob().withName(jobName).withEntities(entityList).withBatchSize(Integer.valueOf(annotationFromResource.batchSize())).withRecreateIndex(Boolean.valueOf(annotationFromResource.recreateIndex())).withPublisherType(CreateEventPublisherJob.PublisherType.ELASTIC_SEARCH).withRunMode(CreateEventPublisherJob.RunMode.BATCH).withSearchIndexMappingLanguage(IndexMappingLanguage.EN);
                ReIndexingHandler.getInstance().createReindexingJob("system", jobRequest);
            } else {
                LOG.error("[SearchIndexEvent] Reindexing invoked but with wrong info : {}", (Object)annotationFromResource);
            }
        }
    }
}

