/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps;

import com.cronutils.mapper.CronMapper;
import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.util.List;
import org.openmetadata.schema.AppRuntime;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.services.ingestionPipelines.CreateIngestionPipeline;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.schema.entity.app.AppRunRecord;
import org.openmetadata.schema.entity.app.AppType;
import org.openmetadata.schema.entity.app.ScheduleType;
import org.openmetadata.schema.entity.app.ScheduledExecutionContext;
import org.openmetadata.schema.entity.applications.configuration.ApplicationConfig;
import org.openmetadata.schema.entity.services.MetadataService;
import org.openmetadata.schema.entity.services.ingestionPipelines.AirflowConfig;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineType;
import org.openmetadata.schema.metadataIngestion.ApplicationPipeline;
import org.openmetadata.schema.metadataIngestion.SourceConfig;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.apps.NativeApplication;
import org.openmetadata.service.apps.scheduler.AppScheduler;
import org.openmetadata.service.apps.scheduler.OmAppJobListener;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.IngestionPipelineRepository;
import org.openmetadata.service.jdbi3.MetadataServiceRepository;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.OpenMetadataConnectionBuilder;
import org.quartz.JobExecutionContext;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractNativeApplication
implements NativeApplication {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNativeApplication.class);
    protected CollectionDAO collectionDAO;
    private App app;
    protected SearchRepository searchRepository;
    private final CronMapper cronMapper = CronMapper.fromQuartzToUnix();
    private final CronParser cronParser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    private static final String SERVICE_NAME = "OpenMetadata";

    @Override
    public void init(App app, CollectionDAO dao, SearchRepository searchRepository) {
        this.collectionDAO = dao;
        this.searchRepository = searchRepository;
        this.app = app;
    }

    @Override
    public void install() {
        if (this.app.getAppType() == AppType.Internal && this.app.getScheduleType().equals((Object)ScheduleType.Scheduled)) {
            this.scheduleInternal();
        } else if (this.app.getAppType() == AppType.External && this.app.getScheduleType().equals((Object)ScheduleType.Scheduled)) {
            this.scheduleExternal();
        }
    }

    @Override
    public void triggerOnDemand() {
        if (!this.app.getScheduleType().equals((Object)ScheduleType.Scheduled)) {
            throw new IllegalArgumentException("Live Application cannot scheduled.");
        }
        AppRuntime runtime = AbstractNativeApplication.getAppRuntime(this.app);
        this.validateServerExecutableApp(runtime);
        AppScheduler.getInstance().triggerOnDemandApplication(this.app);
    }

    public void scheduleInternal() {
        AppRuntime runtime = (AppRuntime)JsonUtils.convertValue(this.app.getRuntime(), ScheduledExecutionContext.class);
        this.validateServerExecutableApp(runtime);
        AppScheduler.getInstance().addApplicationSchedule(this.app);
    }

    public void scheduleExternal() {
        IngestionPipelineRepository ingestionPipelineRepository = (IngestionPipelineRepository)Entity.getEntityRepository("ingestionPipeline");
        try {
            this.bindExistingIngestionToApplication(ingestionPipelineRepository);
        }
        catch (EntityNotFoundException ex) {
            ApplicationConfig config = JsonUtils.convertValue(this.getApp().getAppConfiguration(), ApplicationConfig.class);
            this.createAndBindIngestionPipeline(ingestionPipelineRepository, config);
        }
    }

    private void bindExistingIngestionToApplication(IngestionPipelineRepository ingestionPipelineRepository) {
        String fqn = FullyQualifiedName.add(SERVICE_NAME, this.getApp().getName());
        IngestionPipeline storedPipeline = (IngestionPipeline)ingestionPipelineRepository.getByName(null, fqn, ingestionPipelineRepository.getFields("id"));
        List<CollectionDAO.EntityRelationshipRecord> records = this.collectionDAO.relationshipDAO().findTo(this.getApp().getId(), "app", Relationship.HAS.ordinal(), "ingestionPipeline");
        if (records.isEmpty()) {
            this.collectionDAO.relationshipDAO().insert(this.getApp().getId(), storedPipeline.getId(), "app", "ingestionPipeline", Relationship.HAS.ordinal());
        }
    }

    private void createAndBindIngestionPipeline(IngestionPipelineRepository ingestionPipelineRepository, ApplicationConfig config) {
        MetadataServiceRepository serviceEntityRepository = (MetadataServiceRepository)Entity.getEntityRepository("metadataService");
        EntityReference service = ((MetadataService)serviceEntityRepository.getByName(null, SERVICE_NAME, serviceEntityRepository.getFields("id"))).getEntityReference();
        Cron quartzCron = this.getCronParser().parse(this.getApp().getAppSchedule().getCronExpression());
        CreateIngestionPipeline createPipelineRequest = new CreateIngestionPipeline().withName(this.getApp().getName()).withDisplayName(this.getApp().getDisplayName()).withDescription(this.getApp().getDescription()).withPipelineType(PipelineType.APPLICATION).withSourceConfig(new SourceConfig().withConfig((Object)new ApplicationPipeline().withSourcePythonClass(this.getApp().getSourcePythonClass()).withAppConfig((Object)config))).withAirflowConfig(new AirflowConfig().withScheduleInterval(this.getCronMapper().map(quartzCron).asString())).withService(service);
        IngestionPipeline ingestionPipeline = this.getIngestionPipeline(createPipelineRequest, String.format("%sBot", this.getApp().getName()), "admin").withProvider(ProviderType.USER);
        ingestionPipelineRepository.setFullyQualifiedName(ingestionPipeline);
        ingestionPipelineRepository.initializeEntity(ingestionPipeline);
        this.collectionDAO.relationshipDAO().insert(this.getApp().getId(), ingestionPipeline.getId(), "app", "ingestionPipeline", Relationship.HAS.ordinal());
    }

    protected void validateServerExecutableApp(AppRuntime context) {
        if (!this.app.getAppType().equals((Object)AppType.Internal)) {
            throw new IllegalArgumentException("Application cannot be executed internally in Server. Please check if the App supports internal Server Execution.");
        }
        if (context == null || !Boolean.TRUE.equals(context.getEnabled())) {
            throw new IllegalArgumentException("Applications does not support on demand execution or the context is not Internal.");
        }
    }

    public void execute(JobExecutionContext jobExecutionContext) {
        App jobApp = (App)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"applicationInfoKey");
        CollectionDAO dao = (CollectionDAO)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"daoKey");
        SearchRepository searchRepositoryForJob = (SearchRepository)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"searchClientKey");
        this.init(jobApp, dao, searchRepositoryForJob);
        this.startApp(jobExecutionContext);
    }

    @Override
    public void configure() {
    }

    public static AppRuntime getAppRuntime(App app) {
        return (AppRuntime)JsonUtils.convertValue(app.getRuntime(), ScheduledExecutionContext.class);
    }

    protected IngestionPipeline getIngestionPipeline(CreateIngestionPipeline create, String botName, String user) {
        IngestionPipelineRepository ingestionPipelineRepository = (IngestionPipelineRepository)Entity.getEntityRepository("ingestionPipeline");
        OpenMetadataConnection openMetadataServerConnection = new OpenMetadataConnectionBuilder(ingestionPipelineRepository.getOpenMetadataApplicationConfig(), botName).build();
        return ingestionPipelineRepository.copy(new IngestionPipeline(), (CreateEntity)create, user).withPipelineType(create.getPipelineType()).withAirflowConfig(create.getAirflowConfig()).withOpenMetadataServerConnection(openMetadataServerConnection).withSourceConfig(create.getSourceConfig()).withLoggerLevel(create.getLoggerLevel()).withService(create.getService());
    }

    private OmAppJobListener getJobListener(JobExecutionContext jobExecutionContext) throws SchedulerException {
        return (OmAppJobListener)jobExecutionContext.getScheduler().getListenerManager().getJobListener("OM_JOB_LISTENER");
    }

    protected AppRunRecord getJobRecord(JobExecutionContext jobExecutionContext) {
        OmAppJobListener listener = this.getJobListener(jobExecutionContext);
        return listener.getAppRunRecordForJob(jobExecutionContext);
    }

    protected void pushAppStatusUpdates(JobExecutionContext jobExecutionContext, AppRunRecord appRecord, boolean update) {
        OmAppJobListener listener = this.getJobListener(jobExecutionContext);
        listener.pushApplicationStatusUpdates(jobExecutionContext, appRecord, update);
    }

    public App getApp() {
        return this.app;
    }

    public CronMapper getCronMapper() {
        return this.cronMapper;
    }

    public CronParser getCronParser() {
        return this.cronParser;
    }
}

