/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.changeEvent.generic;

import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import org.apache.commons.lang3.tuple.Pair;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.SubscriptionAction;
import org.openmetadata.schema.entity.events.SubscriptionDestination;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Webhook;
import org.openmetadata.service.apps.bundles.changeEvent.Destination;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.security.SecurityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.SubscriptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPublisher
implements Destination<ChangeEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(GenericPublisher.class);
    private final Client client;
    private final Webhook webhook;
    private final SubscriptionDestination subscriptionDestination;

    public GenericPublisher(SubscriptionDestination subscription) {
        if (subscription.getType() != SubscriptionDestination.SubscriptionType.GENERIC) {
            throw new IllegalArgumentException("GenericWebhook Alert Invoked with Illegal Type and Settings.");
        }
        this.subscriptionDestination = subscription;
        this.webhook = JsonUtils.convertValue(subscription.getConfig(), Webhook.class);
        this.client = SubscriptionUtil.getClient(subscription.getTimeout(), subscription.getReadTimeout());
    }

    @Override
    public void sendMessage(ChangeEvent event) throws EventPublisherException {
        long attemptTime = System.currentTimeMillis();
        try {
            String json = JsonUtils.pojoToJson(event);
            if (this.webhook.getEndpoint() != null) {
                if (this.webhook.getSecretKey() != null && !this.webhook.getSecretKey().isEmpty()) {
                    String hmac = "sha256=" + CommonUtil.calculateHMAC((String)this.webhook.getSecretKey(), (String)json);
                    SubscriptionUtil.postWebhookMessage(this, this.getTarget().header("X-OM-Signature", (Object)hmac), json);
                } else {
                    SubscriptionUtil.postWebhookMessage(this, this.getTarget(), json);
                }
            }
            String eventJson = JsonUtils.pojoToJson(event);
            List<Invocation.Builder> targets = SubscriptionUtil.getTargetsForWebhook((SubscriptionAction)this.webhook, SubscriptionDestination.SubscriptionType.GENERIC, this.client, event);
            for (Invocation.Builder actionTarget : targets) {
                SubscriptionUtil.postWebhookMessage(this, actionTarget, eventJson);
            }
        }
        catch (Exception ex) {
            Throwable cause = ex.getCause();
            String message = "";
            if (cause != null && cause.getClass() == UnknownHostException.class) {
                message = String.format("Unknown Host Exception for Generic Publisher : %s , WebhookEndpoint : %s", this.subscriptionDestination.getId(), this.webhook.getEndpoint());
                LOG.warn(message);
                this.setErrorStatus(attemptTime, 400, "UnknownHostException");
            } else {
                message = CatalogExceptionMessage.eventPublisherFailedToPublish(SubscriptionDestination.SubscriptionType.GENERIC, event, ex.getMessage());
                LOG.error(message);
            }
            throw new EventPublisherException(message, (Pair<UUID, ChangeEvent>)Pair.of((Object)this.subscriptionDestination.getId(), (Object)event));
        }
    }

    private Invocation.Builder getTarget() {
        Map<String, String> authHeaders = SecurityUtil.authHeaders("admin@open-metadata.org");
        return SecurityUtil.addHeaders(this.client.target(this.webhook.getEndpoint()), authHeaders);
    }

    @Override
    public boolean getEnabled() {
        return this.subscriptionDestination.getEnabled();
    }

    @Override
    public void close() {
        if (null != this.client) {
            this.client.close();
        }
    }

    @Override
    public SubscriptionDestination getSubscriptionDestination() {
        return this.subscriptionDestination;
    }
}

