/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.changeEvent.msteams;

import java.util.List;
import java.util.UUID;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import org.apache.commons.lang3.tuple.Pair;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.SubscriptionAction;
import org.openmetadata.schema.entity.events.SubscriptionDestination;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Webhook;
import org.openmetadata.service.apps.bundles.changeEvent.Destination;
import org.openmetadata.service.apps.bundles.changeEvent.msteams.TeamsMessage;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.formatter.decorators.MSTeamsMessageDecorator;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.SubscriptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSTeamsPublisher
implements Destination<ChangeEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(MSTeamsPublisher.class);
    private final MessageDecorator<TeamsMessage> teamsMessageFormatter = new MSTeamsMessageDecorator();
    private final Webhook webhook;
    private Invocation.Builder target;
    private final Client client;
    private final SubscriptionDestination subscriptionDestination;

    public MSTeamsPublisher(SubscriptionDestination subscription) {
        if (subscription.getType() == SubscriptionDestination.SubscriptionType.MS_TEAMS) {
            String msTeamsWebhookURL;
            this.subscriptionDestination = subscription;
            this.webhook = JsonUtils.convertValue(subscription.getConfig(), Webhook.class);
            this.client = SubscriptionUtil.getClient(subscription.getTimeout(), subscription.getReadTimeout());
            if (this.webhook.getEndpoint() != null && !CommonUtil.nullOrEmpty((String)(msTeamsWebhookURL = this.webhook.getEndpoint().toString()))) {
                this.target = this.client.target(msTeamsWebhookURL).request();
            }
        } else {
            throw new IllegalArgumentException("MsTeams Alert Invoked with Illegal Type and Settings.");
        }
    }

    @Override
    public void sendMessage(ChangeEvent event) throws EventPublisherException {
        try {
            TeamsMessage teamsMessage = this.teamsMessageFormatter.buildOutgoingMessage(event);
            List<Invocation.Builder> targets = SubscriptionUtil.getTargetsForWebhook((SubscriptionAction)this.webhook, SubscriptionDestination.SubscriptionType.MS_TEAMS, this.client, event);
            if (this.target != null) {
                targets.add(this.target);
            }
            for (Invocation.Builder actionTarget : targets) {
                SubscriptionUtil.postWebhookMessage(this, actionTarget, teamsMessage);
            }
        }
        catch (Exception e) {
            String message = CatalogExceptionMessage.eventPublisherFailedToPublish(SubscriptionDestination.SubscriptionType.MS_TEAMS, event, e.getMessage());
            LOG.error(message);
            throw new EventPublisherException(message, (Pair<UUID, ChangeEvent>)Pair.of((Object)this.subscriptionDestination.getId(), (Object)event));
        }
    }

    @Override
    public boolean getEnabled() {
        return this.subscriptionDestination.getEnabled();
    }

    @Override
    public void close() {
        if (null != this.client) {
            this.client.close();
        }
    }

    @Override
    public SubscriptionDestination getSubscriptionDestination() {
        return this.subscriptionDestination;
    }
}

