/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.dataInsight;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openmetadata.schema.dataInsight.type.AggregatedUsedVsUnusedAssetsSize;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public abstract class AggregatedUsedvsUnusedAssetsSizeAggregator<A, H, B, S>
implements DataInsightAggregatorInterface {
    private final A aggregations;

    protected AggregatedUsedvsUnusedAssetsSizeAggregator(A aggregations) {
        this.aggregations = aggregations;
    }

    @Override
    public List<Object> aggregate() throws ParseException {
        H histogramBucket = this.getHistogramBucket(this.aggregations);
        ArrayList<Object> data = new ArrayList<Object>();
        for (B bucket : this.getBuckets(histogramBucket)) {
            String dateTimeString = this.getKeyAsString(bucket);
            Long timestamp = this.convertDatTimeStringToTimestamp(dateTimeString);
            S totalUnused = this.getAggregations(bucket, "totalUnused");
            S totalUsed = this.getAggregations(bucket, "totalUsed");
            Optional<Double> used = this.getValue(totalUsed);
            Optional<Double> unused = this.getValue(totalUnused);
            Optional total = used.flatMap(u -> unused.map(uu -> u + uu));
            Double usedPercentage = used.flatMap(u -> total.map(t -> u / t)).orElse(null);
            Double unusedPercentage = unused.flatMap(uu -> total.map(t -> uu / t)).orElse(null);
            data.add(new AggregatedUsedVsUnusedAssetsSize().withTimestamp(timestamp).withUnused((Double)unused.orElse(null)).withUnusedPercentage(unusedPercentage).withUsed((Double)used.orElse(null)).withUsedPercentage(usedPercentage));
        }
        return data;
    }

    protected abstract H getHistogramBucket(A var1);

    protected abstract List<? extends B> getBuckets(H var1);

    protected abstract String getKeyAsString(B var1);

    protected abstract S getAggregations(B var1, String var2);

    protected abstract Optional<Double> getValue(S var1);
}

