/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.dataInsight;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openmetadata.schema.dataInsight.type.PercentageOfEntitiesWithOwnerByType;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public abstract class EntitiesOwnerAggregator<A, B, M, S>
implements DataInsightAggregatorInterface {
    private final A aggregations;

    protected EntitiesOwnerAggregator(A aggregations) {
        this.aggregations = aggregations;
    }

    @Override
    public List<Object> aggregate() throws ParseException {
        M timestampBuckets = this.getTimestampBuckets(this.aggregations);
        ArrayList<Object> data = new ArrayList<Object>();
        for (B timestampBucket : this.getBuckets(timestampBuckets)) {
            String dateTimeString = this.getKeyAsString(timestampBucket);
            Long timestamp = this.convertDatTimeStringToTimestamp(dateTimeString);
            M entityTypeBuckets = this.getEntityBuckets(timestampBucket);
            for (B entityTypeBucket : this.getBuckets(entityTypeBuckets)) {
                String entityType = this.getKeyAsString(entityTypeBucket);
                S sumHasOwner = this.getAggregations(entityTypeBucket, "hasOwnerFraction");
                S sumEntityCount = this.getAggregations(entityTypeBucket, "entityCount");
                Optional<Double> entityCount = this.getValue(sumEntityCount);
                Optional<Double> hasOwner = this.getValue(sumHasOwner);
                Double hasOwnerFraction = hasOwner.flatMap(ho -> entityCount.map(ec -> ho / ec)).orElse(null);
                data.add(new PercentageOfEntitiesWithOwnerByType().withTimestamp(timestamp).withEntityType(entityType).withEntityCount((Double)entityCount.orElse(null)).withHasOwner((Double)hasOwner.orElse(null)).withHasOwnerFraction(hasOwnerFraction));
            }
        }
        return data;
    }

    protected abstract Optional<Double> getValue(S var1);

    protected abstract S getAggregations(B var1, String var2);

    protected abstract M getEntityBuckets(B var1);

    protected abstract String getKeyAsString(B var1);

    protected abstract List<? extends B> getBuckets(M var1);

    protected abstract M getTimestampBuckets(A var1);
}

