/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.dataInsight;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openmetadata.schema.dataInsight.type.MostActiveUsers;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public abstract class MostActiveUsersAggregator<A, B, M, S, X>
implements DataInsightAggregatorInterface {
    private final A aggregations;

    protected MostActiveUsersAggregator(A aggregations) {
        this.aggregations = aggregations;
    }

    @Override
    public List<Object> aggregate() {
        M userNameBuckets = this.getUserNameBuckets(this.aggregations);
        ArrayList<Object> data = new ArrayList<Object>();
        for (B userNameBucket : this.getBuckets(userNameBuckets)) {
            String userName = this.getKeyAsString(userNameBucket);
            S sumSession = this.getSumAggregations(userNameBucket, "sessions");
            S sumPageViews = this.getSumAggregations(userNameBucket, "pageViews");
            S sumSessionDuration = this.getSumAggregations(userNameBucket, "sessionDuration");
            X lastSession = this.getMaxAggregations(userNameBucket, "lastSession");
            M teamBucket = this.getTeamBuckets(userNameBucket);
            String team = null;
            if (!this.getBuckets(teamBucket).isEmpty()) {
                team = this.getKeyAsString(this.getBuckets(teamBucket).get(0));
            }
            Optional<Long> lastSessionOptional = this.getMaxValue(lastSession);
            Optional<Double> sumPageViewsOptional = this.getSumValue(sumPageViews);
            Optional<Double> sumSessionDurationOptional = this.getSumValue(sumSessionDuration);
            Optional<Double> sumSessionOptional = this.getSumValue(sumSession);
            Double avgSessionDuration = sumSessionDurationOptional.flatMap(s -> sumSessionOptional.map(ss -> s / ss)).orElse(null);
            data.add(new MostActiveUsers().withUserName(userName).withLastSession((Long)lastSessionOptional.orElse(null)).withPageViews((Double)sumPageViewsOptional.orElse(null)).withSessionDuration((Double)sumSessionDurationOptional.orElse(null)).withSessions((Double)sumSessionOptional.orElse(null)).withTeam(team).withAvgSessionDuration(avgSessionDuration));
        }
        return data;
    }

    protected abstract Optional<Double> getSumValue(S var1);

    protected abstract Optional<Long> getMaxValue(X var1);

    protected abstract String getKeyAsString(B var1);

    protected abstract S getSumAggregations(B var1, String var2);

    protected abstract X getMaxAggregations(B var1, String var2);

    protected abstract List<? extends B> getBuckets(M var1);

    protected abstract M getUserNameBuckets(A var1);

    protected abstract M getTeamBuckets(B var1);
}

